/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.service;

import com.infinite.focus.server.accesscode.service.AccessCodeService;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.auth.service.StudentAuthService;
import com.infinite.focus.server.avatar.entity.Avatar;
import com.infinite.focus.server.freetrial.request.FreeTrialAccountRequest;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestService;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.model.AppType;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class StudentAuthServiceImpl
implements StudentAuthService {
    @Autowired
    MessageService messageService;
    @Autowired
    AccountService accountService;
    @Autowired
    InstructorService instructorService;
    @Autowired
    SchoolRepository schoolRepository;
    @Autowired
    SocioEmotionalTestService socioEmotionalTestService;
    @Autowired
    AccessCodeService accessCodeService;
    @Autowired
    ClassService classService;
    @Autowired
    ParentService parentService;
    @Autowired
    StudentService studentService;

    public Student createStudentTrialAccount(long instructor_id, long parent_id, FreeTrialAccountRequest request) {
        if (instructor_id > 0L) {
            this.instructorService.isValidInstructor(instructor_id);
        }
        if (parent_id > 0L) {
            this.parentService.isValidParent(parent_id);
        }
        if (AppUtils.isNullOrEmpty((String)request.getFirst_name())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("first.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getLast_name())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("last.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getPassword())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("password.is.null.or.empty"));
        }
        Class c = null;
        if (instructor_id > 0L && !AppUtils.isNullOrEmpty((String)request.getClass_name())) {
            c = this.classService.createClass(instructor_id, request.getClass_name());
        }
        Account account = this.accountService.createAccountByPassword(request.getPassword(), request.getRole_in_organization());
        Student student = new Student();
        student.setAccount(account);
        if (c != null) {
            student.getClasses().add(c);
        }
        student.setFirst_name(request.getFirst_name());
        student.setLast_name(request.getLast_name());
        Instructor instructor = this.instructorService.getInstructorById(instructor_id);
        if (instructor != null) {
            student.setInstructor(instructor);
            School school = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()));
            student.setSchool(school);
        } else {
            student.setInstructor(null);
            student.setSchool(null);
        }
        student.setParent(this.parentService.getParentById(parent_id));
        student.setLanguage(Language.getLanguage());
        Student studentWithRegistrationCode = this.studentService.generateRegistrationCodeForStudent(student);
        Student s = this.studentService.save(studentWithRegistrationCode);
        this.accessCodeService.createAccessCode(s.getStudent_id(), Status.ACCEPTED);
        return s;
    }

    public Student createStudent(String first_name, String last_name, Instructor instructor, Account account, Avatar avatar, Date date_of_birth, String ethnicity, String gender, Standard std, AppType appType, String operating_system, String browser, Parent parent, String clever_id) {
        Student student = new Student();
        student.setFirst_name(first_name);
        student.setLast_name(last_name);
        if (instructor != null) {
            student.setInstructor(instructor);
            School school = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()));
            student.setSchool(school);
        } else {
            student.setInstructor(null);
            student.setSchool(null);
        }
        student.setAccount(account);
        student.setAvatar(avatar);
        student.setDate_of_birth(date_of_birth);
        student.setEthnicity(ethnicity);
        student.setGender(gender);
        student.setStandard(std);
        student.setAppType(appType);
        student.setOperating_system(operating_system);
        student.setBrowser(browser);
        student.setParent(parent);
        student.setClever_id(clever_id);
        student.setLanguage(Language.getLanguage());
        this.socioEmotionalTestService.setShould_auto_show_assessment(student);
        Student studentWithRegistrationCode = this.studentService.generateRegistrationCodeForStudent(student);
        Student s = this.studentService.save(studentWithRegistrationCode);
        this.accessCodeService.createAccessCode(s.getStudent_id(), Status.PENDING);
        return s;
    }

    public Student updateStudent(long student_id, String first_name, String last_name, Instructor instructor, Account account, Avatar avatar, Date date_of_birth, String ethnicity, String gender, Standard std, AppType appType, String operating_system, String browser, Parent parent, String clever_id) {
        Student student = this.studentService.getStudentById(student_id);
        student.setFirst_name(first_name);
        student.setLast_name(last_name);
        if (instructor != null) {
            student.setInstructor(instructor);
            School school = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()));
            student.setSchool(school);
        } else {
            student.setInstructor(null);
            student.setSchool(null);
        }
        student.setAccount(account);
        student.setAvatar(avatar);
        student.setDate_of_birth(date_of_birth);
        student.setEthnicity(ethnicity);
        student.setGender(gender);
        student.setStandard(std);
        student.setAppType(appType);
        student.setOperating_system(operating_system);
        student.setBrowser(browser);
        student.setParent(parent);
        student.setClever_id(clever_id);
        student.setLanguage(Language.getLanguage());
        this.socioEmotionalTestService.setShould_auto_show_assessment(student);
        Student studentWithRegistrationCode = this.studentService.generateRegistrationCodeForStudent(student);
        Student s = this.studentService.save(studentWithRegistrationCode);
        this.accessCodeService.createAccessCode(s.getStudent_id(), Status.PENDING);
        return this.studentService.save(student);
    }
}

