/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.controller;

import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.dashboard.controller.DashboardController;
import com.infinite.focus.server.dashboard.model.LabelAndData;
import com.infinite.focus.server.dashboard.model.LabelAndValue;
import com.infinite.focus.server.dashboard.model.LabelPerLanguage;
import com.infinite.focus.server.dashboard.model.LabelsAndDatasets;
import com.infinite.focus.server.dashboard.request.DatadashboardRequest;
import com.infinite.focus.server.dashboard.request.DropDownsForAnalyticsDataRequest;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.selanalytics.relationshipskills.RelationshipSkillsDataService;
import com.infinite.focus.server.dashboard.selanalytics.responsibledecisionmakingskills.ResponsibleDecisionMakingSkillsDataService;
import com.infinite.focus.server.dashboard.selanalytics.selfawareness.SelfAwarenessDataService;
import com.infinite.focus.server.dashboard.selanalytics.selfmanagement.SelfManagementDataService;
import com.infinite.focus.server.dashboard.selanalytics.socialawareness.SocialAwarenessDataService;
import com.infinite.focus.server.dashboard.service.features.FeaturesService;
import com.infinite.focus.server.dashboard.service.socioemotionalassessment.SocioEmotionalAssessmentService;
import com.infinite.focus.server.dashboard.service.stats.StatsService;
import com.infinite.focus.server.dashboard.service.userstats.UserStatsService;
import com.infinite.focus.server.dashboard.wrapper.DropDownsForAnalyticsDataWrapper;
import com.infinite.focus.server.dataset.model.AssessmentCategory;
import com.infinite.focus.server.dataset.service.DataSetService;
import com.infinite.focus.server.ethnicity.service.EthnicityService;
import com.infinite.focus.server.gender.service.GenderService;
import com.infinite.focus.server.grade.service.GradeService;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.socioemotionaltestquestiontype.service.SocioEmotionalTestQuestionTypeService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/dashboard"})
public class DashboardController {
    @Autowired
    AuthService authService;
    @Autowired
    SchoolRepository schoolRepository;
    @Autowired
    ClassService classService;
    @Autowired
    UserStatsService userStatsService;
    @Autowired
    StatsService statsService;
    @Autowired
    SocioEmotionalAssessmentService socioEmotionalAssessmentService;
    @Autowired
    SelfAwarenessDataService moodDataService;
    @Autowired
    ResponsibleDecisionMakingSkillsDataService responsibleDecisionMakingSkillsDataService;
    @Autowired
    SelfManagementDataService selfManagementDataService;
    @Autowired
    SocialAwarenessDataService socialAwarenessDataService;
    @Autowired
    RelationshipSkillsDataService relationshipSkillsDataService;
    @Autowired
    FeaturesService featuresService;
    @Autowired
    DataSetService dataSetService;
    @Autowired
    ActivityService activityService;
    @Autowired
    GradeService gradeService;
    @Autowired
    SocioEmotionalTestQuestionTypeService socioEmotionalTestQuestionTypeService;
    @Autowired
    GenderService genderService;
    @Autowired
    EthnicityService ethnicityService;
    private List<Integer> ages = Arrays.asList(4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19);
    private static final String LABELS = "labels";
    private static final String DATASET = "dataset";
    private static final String LABEL = "label";
    private static final String DATA = "data";

    @PostMapping(value={"/get/current/timezone/details"})
    public ResponseEntity<LinkedHashMap<String, Object>> getCurrentDetailsTimezoneDetails(@RequestBody GetDataDashBoardRequest request) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        TimeZone timeZone = TimeZone.getTimeZone(request.getZonedDateTime().getZone());
        map.put("timeZone", timeZone);
        map.put("Locale", Locale.getDefault());
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(6L);
        Date lastActivityDate = this.activityService.getLstCreatedActivity().getStart_date_time();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSSZ", Locale.getDefault());
        map.put("fromDate_org", dateFormat.format(request.getFromDate()));
        map.put("toDate_org", dateFormat.format(request.getToDate()));
        map.put("activity_date_org:", dateFormat.format(lastActivityDate));
        dateFormat.setTimeZone(timeZone);
        map.put("fromDate", dateFormat.format(request.getFromDate()));
        map.put("toDate", dateFormat.format(request.getToDate()));
        map.put("activity_date", dateFormat.format(lastActivityDate));
        return new ResponseEntity(map, HttpStatus.OK);
    }

    @PostMapping(value={"/get/dropDownsForAnalyticsData"})
    public ResponseEntity<DropDownsForAnalyticsDataWrapper> getDropDownsForAnalyticsData(@RequestHeader(value="Authorization") String token, @RequestBody(required=false) DropDownsForAnalyticsDataRequest request) {
        Instructor instructor = this.authService.getInstructorByToken(token);
        School school = null;
        if (request != null && request.getSchool_id() != null) {
            List schools = this.authService.getSchoolByToken(token);
            school = !AppUtils.isNullOrEmpty((List)schools) ? (School)schools.stream().filter(item -> item.getSchool_id() == request.getSchool_id().longValue()).findFirst().orElse(null) : this.schoolRepository.findBySchoolId(request.getSchool_id());
        }
        return new ResponseEntity((Object)this.getDropDownsForAnalyticsDataWrapper(school, instructor), HttpStatus.OK);
    }

    @PostMapping(value={"/get/socioEmotionalDataAnalytics"})
    public ResponseEntity<Object> getSocioEmotionalDataAnalytics(@RequestHeader(value="Authorization") String token, @RequestBody DatadashboardRequest datadashboardRequest) {
        System.out.println("FromDate: " + datadashboardRequest.getFromDate() + " ToDate: " + datadashboardRequest.getToDate());
        GetDataDashBoardRequest request = this.getGetDataDashBoardRequest(datadashboardRequest);
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$model$GraphType[request.getGraphType().ordinal()]) {
            case 1: {
                return new ResponseEntity(this.userStatsService.getOverall(request), HttpStatus.OK);
            }
            case 2: {
                return new ResponseEntity(this.userStatsService.getTeachers(request), HttpStatus.OK);
            }
            case 3: {
                return new ResponseEntity(this.userStatsService.getStudents(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 4: {
                GetDataDashBoardRequest defaultRequest = this.getDefaultGetDataDashBoardRequest(request);
                return new ResponseEntity(this.userStatsService.getStudentsAndDemographicStrands(defaultRequest), HttpStatus.OK);
            }
            case 5: {
                return new ResponseEntity(this.userStatsService.getLoginAttemptsStudentsData(request), HttpStatus.OK);
            }
            case 6: {
                return new ResponseEntity((Object)this.userStatsService.getLoginAttemptsStudentsHourlySlotWiseData(request), HttpStatus.OK);
            }
            case 7: {
                return new ResponseEntity(this.userStatsService.getLoginAttemptsTeachersData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 8: {
                return new ResponseEntity(this.userStatsService.getLoginAttemptsTeachersHourlySlotWiseData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 9: {
                return new ResponseEntity(this.userStatsService.getAverageLoginAttemptTeachers(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 10: {
                return new ResponseEntity(this.userStatsService.getPercentageByGrades(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 11: {
                return new ResponseEntity(this.statsService.getTimeSpentByStudents(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 12: {
                return new ResponseEntity(this.statsService.getTimeSpentByTeachers(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 13: {
                return new ResponseEntity(this.statsService.getTimeSpentByDemographicsData(request), HttpStatus.OK);
            }
            case 14: {
                GetDataDashBoardRequest defaultRequest = this.getDefaultGetDataDashBoardRequest(request);
                return new ResponseEntity(this.statsService.getTimeSpentByDemographicData(defaultRequest), HttpStatus.OK);
            }
            case 15: {
                return new ResponseEntity(this.statsService.getTimeSpentByGradesData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 16: {
                return new ResponseEntity(this.statsService.getTimeSpentByGradeData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 17: {
                return new ResponseEntity(this.statsService.getVideoViewList(request), HttpStatus.OK);
            }
            case 18: {
                return new ResponseEntity((Object)this.statsService.getVideosDemographicData(request), HttpStatus.OK);
            }
            case 19: {
                return new ResponseEntity(this.statsService.getPostArticleOrVideoViewList(request), HttpStatus.OK);
            }
            case 20: {
                return new ResponseEntity(this.statsService.getPostArticlesOrVideosDemographicData(request), HttpStatus.OK);
            }
            case 21: {
                return new ResponseEntity(this.statsService.getPostArticleOrVideoViewList(request), HttpStatus.OK);
            }
            case 22: {
                return new ResponseEntity(this.statsService.getPostArticlesOrVideosDemographicData(request), HttpStatus.OK);
            }
            case 23: {
                return new ResponseEntity((Object)this.socioEmotionalAssessmentService.getSELStrandsGraphData(request), HttpStatus.OK);
            }
            case 24: {
                return new ResponseEntity(this.socioEmotionalAssessmentService.getSingleDemographicComparisonGraphData(request), HttpStatus.OK);
            }
            case 25: {
                return new ResponseEntity(this.socioEmotionalAssessmentService.getDemographicComparisonGraphData(request), HttpStatus.OK);
            }
            case 26: {
                return new ResponseEntity(this.socioEmotionalAssessmentService.getTimeSpentAndSELStrandsGraphData(request), HttpStatus.OK);
            }
            case 27: {
                return new ResponseEntity(this.moodDataService.getSelfReportingData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 28: {
                return new ResponseEntity(this.moodDataService.getMoodUpdateDemographicComparisonGraphData(request), HttpStatus.OK);
            }
            case 29: {
                return new ResponseEntity(this.moodDataService.getMoodAnalysisGraphData(request), HttpStatus.OK);
            }
            case 30: {
                return new ResponseEntity(this.moodDataService.getMostAndLeastReportedData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 31: {
                return new ResponseEntity(this.moodDataService.getMoodAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 32: {
                return new ResponseEntity(this.moodDataService.getMoodAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 33: {
                return new ResponseEntity(this.responsibleDecisionMakingSkillsDataService.getSelfReportingData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 34: {
                return new ResponseEntity(this.responsibleDecisionMakingSkillsDataService.getResponsibleDecisionMakingSkillsDemographicComparisonGraphData(request), HttpStatus.OK);
            }
            case 35: {
                return new ResponseEntity(this.responsibleDecisionMakingSkillsDataService.getChoicesAnalysisGraphData(request), HttpStatus.OK);
            }
            case 36: {
                return new ResponseEntity(this.responsibleDecisionMakingSkillsDataService.getMostAndLeastReportedData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 37: {
                return new ResponseEntity(this.responsibleDecisionMakingSkillsDataService.getChoicesAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 38: {
                return new ResponseEntity(this.responsibleDecisionMakingSkillsDataService.getChoicesAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 39: {
                return new ResponseEntity(this.selfManagementDataService.getSelfReportingData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 40: {
                return new ResponseEntity(this.selfManagementDataService.getSelfManagementDemographicComparisonGraphData(request), HttpStatus.OK);
            }
            case 41: {
                return new ResponseEntity(this.selfManagementDataService.getMotivationAnalysisGraphData(request), HttpStatus.OK);
            }
            case 42: {
                return new ResponseEntity(this.selfManagementDataService.getMostAndLeastReportedData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 43: {
                return new ResponseEntity(this.selfManagementDataService.getMotivationAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 44: {
                return new ResponseEntity(this.selfManagementDataService.getMotivationAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 45: {
                return new ResponseEntity(this.socialAwarenessDataService.getSelfReportingData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 46: {
                return new ResponseEntity(this.socialAwarenessDataService.getSocialAwarenessDemographicComparisonGraphData(request), HttpStatus.OK);
            }
            case 47: {
                return new ResponseEntity(this.socialAwarenessDataService.getFriendshipAnalysisGraphData(request), HttpStatus.OK);
            }
            case 48: {
                return new ResponseEntity(this.socialAwarenessDataService.getMostAndLeastReportedData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 49: {
                return new ResponseEntity(this.socialAwarenessDataService.getFriendshipAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 50: {
                return new ResponseEntity(this.socialAwarenessDataService.getFriendshipAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 51: {
                return new ResponseEntity(this.relationshipSkillsDataService.getSelfReportingData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 52: {
                return new ResponseEntity(this.relationshipSkillsDataService.getRelationshipSkillsDemographicComparisonGraphData(request), HttpStatus.OK);
            }
            case 53: {
                return new ResponseEntity(this.relationshipSkillsDataService.getFriendshipAnalysisGraphData(request), HttpStatus.OK);
            }
            case 54: {
                return new ResponseEntity(this.relationshipSkillsDataService.getMostAndLeastReportedData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 55: {
                return new ResponseEntity(this.relationshipSkillsDataService.getFriendshipAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 56: {
                return new ResponseEntity(this.relationshipSkillsDataService.getFriendshipAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 57: {
                return new ResponseEntity(this.featuresService.getByStudentsDemographicsData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 58: {
                return new ResponseEntity(this.featuresService.getByTeachersGradesData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 59: {
                return new ResponseEntity((Object)this.moodDataService.getMoodInsight(request), HttpStatus.OK);
            }
            case 60: {
                return new ResponseEntity((Object)this.moodDataService.getMoodInsightByInstructerId(request), HttpStatus.OK);
            }
            case 61: {
                return new ResponseEntity((Object)this.moodDataService.getMoodInsightPost(request), HttpStatus.OK);
            }
            case 62: {
                return new ResponseEntity(this.moodDataService.getMoodBeforeAndMoodAfter(request, Language.getLanguage()), HttpStatus.OK);
            }
            case 63: {
                Instructor instructor = this.authService.getInstructorByToken(token);
                return new ResponseEntity((Object)this.moodDataService.getMoodInsightPostInstructor(request, Language.getInstructorLanguage((Instructor)instructor)), HttpStatus.OK);
            }
            case 64: {
                Parent parent = this.authService.getParentByToken(token);
                return new ResponseEntity((Object)this.moodDataService.getMoodInsightPostParent(request, Language.getParentLanguage((Parent)parent)), HttpStatus.OK);
            }
            case 65: {
                return new ResponseEntity((Object)this.userStatsService.getPercentageByOSForStudent(request), HttpStatus.OK);
            }
            case 66: {
                return new ResponseEntity((Object)this.userStatsService.getPercentageByBrowserForStudent(request), HttpStatus.OK);
            }
            case 67: {
                return new ResponseEntity((Object)this.userStatsService.getPercentageByOSForInstructor(request), HttpStatus.OK);
            }
            case 68: {
                return new ResponseEntity((Object)this.userStatsService.getPercentageByBrowserForInstructor(request), HttpStatus.OK);
            }
            case 69: {
                return new ResponseEntity(this.featuresService.getPagePerformanceAnalyticsOrderByScreenId(request), HttpStatus.OK);
            }
        }
        return new ResponseEntity(new Object(), HttpStatus.OK);
    }

    private LabelsAndDatasets getLabelsAndDatasets(GetDataDashBoardRequest request, LinkedHashMap<String, List<LabelAndValue>> graphData) {
        LabelsAndDatasets labelsAndDatasets = new LabelsAndDatasets();
        LinkedList<LabelAndData> dataset = new LinkedList<LabelAndData>();
        for (String key : graphData.keySet()) {
            List<LabelAndValue> values = graphData.get(key);
            LinkedList<Double> data = new LinkedList<Double>();
            if (AppUtils.isNotNullOrEmpty(values)) {
                for (int i = 0; i < values.size(); ++i) {
                    labelsAndDatasets.getLabels().add(values.get(i).getxLabel());
                    data.add(DigitUtils.formatDoubleInTwoDigit((Double)values.get(i).getValue()));
                }
            }
            LabelAndData labelAndData = new LabelAndData(key, data);
            dataset.add(labelAndData);
        }
        labelsAndDatasets.setDataset(dataset);
        return labelsAndDatasets;
    }

    private Object getLabelsAndMultiDatasets(LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> graphData) {
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        LinkedList dataset = new LinkedList();
        for (String demographic : graphData.keySet()) {
            LinkedList data = new LinkedList();
            for (String mood : graphData.get(demographic).keySet()) {
                labels.add(mood);
                LinkedList<Double> countAndScores = new LinkedList<Double>();
                countAndScores.add(graphData.get(demographic).get(mood).get(0));
                countAndScores.add(graphData.get(demographic).get(mood).get(1));
                data.add(countAndScores);
            }
            LinkedHashMap<String, Object> datasetItem = new LinkedHashMap<String, Object>();
            datasetItem.put(LABEL, demographic);
            datasetItem.put(DATA, data);
            dataset.add(datasetItem);
        }
        LinkedHashMap<String, AbstractCollection> labelsAndDatasets = new LinkedHashMap<String, AbstractCollection>();
        labelsAndDatasets.put(LABELS, labels);
        labelsAndDatasets.put(DATASET, dataset);
        return labelsAndDatasets;
    }

    private GetDataDashBoardRequest getDefaultGetDataDashBoardRequest(GetDataDashBoardRequest request) {
        DropDownsForAnalyticsDataWrapper dropDownsForAnalyticsDataWrapper = this.getDropDownsForAnalyticsDataWrapper(null, null);
        request.setGenders(dropDownsForAnalyticsDataWrapper.getGenders().stream().map(LabelPerLanguage::getEn).collect(Collectors.toList()));
        request.setAges(this.ages);
        request.setEthnicity(dropDownsForAnalyticsDataWrapper.getEthnicity().stream().map(LabelPerLanguage::getEn).collect(Collectors.toList()));
        for (GradeView gradeView : dropDownsForAnalyticsDataWrapper.getGrades()) {
            request.getGradeIds().add(gradeView.getGrade_id());
        }
        return request;
    }

    private DropDownsForAnalyticsDataWrapper getDropDownsForAnalyticsDataWrapper(School school, Instructor instructor) {
        DropDownsForAnalyticsDataWrapper dropDownsForAnalyticsDataWrapper = new DropDownsForAnalyticsDataWrapper(this.genderService.getGenderOrderBySortIndexId(), this.ethnicityService.getEthnicityOrderBySortIndexId());
        dropDownsForAnalyticsDataWrapper.setQuestion_types(this.socioEmotionalTestQuestionTypeService.getSocioEmotionalTestQuestionTypesOrderBySocioEmotionalTestQuestionTypeId());
        dropDownsForAnalyticsDataWrapper.setGrades(this.gradeService.getGradesOrderByGradeId());
        if (instructor != null) {
            dropDownsForAnalyticsDataWrapper.setClasses(this.classService.getClassViewsByInstructorId(instructor.getInstructor_id()));
        } else if (school != null) {
            dropDownsForAnalyticsDataWrapper.setClasses(this.classService.getClassViewsBySchoolId(school.getSchool_id()));
        }
        dropDownsForAnalyticsDataWrapper.setRelationship_skills(this.dataSetService.getAssessmentChildCategoriesAndNamesByAssessmentCategory(AssessmentCategory.RELATIONSHIP_SKILLS));
        return dropDownsForAnalyticsDataWrapper;
    }

    public GetDataDashBoardRequest getGetDataDashBoardRequest(DatadashboardRequest datadashboardRequest) {
        GetDataDashBoardRequest request = new GetDataDashBoardRequest();
        request.setGraphType(datadashboardRequest.getGraphType());
        request.setDemographicType(datadashboardRequest.getDemographicType());
        request.setAssessmentChildCategory(datadashboardRequest.getAssessmentChildCategory());
        request.setPostType(datadashboardRequest.getPostType());
        request.setTimeLine(datadashboardRequest.getTimeLine());
        request.setEntity_id(datadashboardRequest.getEntity_id());
        request.setInstructor_id(datadashboardRequest.getInstructor_id());
        request.setParent_id(datadashboardRequest.getParent_id());
        request.setSocio_emotional_test_question_type_id(datadashboardRequest.getSocio_emotional_test_question_type_id());
        request.setGenders(datadashboardRequest.getGenders());
        request.setAges(datadashboardRequest.getAges());
        request.setEthnicity(datadashboardRequest.getEthnicity());
        request.setGradeIds(datadashboardRequest.getGradeIds());
        request.setClassIds(datadashboardRequest.getClassIds());
        request.setMood_update_before(datadashboardRequest.getMood_update_before());
        request.setMood_update_after(datadashboardRequest.getMood_update_after());
        request.setFromDate(datadashboardRequest.getFromDate());
        request.setToDate(datadashboardRequest.getToDate());
        request.setAscOrDesc(datadashboardRequest.getAscOrDesc());
        request.setZonedDateTime(datadashboardRequest.getZonedDateTime());
        request.setTimeZone(datadashboardRequest.getTimeZone());
        request.setFrom_mobile(datadashboardRequest.isFrom_mobile());
        return request;
    }

    public static String getClassNameWithInstructorFullName(Long class_id, ClassRepository classRepository, InstructorRepository instructorRepository) {
        Class class_ = (Class)classRepository.getOne((Object)class_id);
        String class_name = class_.getClass_name().trim() + " (" + class_.getInstructor().getFirst_name().trim() + ")";
        return class_name;
    }
}

