/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.fcm.service;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.fcm.StudentPushNotification;
import com.infinite.focus.server.fcm.StudentPushNotificationRepository;
import com.infinite.focus.server.fcm.model.NotificationType;
import com.infinite.focus.server.fcm.service.StudentPushNotificationService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class StudentPushNotificationServiceImpl
implements StudentPushNotificationService {
    @Autowired
    MessageService messageService;
    @Autowired
    private ConfigurationRepository configurationRepository;
    @Autowired
    private StudentPushNotificationRepository studentPushNotificationRepository;
    @Autowired
    private RealTimeMessageService realTimeMessageService;
    @Autowired
    private StudentRepository studentRepository;
    @Autowired
    private RestComponent restComponent;

    public void sendWOWPostNotification(Long student_id) {
        if (this.studentPushNotificationRepository.findByStudentIdAndNotificationType(student_id, NotificationType.WOW_POST.toString()) == null) {
            StudentPushNotification studentPushNotification = new StudentPushNotification();
            studentPushNotification.setStudent_id(student_id.longValue());
            studentPushNotification.setNotification_type(NotificationType.WOW_POST);
            studentPushNotification.setTitle(this.configurationRepository.getConfiguration().getWow_post_title());
            studentPushNotification.setMessage(this.configurationRepository.getConfiguration().getWow_post_message());
            studentPushNotification.setTitle_es(this.configurationRepository.getConfiguration().getWow_post_title_es());
            studentPushNotification.setMessage_es(this.configurationRepository.getConfiguration().getWow_post_message_es());
            studentPushNotification.setCreatedAt(new Date());
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
            try {
                Student student = this.studentRepository.findByStudentId(student_id);
                student.setNew_notificaitons(true);
                this.studentRepository.save((Object)student);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.realTimeMessageService.sendTitleAndMessage(student_id.longValue(), studentPushNotification.getTitle(), studentPushNotification.getFormat_text() + " " + studentPushNotification.getMessage());
        }
    }

    public boolean isThereNewNotificationAvailable(String approvedDate, Long student_id) {
        StudentPushNotification studentPushNotification = this.studentPushNotificationRepository.findTopFirstGreaterThanEqualToStudentApproveDateAndStudentId(approvedDate, student_id);
        return !studentPushNotification.isViewed();
    }

    public void send(long student_id, NotificationType notification_type, String format_text, String title, String message, String title_es, String message_es) {
        Student student = this.restComponent.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        StudentPushNotification studentPushNotification = new StudentPushNotification();
        studentPushNotification.setStudent_id(student.getStudent_id());
        studentPushNotification.setNotification_type(notification_type);
        studentPushNotification.setFormat_text(format_text);
        studentPushNotification.setTitle(title);
        studentPushNotification.setTitle_es(title_es);
        studentPushNotification.setMessage(message);
        studentPushNotification.setMessage_es(message_es);
        if (!student.isDemo()) {
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
        }
        this.realTimeMessageService.sendTitleAndMessage(student_id, studentPushNotification.getTitle(), studentPushNotification.getMessage());
        this.restComponent.setNewNotificationsForStudent(student_id, true);
    }
}

