/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.group.service;

import com.infinite.focus.server.accesscode.repository.AccessCodeRepository;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.activity.repository.ActivityRepository;
import com.infinite.focus.server.answer.repository.AnswerRepository;
import com.infinite.focus.server.assessment.repository.AssessmentRepository;
import com.infinite.focus.server.confirmationtoken.repository.ConfirmationTokenRepository;
import com.infinite.focus.server.dailyappreciation.repository.DailyAppreciationRepository;
import com.infinite.focus.server.favorite.repository.FavoriteRepository;
import com.infinite.focus.server.fcm.StudentPushNotificationRepository;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.service.ClassAndStudentService;
import com.infinite.focus.server.journal.repository.JournalRepository;
import com.infinite.focus.server.lessonrecord.repository.LessonRecordRepository;
import com.infinite.focus.server.moodupdate.repository.MoodUpdateRepository;
import com.infinite.focus.server.notification.repository.NotificationRepository;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.entity.StudentProfileOtp;
import com.infinite.focus.server.parent.repository.ParentRepository;
import com.infinite.focus.server.parent.repository.StudentProfileOtpRepository;
import com.infinite.focus.server.relationshipskills.repository.RelationshipSkillsUpdateRepository;
import com.infinite.focus.server.responsibledecisionmaking.repository.ResponsibleDecisionMakingUpdateRepository;
import com.infinite.focus.server.selfmanagement.repository.SelfManagementUpdateRepository;
import com.infinite.focus.server.sharedyouth.repository.SharedYouthRepository;
import com.infinite.focus.server.shortenurl.repository.ShortenUrlRepository;
import com.infinite.focus.server.socialawareness.repository.SocialAwarenessUpdateRepository;
import com.infinite.focus.server.socioemotionaltestanswer.repository.SocioEmotionalTestAnswerRepository;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.repository.SocioEmotionalTestResultRepository;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.studentbadge.repository.StudentBadgeRepository;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.testresult.entity.TestResult;
import com.infinite.focus.server.testresult.repository.TestResultRepository;
import com.infinite.focus.server.testresultgrade.repository.TestResultGradeRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.wallpost.entity.WallPost;
import com.infinite.focus.server.wallpost.repository.WallPostRepository;
import com.infinite.focus.server.wallpostattachment.repository.WallPostAttachmentRepository;
import com.infinite.focus.server.wallpostreaction.repository.WallPostReactionRepository;
import com.infinite.focus.server.wallpostrequest.request.WallPostRequestRepository;
import com.infinite.focus.server.youthsurveychoice.repository.YouthSurveyChoiceRepository;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ClassStudentServiceImpl
implements ClassAndStudentService {
    @Autowired
    ClassRepository classRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    AccessCodeRepository accessCodeRepository;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    TestResultRepository testResultRepository;
    @Autowired
    AnswerRepository answerRepository;
    @Autowired
    TestResultGradeRepository testResultGradeRepository;
    @Autowired
    AssessmentRepository assessmentRepository;
    @Autowired
    ConfirmationTokenRepository confirmationTokenRepository;
    @Autowired
    DailyAppreciationRepository dailyAppreciationRepository;
    @Autowired
    FavoriteRepository favoriteRepository;
    @Autowired
    LessonRecordRepository lessonRecordRepository;
    @Autowired
    MoodUpdateRepository moodUpdateRepository;
    @Autowired
    NotificationRepository notificationRepository;
    @Autowired
    RelationshipSkillsUpdateRepository relationshipSkillsUpdateRepository;
    @Autowired
    ResponsibleDecisionMakingUpdateRepository responsibleDecisionMakingUpdateRepository;
    @Autowired
    SelfManagementUpdateRepository selfManagementUpdateRepository;
    @Autowired
    SharedYouthRepository sharedYouthRepository;
    @Autowired
    ShortenUrlRepository shortenUrlRepository;
    @Autowired
    StudentProfileOtpRepository studentProfileOtpRepository;
    @Autowired
    SocialAwarenessUpdateRepository socialAwarenessUpdateRepository;
    @Autowired
    SocioEmotionalTestResultRepository socioEmotionalTestResultRepository;
    @Autowired
    SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository;
    @Autowired
    StudentPushNotificationRepository studentPushNotificationRepository;
    @Autowired
    WallPostRepository wallPostRepository;
    @Autowired
    WallPostAttachmentRepository wallPostAttachmentRepository;
    @Autowired
    WallPostRequestRepository wallPostRequestRepository;
    @Autowired
    WallPostReactionRepository wallPostReactionRepository;
    @Autowired
    ParentRepository parentRepository;
    @Autowired
    StudentBadgeRepository studentBadgeRepository;
    @Autowired
    StudentStreakRepository studentStreakRepository;
    @Autowired
    JournalRepository journalRepository;
    @Autowired
    YouthSurveyChoiceRepository youthSurveyChoiceRepository;

    public void deleteClassesByIds(List<Long> classIds) {
        if (!AppUtils.isNullOrEmpty(classIds)) {
            List classes = this.classRepository.findByClassIds(classIds);
            for (Class class_ : classes) {
                List studentIds = class_.getStudents().stream().filter(student -> this.isStudentDeletedFromAllClasses(student, classIds)).map(Student::getStudent_id).collect(Collectors.toList());
                if (AppUtils.isNullOrEmpty(studentIds)) continue;
                this.deleteStudentsByIds(studentIds);
            }
            try {
                this.classRepository.deleteByClassIds(classIds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isStudentDeletedFromAllClasses(Student student, List<Long> classIds) {
        for (Class class_ : student.getClasses()) {
            if (classIds.contains(class_.getClass_id())) continue;
            return false;
        }
        return true;
    }

    @Async
    public void deleteStudentsByIds(List<Long> studentIds) {
        try {
            List deleteStudents = this.studentRepository.findByStudentIds(studentIds).stream().filter(arg_0 -> this.studentCanBeDelete(arg_0)).map(StudentView::getStudent_id).collect(Collectors.toList());
            if (!AppUtils.isNullOrEmpty(deleteStudents)) {
                this.deleteStudents(deleteStudents, this.studentRepository.findByStudentIds(deleteStudents).stream().filter(studentView -> studentView.getAccount_id() != null && studentView.getAccount_id() > 0L).map(StudentView::getAccount_id).collect(Collectors.toList()), this.studentRepository.findByStudentIds(deleteStudents).stream().filter(studentView -> studentView.getParent_id() != null && studentView.getParent_id() > 0L).map(StudentView::getParent_id).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            List removeInstructors = this.studentRepository.findByStudentIds(studentIds).stream().filter(student -> !this.studentCanBeDelete(student)).map(StudentView::getStudent_id).collect(Collectors.toList());
            if (!AppUtils.isNullOrEmpty(removeInstructors)) {
                this.removeInstructorFromStudents(removeInstructors);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean studentCanBeDelete(StudentView studentView) {
        if (studentView.getParent_id() == null) {
            return true;
        }
        Parent parent = this.parentRepository.findByParentId(studentView.getParent_id().longValue());
        return parent == null || parent.getCorporate_id() <= 0L;
    }

    public void removeInstructorFromStudents(List<Long> studentIds) {
        try {
            this.studentRepository.updateUpdateInstructorId(0L, studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.accessCodeRepository.updateUpdateInstructorIdByStudentIds(0L, studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (StudentView studentView : this.studentRepository.findByStudentIds(studentIds)) {
                Student student = this.studentRepository.findByStudentId(studentView.getStudent_id());
                student.setClasses(new HashSet());
                this.studentRepository.save((Object)student);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteStudents(List<Long> studentIds, List<Long> accountIds, List<Long> parentIds) {
        try {
            this.studentRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.deleteStudentAccessCodeData(studentIds);
        this.deleteAccountData(accountIds);
        this.deleteStudentActivityData(studentIds);
        this.deleteStudentTestData(studentIds);
        this.deleteStudentAssessmentData(studentIds);
        this.deleteStudentConfirmationTokenData(accountIds);
        this.deleteStudentDailyAppreciationData(studentIds);
        this.deleteStudentFavoriteData(studentIds);
        this.deleteStudentLessonRecordData(studentIds);
        this.deleteStudentMoodUpdateData(studentIds);
        this.deleteStudentNotificationData(studentIds);
        this.deleteStudentRelationshipSkillsUpdateData(studentIds);
        this.deleteStudentResponsibleDecisionMakingUpdateData(studentIds);
        this.deleteStudentSelfManagementUpdateData(studentIds);
        this.deleteStudentSharedYouthData(studentIds);
        this.deleteShortenUrlData(accountIds);
        this.deleteStudentSocialAwarenessUpdateData(studentIds);
        this.deleteStudentSocioEmotionalTestData(studentIds);
        this.deleteStudentStudentPushNotificationData(studentIds);
        this.deleteStudentWallPostData(studentIds);
        this.deleteStudentParentData(parentIds);
        this.deleteStudentBadgeData(studentIds);
        this.deleteStudentStreakData(studentIds);
        this.deleteStudentJournalData(studentIds);
        this.deleteStudentYouthSurveyChoiceData(studentIds);
    }

    private void deleteStudentYouthSurveyChoiceData(List<Long> studentIds) {
        try {
            this.youthSurveyChoiceRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentParentData(List<Long> parentIds) {
        try {
            List accountIds = this.parentRepository.findByParentIds(parentIds).stream().filter(parent -> parent.getAccount() != null).map(parent -> parent.getAccount().getAccount_id()).collect(Collectors.toList());
            this.deleteAccountData(accountIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.parentRepository.deleteByParentIds(parentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentStudentPushNotificationData(List<Long> studentIds) {
        try {
            this.studentPushNotificationRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentSocialAwarenessUpdateData(List<Long> studentIds) {
        try {
            this.socialAwarenessUpdateRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentSharedYouthData(List<Long> studentIds) {
        try {
            this.sharedYouthRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentSelfManagementUpdateData(List<Long> studentIds) {
        try {
            this.selfManagementUpdateRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentResponsibleDecisionMakingUpdateData(List<Long> studentIds) {
        try {
            this.responsibleDecisionMakingUpdateRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentRelationshipSkillsUpdateData(List<Long> studentIds) {
        try {
            this.relationshipSkillsUpdateRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentNotificationData(List<Long> studentIds) {
        try {
            this.notificationRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentMoodUpdateData(List<Long> studentIds) {
        try {
            this.moodUpdateRepository.deleteByStudentIds(new HashSet<Long>(studentIds));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentLessonRecordData(List<Long> studentIds) {
        try {
            this.lessonRecordRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentFavoriteData(List<Long> studentIds) {
        try {
            this.favoriteRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentDailyAppreciationData(List<Long> studentIds) {
        try {
            this.dailyAppreciationRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentConfirmationTokenData(List<Long> accountIds) {
        try {
            this.confirmationTokenRepository.deleteByAccountIds(accountIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentAssessmentData(List<Long> studentIds) {
        try {
            this.assessmentRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentActivityData(List<Long> studentIds) {
        try {
            this.activityRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteAccountData(List<Long> accountIds) {
        try {
            this.accountRepository.deleteByAccountIds(accountIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentAccessCodeData(List<Long> studentIds) {
        try {
            this.accessCodeRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentWallPostData(List<Long> studentIds) {
        try {
            List wallPostIds = this.wallPostRepository.findByStudentIds(studentIds).stream().map(WallPost::getWall_post_id).collect(Collectors.toList());
            try {
                this.wallPostRequestRepository.deleteByWallPostIds(wallPostIds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.wallPostAttachmentRepository.deleteByWallPostIds(wallPostIds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.wallPostRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.wallPostReactionRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentSocioEmotionalTestData(List<Long> studentIds) {
        try {
            List socioEmotionalTestResultIds = this.socioEmotionalTestResultRepository.findByStudentIds(studentIds).stream().map(SocioEmotionalTestResult::getSocio_emotional_test_result_id).collect(Collectors.toList());
            try {
                this.socioEmotionalTestAnswerRepository.deleteBySocioEmotionalTestResultIds(socioEmotionalTestResultIds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.socioEmotionalTestResultRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteShortenUrlData(List<Long> accountIds) {
        try {
            List student_profile_otp_ids = this.studentProfileOtpRepository.findByAccountIds(accountIds).stream().map(StudentProfileOtp::getStudent_profile_otp_id).collect(Collectors.toList());
            try {
                this.shortenUrlRepository.deleteByStudentProfileOtpIds(student_profile_otp_ids);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.studentProfileOtpRepository.deleteByAccountIds(accountIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteStudentTestData(List<Long> studentIds) {
        try {
            List testResultsIds = this.testResultRepository.findByStudentIds(studentIds).stream().map(TestResult::getTest_result_id).collect(Collectors.toList());
            try {
                this.answerRepository.deleteByTestResultIds(testResultsIds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.testResultGradeRepository.deleteByTestResultIds(testResultsIds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.testResultRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentBadgeData(List<Long> studentIds) {
        try {
            this.studentBadgeRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentStreakData(List<Long> studentIds) {
        try {
            this.studentStreakRepository.deleteByStudentIds(studentIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteStudentJournalData(List<Long> studentIds) {
        try {
            this.journalRepository.deleteByStudentIds(new HashSet<Long>(studentIds));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

