/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.language;

import com.infinite.focus.server.gender.entity.Gender;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.utils.AppUtils;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class Language {
    public static final String ENGLISH = "en";
    public static final String SPANISH = "es";
    public static final String Students = "Students";
    public static final String Students_es = "Estudiantes";
    public static final String Instructors = "Instructors";
    public static final String Instructors_es = "Instructores";
    public static final String Total = "Total";
    public static final String Total_es = "Total";
    public static final String Gender_en = "Gender";
    public static final String Gender_es = "G\u00e9nero";
    public static final String Grade_en = "Grade";
    public static final String Grade_es = "Grado";
    public static final String Ethnicity_en = "Ethnicity";
    public static final String Ethnicity_es = "Etnia";
    public static final String Age_en = "Age";
    public static final String Age_es = "Edad";
    public static final String Overall_en = "Overall";
    public static final String Overall_es = "En total";
    public static final String Family_en = "Family";
    public static final String Family_es = "Familia";
    public static final String Friends_en = "Friends";
    public static final String Friends_es = "Amigos";
    public static final String School_en = "School";
    public static final String School_es = "Escuela";
    public static final String Me_en = "Me";
    public static final String Me_es = "Yo";
    public static final String My_Teacher_en = "My Teacher";
    public static final String My_Teacher_es = "Mi profesor";
    public static final String My_Pets_en = "My Pets";
    public static final String My_Pets_es = "Mis mascotas";
    public static final String A_Teacher_en = "A Teacher";
    public static final String A_Teacher_es = "Un profesor";
    public static final String Technology_en = "Technology";
    public static final String Technology_es = "Tecnolog\u00eda";
    public static final String Math_en = "Math";
    public static final String Math_es = "Matem\u00e1ticas";
    public static final String Music_en = "Music";
    public static final String Music_es = "M\u00fasica";
    public static final String Art_en = "Art";
    public static final String Art_es = "Arte";

    public static String getLanguage() {
        Locale language = LocaleContextHolder.getLocale();
        return language.getLanguage();
    }

    public static String getInstructorLanguage(Instructor instructor) {
        if (instructor == null) {
            return LocaleContextHolder.getLocale().getLanguage();
        }
        return Language.getLanguage((String)instructor.getLanguage());
    }

    public static String getParentLanguage(Parent parent) {
        if (parent == null) {
            return LocaleContextHolder.getLocale().getLanguage();
        }
        return Language.getLanguage((String)parent.getLanguage());
    }

    public static String getLanguage(String language) {
        if (AppUtils.isNullOrEmpty((String)language)) {
            return LocaleContextHolder.getLocale().getLanguage();
        }
        return language;
    }

    public static boolean isSpanish() {
        return Language.getLanguage().equals("es");
    }

    public static boolean isSpanish(String language) {
        if (AppUtils.isNullOrEmpty((String)language)) {
            return false;
        }
        return language.equals("es");
    }

    public static String getGradeKey(String key, GradeView gradeView, String language) {
        if (gradeView != null) {
            if (Language.isSpanish((String)language)) {
                return gradeView.getGrade_name_es();
            }
            return gradeView.getGrade_name();
        }
        if (key.equalsIgnoreCase("Total") && Language.isSpanish((String)language)) {
            return "Total";
        }
        return key;
    }

    public static String getGenderKey(String key, Gender gender, String language) {
        if (gender != null) {
            if (Language.isSpanish((String)language)) {
                return gender.getGender_es();
            }
            return gender.getGender();
        }
        if (key.equalsIgnoreCase("Total") && Language.isSpanish((String)language)) {
            return "Total";
        }
        return key;
    }
}

