/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.selfmanagement.repository;

import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.data.model.OccurrenceAndOccurrenceAverage;
import com.infinite.focus.server.selfmanagement.dto.SelfManagementUpdateDTO;
import com.infinite.focus.server.selfmanagement.entity.SelfManagementUpdate;
import com.infinite.focus.server.selfmanagement.repository.SelfManagementUpdateCriteriaRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class SelfManagementUpdateCriteriaRepositoryImpl
implements SelfManagementUpdateCriteriaRepository {
    @Autowired
    EntityManager entityManager;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static SelfManagementUpdateDTO mapRow(ResultSet rs, int i) throws SQLException {
        return SelfManagementUpdateDTO.builder().self_management_update_id(rs.getLong("self_management_update_id")).student_id(rs.getLong("student_id")).standard_id(rs.getLong("standard_id")).data_set_id(rs.getLong("data_set_id")).score(rs.getDouble("score")).text(rs.getString("text")).text_es(rs.getString("text_es")).createdAt((Date)rs.getTimestamp("created_at")).build();
    }

    public List<AssessmentOccurrence> getMotivationAnalysisByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate) {
        if (AppUtils.isNullOrEmpty(studentIds)) {
            return this.mapToAssessmentOccurance(new ArrayList());
        }
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Tuple.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        Root rootSelfManagementUpdate = c.from(SelfManagementUpdate.class);
        predicates.add(qb.in((Expression)rootSelfManagementUpdate.get("student_id")).value(studentIds));
        predicates.add(qb.between((Expression)rootSelfManagementUpdate.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        Expression quot = qb.coalesce(qb.quot(qb.count((Expression)rootSelfManagementUpdate.get("self_management_update_id")), (Number)studentIds.size()), (Object)0.0);
        Expression roundExpression = qb.function("round", Double.class, new Expression[]{quot, qb.literal((Object)2)});
        c.multiselect(new Selection[]{rootSelfManagementUpdate.get("text").alias("text_to_display"), rootSelfManagementUpdate.get("text_es").alias("text_to_display_es"), roundExpression.alias("count")}).where(predicates.toArray(new Predicate[0]));
        c.groupBy(new Expression[]{rootSelfManagementUpdate.get("data_set_id"), rootSelfManagementUpdate.get("text"), rootSelfManagementUpdate.get("text_es")});
        c.orderBy(new Order[]{qb.asc((Expression)rootSelfManagementUpdate.get("data_set_id"))});
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List list = typedQuery.getResultList().stream().map(tuple -> new AssessmentOccurrence(0L, (String)tuple.get("text_to_display"), (String)tuple.get("text_to_display_es"), ((Double)tuple.get("count")).doubleValue(), 0L, 0.0, null)).collect(Collectors.toList());
        return this.mapToAssessmentOccurance(list);
    }

    public List<SelfManagementUpdateDTO> findByStudentIdsAndBetweenFromDateAndToDate2(Set<Long> student_ids, Date fromDate, Date toDate) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return new ArrayList<SelfManagementUpdateDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        ArrayList<Long> args = new ArrayList<Long>(student_ids);
        args.add((Long)((Object)new Timestamp(fromDate.getTime())));
        args.add((Long)((Object)new Timestamp(toDate.getTime())));
        String SQL = "SELECT * FROM self_management_update se_up WHERE se_up.student_id IN(%S) AND se_up.created_at BETWEEN ? AND ? ORDER BY se_up.created_at DESC ";
        List selfManagementUpdateDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), args.toArray(), SelfManagementUpdateCriteriaRepositoryImpl::mapRow);
        return selfManagementUpdateDTOS;
    }

    public List<AssessmentOccurrence> mapToAssessmentOccurance(List<AssessmentOccurrence> list) {
        List textToDisplayList = this.getTextToDisplay();
        if (!AppUtils.isNullOrEmpty(list)) {
            for (AssessmentOccurrence text : textToDisplayList) {
                list.stream().filter(o -> o.getText_to_display().equals(text.getText_to_display()) && o.getText_to_display_es().equals(text.getText_to_display_es())).findFirst().ifPresent(assessmentOccurance -> text.setCount(assessmentOccurance.getCount()));
            }
        }
        return textToDisplayList;
    }

    public List<AssessmentOccurrence> getTextToDisplay2() {
        String SQL = "SELECT data_set_id, text, text_es FROM self_management_update GROUP BY data_set_id, text, text_es ORDER BY data_set_id ASC ";
        List assessmentOccurrences = this.jdbcTemplate.query(SQL, (rs, i) -> AssessmentOccurrence.builder().text_to_display(rs.getString("text")).text_to_display_es(rs.getString("text_es")).mood_id(0L).count(0.0).occurrence(0L).occurrence_average(0.0).build());
        return assessmentOccurrences;
    }

    public List<AssessmentOccurrence> getTextToDisplay() {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Tuple.class);
        ArrayList predicates = new ArrayList();
        Root rootSelfManagementUpdate = c.from(SelfManagementUpdate.class);
        c.multiselect(new Selection[]{rootSelfManagementUpdate.get("text").alias("text_to_display"), rootSelfManagementUpdate.get("text_es").alias("text_to_display_es")}).where(predicates.toArray(new Predicate[0]));
        c.groupBy(new Expression[]{rootSelfManagementUpdate.get("data_set_id"), rootSelfManagementUpdate.get("text"), rootSelfManagementUpdate.get("text_es")});
        c.orderBy(new Order[]{qb.asc((Expression)rootSelfManagementUpdate.get("data_set_id"))});
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List<AssessmentOccurrence> list = typedQuery.getResultList().stream().map(tuple -> new AssessmentOccurrence(0L, (String)tuple.get("text_to_display"), (String)tuple.get("text_to_display_es"), 0.0, 0L, 0.0, null)).collect(Collectors.toList());
        return list;
    }

    public SelfManagementUpdateDTO findById(long self_management_update_id) {
        String SQL = "SELECT * FROM self_management_update WHERE self_management_update_id = ? ";
        try {
            return (SelfManagementUpdateDTO)this.jdbcTemplate.queryForObject(SQL, SelfManagementUpdateCriteriaRepositoryImpl::mapRow, new Object[]{self_management_update_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OccurrenceAndOccurrenceAverage> getTextToDisplay3() {
        String SQL = "SELECT data_set_id, text, text_es FROM self_management_update GROUP BY data_set_id, text, text_es ORDER BY data_set_id ASC ";
        List occurrenceAndOccurrenceAverages = this.jdbcTemplate.query(SQL, (rs, i) -> OccurrenceAndOccurrenceAverage.builder().text_to_display(rs.getString("text")).text_to_display_es(rs.getString("text_es")).count(0.0).occurrence(0L).occurrence_average(0.0).build());
        return occurrenceAndOccurrenceAverages;
    }
}

