/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.standard.controller;

import com.infinite.focus.server.category.request.GetCategoriesByIdsRequest;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.standard.request.GetByStandardIdRequest;
import com.infinite.focus.server.standard.service.StandardService;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/standard"})
public class StandardController {
    private StandardJPARepository standardJPARepository;
    @Autowired
    private StandardService standardService;
    @Autowired
    MessageService messageService;

    public StandardController(StandardJPARepository standardJPARepository) {
        this.standardJPARepository = standardJPARepository;
    }

    @GetMapping(value={"/get/standards"})
    public ResponseEntity<List<Standard>> getStandards() {
        return new ResponseEntity((Object)this.standardJPARepository.findAll(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-standards"})
    public ResponseEntity<List<StandardDTO>> getAllStandards() {
        return new ResponseEntity((Object)this.standardService.getAll(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/standard/{standard_id}"})
    public ResponseEntity<Standard> getStandardById(@PathVariable(value="standard_id") Long standard_id) {
        Standard standard = this.standardJPARepository.findByStandardId(standard_id);
        if (standard == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.standard.is.not.found"));
        }
        return new ResponseEntity((Object)standard, HttpStatus.OK);
    }

    @PostMapping(value={"/get-standards-by-ids"})
    public ResponseEntity<List<StandardDTO>> getStandardsByIds(@RequestBody GetCategoriesByIdsRequest request) {
        return new ResponseEntity((Object)this.standardService.getByIds(request.getIds()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-id"})
    public ResponseEntity<StandardDTO> getById(@RequestBody GetByStandardIdRequest request) {
        return new ResponseEntity((Object)this.standardService.getById(request.getStandard_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-k-2-standard-ids"})
    public ResponseEntity<Set<Long>> getK_2StandardIds() {
        return new ResponseEntity((Object)this.standardService.getK_2StandardIds(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-3-5-standard-ids"})
    public ResponseEntity<Set<Long>> get3_5StandardIds() {
        return new ResponseEntity((Object)this.standardService.get3_5StandardIds(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-6-12-standard-ids"})
    public ResponseEntity<Set<Long>> get6_12StandardIds() {
        return new ResponseEntity((Object)this.standardService.get6_12StandardIds(), HttpStatus.OK);
    }
}

