/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.fcm;

import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.fcm.PushNotifcationRepository;
import com.infinite.focus.server.fcm.PushNotificationController;
import com.infinite.focus.server.fcm.SendStudentNotificationRequest;
import com.infinite.focus.server.fcm.StudentPushNotification;
import com.infinite.focus.server.fcm.StudentPushNotificationRepository;
import com.infinite.focus.server.fcm.model.NotificationType;
import com.infinite.focus.server.fcm.model.PushNotification;
import com.infinite.focus.server.fcm.model.PushNotificationResponse;
import com.infinite.focus.server.fcm.service.PushNotificationService;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestService;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/fcm"})
public class PushNotificationController {
    private AccountRepository accountRepository;
    private PushNotificationService pushNotificationService;
    private PushNotifcationRepository pushNotifcationRepository;
    private StudentPushNotificationRepository studentPushNotificationRepository;
    @Autowired
    private RealTimeMessageService realTimeMessageService;
    private StudentRepository studentRepository;
    @Autowired
    SocioEmotionalTestService socioEmotionalTestService;
    @Autowired
    ClassService classService;
    @Autowired
    MessageService messageService;
    @Autowired
    StandardJPARepository standardRepository;
    @Autowired
    AuthService authService;

    public PushNotificationController(AccountRepository accountRepository, PushNotificationService pushNotificationService, PushNotifcationRepository pushNotifcationRepository, StudentPushNotificationRepository studentPushNotificationRepository, StudentRepository studentRepository) {
        this.accountRepository = accountRepository;
        this.pushNotificationService = pushNotificationService;
        this.pushNotifcationRepository = pushNotifcationRepository;
        this.studentPushNotificationRepository = studentPushNotificationRepository;
        this.studentRepository = studentRepository;
    }

    @PostMapping(value={"/notification/topic"})
    public ResponseEntity sendNotification(@RequestBody PushNotification request) {
        this.pushNotificationService.sendPushNotificationWithoutData(request);
        return new ResponseEntity((Object)new PushNotificationResponse(HttpStatus.OK.value(), this.messageService.getMessage("notification.has.been.sent")), HttpStatus.OK);
    }

    @PostMapping(value={"/notification/token"})
    public ResponseEntity sendTokenNotification(@RequestBody PushNotification request) {
        this.pushNotificationService.sendPushNotificationToToken(request);
        return new ResponseEntity((Object)new PushNotificationResponse(HttpStatus.OK.value(), this.messageService.getMessage("notification.has.been.sent")), HttpStatus.OK);
    }

    @PostMapping(value={"/notification/data"})
    public ResponseEntity sendDataNotification(@RequestBody PushNotification request) {
        this.pushNotificationService.sendPushNotification(request);
        return new ResponseEntity((Object)new PushNotificationResponse(HttpStatus.OK.value(), this.messageService.getMessage("notification.has.been.sent")), HttpStatus.OK);
    }

    @PostMapping(value={"/student/send/notification"})
    public ResponseEntity<Message> sendDataNotification(@RequestHeader(value="Authorization") String token, @RequestBody SendStudentNotificationRequest request) {
        Student student;
        int i;
        this.authService.isAuthenticated(token);
        List studentViews = request.getClass_id() != null ? this.classService.findStudentsByClassId(request.getClass_id().longValue()) : (request.getInstructor_id() != null ? this.studentRepository.findByInstructorId(request.getInstructor_id()) : (request.getIds() == null || request.getIds().isEmpty() ? this.studentRepository.findAllOrderById() : this.studentRepository.findByStudentIds(request.getIds())));
        if (studentViews == null || studentViews.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("students.are.not.found"));
        }
        StudentPushNotification studentPushNotification = new StudentPushNotification();
        studentPushNotification.setNotification_type(request.getPush_notification().getScreen_type());
        studentPushNotification.setTitle(request.getPush_notification().getTitle());
        studentPushNotification.setTitle_es(request.getPush_notification().getTitle_es());
        studentPushNotification.setMessage(request.getPush_notification().getMessage());
        studentPushNotification.setMessage_es(request.getPush_notification().getMessage_es());
        if (studentPushNotification.getNotification_type() != null && studentPushNotification.getNotification_type().equals((Object)NotificationType.SOCIO_EMOTIONAL_TEST)) {
            studentViews = studentViews.stream().filter(studentView -> {
                Standard standard = this.standardRepository.findByStandardId(studentView.getStandard_id());
                return standard != null && studentView.getStandard_id() > 0L && !this.socioEmotionalTestService.getStandardNamesWhichNotNeedSocioEmotionalTest().contains(standard.getStandard_name());
            }).collect(Collectors.toList());
        }
        if (studentViews.isEmpty() && studentPushNotification.getNotification_type() != null && studentPushNotification.getNotification_type().equals((Object)NotificationType.SOCIO_EMOTIONAL_TEST)) {
            Message message = new Message();
            message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        block7: for (i = 0; i < studentViews.size(); ++i) {
            System.out.println("Student id " + ((StudentView)studentViews.get(i)).getStudent_id() + " " + ((StudentView)studentViews.get(i)).getStandard_id());
            switch (1.$SwitchMap$com$infinite$focus$server$fcm$model$NotificationType[studentPushNotification.getNotification_type().ordinal()]) {
                case 1: {
                    student = this.studentRepository.findByStudentId(((StudentView)studentViews.get(i)).getStudent_id());
                    student.setShould_force_socio_emotional_assessment(true);
                    this.studentRepository.save((Object)student);
                    continue block7;
                }
            }
        }
        if (request.isSaveToDB()) {
            if ((request.getIds() == null || request.getIds().isEmpty()) && request.getInstructor_id() == null && !studentPushNotification.getNotification_type().equals((Object)NotificationType.SOCIO_EMOTIONAL_TEST)) {
                StudentPushNotification studentNotificationTemplate = new StudentPushNotification();
                studentNotificationTemplate.setStudent_id(0L);
                studentNotificationTemplate.setNotification_type(studentPushNotification.getNotification_type());
                studentNotificationTemplate.setTitle(studentPushNotification.getTitle());
                studentNotificationTemplate.setMessage(studentPushNotification.getMessage());
                studentNotificationTemplate.setCreatedAt(new Date());
                this.studentPushNotificationRepository.save((Object)studentNotificationTemplate);
                this.sendRealTimeNotificationToAllStudents(this.studentRepository.findAllOrderById(), studentPushNotification.getTitle(), studentPushNotification.getMessage());
            } else {
                for (i = 0; i < studentViews.size(); ++i) {
                    StudentPushNotification studentNotificationTemplate = new StudentPushNotification();
                    studentNotificationTemplate.setStudent_id(((StudentView)studentViews.get(i)).getStudent_id().longValue());
                    studentNotificationTemplate.setNotification_type(studentPushNotification.getNotification_type());
                    studentNotificationTemplate.setTitle(studentPushNotification.getTitle());
                    studentNotificationTemplate.setTitle_es(studentPushNotification.getTitle_es());
                    studentNotificationTemplate.setMessage(studentPushNotification.getMessage());
                    studentNotificationTemplate.setMessage_es(studentPushNotification.getMessage_es());
                    studentNotificationTemplate.setCreatedAt(new Date());
                    this.studentPushNotificationRepository.save((Object)studentNotificationTemplate);
                }
                this.sendRealTimeNotificationToAllStudents(studentViews, studentPushNotification.getTitle(), studentPushNotification.getMessage());
            }
            for (i = 0; i < studentViews.size(); ++i) {
                try {
                    student = this.studentRepository.findByStudentId(((StudentView)studentViews.get(i)).getStudent_id());
                    student.setNew_notificaitons(true);
                    this.studentRepository.save((Object)student);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            ArrayList<PushNotification> pushNotifications = new ArrayList<PushNotification>();
            ArrayList<String> tokens = new ArrayList<String>();
            for (int i2 = 0; i2 < studentViews.size(); ++i2) {
                String fcmToken = "CLYMB_" + ((StudentView)studentViews.get(i2)).getAccount_id() + "_NOTIFICATIONS_DEV";
                if (fcmToken == null || fcmToken.trim().isEmpty() || tokens.contains(fcmToken)) continue;
                PushNotification push_notification = new PushNotification();
                push_notification.setTitle(studentPushNotification.getTitle());
                push_notification.setMessage(studentPushNotification.getMessage());
                push_notification.setScreen_type(studentPushNotification.getNotification_type());
                push_notification.setTopic(fcmToken);
                tokens.add(fcmToken);
                pushNotifications.add(push_notification);
            }
            this.pushNotificationService.sendPushNotifications(pushNotifications);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    private void sendRealTimeNotificationToAllStudents(List<StudentView> studentViews, String title, String message) {
        try {
            for (StudentView studentView : studentViews) {
                this.realTimeMessageService.sendTitleAndMessage(studentView.getStudent_id().longValue(), title, message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

