/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.notification.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.request.SendEmotionNotificationRequest;
import com.infinite.focus.server.notification.request.SendSOSAlertNotificationToInstructorRequest;
import com.infinite.focus.server.notification.service.NotificationService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/notification"})
public class NotificationController {
    private final NotificationService notificationService;
    private final MessageService messageService;

    public NotificationController(NotificationService notificationService, MessageService messageService) {
        this.notificationService = notificationService;
        this.messageService = messageService;
    }

    @PostMapping(value={"/send-sos-alert-notification-to-instructor"})
    ResponseEntity<Object> sendSOSAlertNotificationToInstructor(@RequestBody SendSOSAlertNotificationToInstructorRequest request) {
        this.notificationService.sendSOSAlertNotificationToInstructor(request.getInstructor_id(), request.getStudent_id(), request.getParent_id(), request.getStudent_name(), request.getGrade());
        Message message = new Message(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/send-emotion-alert-notification"})
    ResponseEntity<Object> sendEmotionAlertNotification(@RequestBody SendEmotionNotificationRequest request) {
        this.notificationService.sendEmotionNotification(request.getStudent_id(), request.getStudent_name(), request.getInstructor_id(), request.getParent_id(), request.getCorporate_id(), request.getText(), request.getText_es());
        Message message = new Message(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }
}

