/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentbadge.service;

import com.infinite.focus.server.badge.entity.Badge;
import com.infinite.focus.server.badge.repository.BadgeRepository;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.studentbadge.entity.StudentBadge;
import com.infinite.focus.server.studentbadge.model.AssignedByType;
import com.infinite.focus.server.studentbadge.repository.StudentBadgeRepository;
import com.infinite.focus.server.studentbadge.service.StudentBadgeService;
import com.infinite.focus.server.studentpushnotification.request.BadgeReceivedRequest;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class StudentBadgeServiceImpl
implements StudentBadgeService {
    private final StudentBadgeRepository studentBadgeRepository;
    private final ClassRepository classRepository;
    private final BadgeRepository badgeRepository;
    private final ConfigurationRepository configurationRepository;
    private final RestComponent restComponent;

    public StudentBadgeServiceImpl(StudentBadgeRepository studentBadgeRepository, ClassRepository classRepository, BadgeRepository badgeRepository, ConfigurationRepository configurationRepository, RestComponent restComponent) {
        this.studentBadgeRepository = studentBadgeRepository;
        this.classRepository = classRepository;
        this.badgeRepository = badgeRepository;
        this.configurationRepository = configurationRepository;
        this.restComponent = restComponent;
    }

    public StudentBadge create(long student_id, String title, String title_es, String description, String description_es, AssignedByType assigned_by_type, long assigned_by_id, long badge_id) {
        StudentBadge studentBadge = new StudentBadge();
        studentBadge.setStudent_id(student_id);
        studentBadge.setAssigned_by_type(assigned_by_type);
        studentBadge.setAssigned_by_id(assigned_by_id);
        studentBadge.setBadge_id(badge_id);
        Badge badge = this.badgeRepository.findByBadgeId(Long.valueOf(badge_id));
        if (badge != null) {
            title = badge.getTitle();
            title_es = badge.getTitle_es();
            description = badge.getDescription();
            description_es = badge.getDescription_es();
        }
        studentBadge.setTitle(title);
        studentBadge.setTitle_es(title_es);
        studentBadge.setDescription(description);
        studentBadge.setDescription_es(description_es);
        return (StudentBadge)this.studentBadgeRepository.save((Object)studentBadge);
    }

    @Async
    @Transactional
    public void assignBadgeToStudents(List<Long> student_ids, AssignedByType assigned_by_type, long assigned_by_id, String name, long badge_id, String title, String title_es, String description, String description_es) {
        for (long student_id : student_ids) {
            try {
                StudentBadge studentBadge = this.create(student_id, title, title_es, description, description_es, assigned_by_type, assigned_by_id, badge_id);
                this.restComponent.badgeReceived(BadgeReceivedRequest.builder().student_id(student_id).format_text(name).title(studentBadge.getTitle()).title_es(studentBadge.getTitle_es()).build());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Async
    @Transactional
    public void assignBadgeToClasses(List<Long> class_ids, AssignedByType assigned_by_type, long assigned_by_id, String name, long badge_id, String title, String title_es, String description, String description_es) {
        HashSet student_ids = new HashSet();
        for (long id : class_ids) {
            Set ids = this.classRepository.findStudentViewsByClassId(id).stream().map(StudentView::getStudent_id).collect(Collectors.toSet());
            student_ids.addAll(ids);
        }
        if (!AppUtils.isNullOrEmpty(student_ids)) {
            this.assignBadgeToStudents(new ArrayList(student_ids), assigned_by_type, assigned_by_id, name, badge_id, title, title_es, description, title_es);
        }
    }

    public List<Badge> getStudentBadgeByStudentId(Long student_id) {
        String badgeImagesPath = this.configurationRepository.getConfiguration().getBadge_images_path();
        List badges = this.badgeRepository.findAllBadgesOrderByBadgeIdAsc();
        ArrayList<Badge> badgeWithIdZero = new ArrayList<Badge>();
        block0: for (StudentBadge studentBadge : this.studentBadgeRepository.findByStudentIdOrderByStudentBadgeIdDESC(student_id)) {
            Badge badge2 = this.badgeRepository.findByBadgeId(Long.valueOf(studentBadge.getBadge_id()));
            if (badge2 != null) {
                for (Badge item : badges) {
                    if (item.getBadge_id() != studentBadge.getBadge_id()) continue;
                    item.setCount(item.getCount() + 1L);
                    continue block0;
                }
                continue;
            }
            Badge badgeWitZeroId = new Badge();
            badgeWitZeroId.setTitle(studentBadge.getTitle());
            badgeWitZeroId.setTitle_es(studentBadge.getTitle_es());
            badgeWitZeroId.setDescription(studentBadge.getDescription());
            badgeWitZeroId.setDescription_es(studentBadge.getDescription_es());
            badgeWitZeroId.setImage("Badge.png");
            badgeWitZeroId.setCount(1L);
            badgeWitZeroId.setShould_show_on_front(true);
            badgeWitZeroId.setCreatedAt(studentBadge.getCreatedAt());
            badgeWithIdZero.add(badgeWitZeroId);
        }
        badges.addAll(badgeWithIdZero);
        return badges.stream().peek(badge -> badge.setImage(badgeImagesPath + badge.getImage())).sorted((c1, c2) -> Long.compare(c2.getCount(), c1.getCount())).collect(Collectors.toList());
    }
}

