/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.template.service;

import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.template.service.TemplateService;
import com.infinite.focus.server.unsubscribe.model.UnsubscribeType;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
public class TemplateServiceImpl
implements TemplateService {
    @Autowired
    ConfigurationService configurationService;

    public String getConsentForm(String nameOfOrganization, String shortLink, Student student, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/ConsentForm_es.html" : "static/documents/email_htmls/ConsentForm.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<profile_button>", this.getLearnMoreBtn()).replace("<style_sheet>", this.getStyleSheet()).replace("<name_of_organization>", nameOfOrganization).replace("<full_name_of_child>", student.getFirst_name() + " " + student.getLast_name()).replace("<short_link>", shortLink).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getFollowUpConsentForm(String nameOfOrganization, String shortLink, Student student, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/FollowUpConsentForm_es.html" : "static/documents/email_htmls/FollowUpConsentForm.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<profile_button>", this.getLearnMoreBtn()).replace("<style_sheet>", this.getStyleSheet()).replace("<name_of_organization>", nameOfOrganization).replace("<full_name_of_child>", student.getFirst_name() + " " + student.getLast_name()).replace("<short_link>", shortLink).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getForgotPasswordEmailText(String resetPasswordLink, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/ForgotPassword_es.html" : "static/documents/email_htmls/ForgotPassword.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<reset_password_link>", resetPasswordLink).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getAccountVerificationEmailText(String loginPageLink, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/AccountVerification_es.html" : "static/documents/email_htmls/AccountVerification.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<login_page_link>", loginPageLink).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getSendEmailToAllInstructorEmailText(String emailBody) {
        String content = null;
        try {
            String template = Language.isSpanish() ? "static/documents/email_htmls/AccountVerification_es.html" : "static/documents/email_htmls/AccountVerification.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<email_body>", emailBody).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getSendEmailToOrganizationAdminForDashboardAccess(String firstName, String nameOfOrganization, String websiteLink, String email, String password, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/OrganizationAdminForDashboardAccess_es.html" : "static/documents/email_htmls/OrganizationAdminForDashboardAccess.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<first_name>", firstName).replace("<name_of_organization>", nameOfOrganization).replace("<website_link>", websiteLink).replace("<email>", email).replace("<password>", password).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getSendEmailToParentForDashboardAccess(String corporateAdminName, String corporateName, String firstName, String fullName, String websiteLink, String email, String password, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/ParentDashboardAccess_es.html" : "static/documents/email_htmls/ParentDashboardAccess.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<first_name>", firstName).replace("<first_line>", AppUtils.isNullOrEmpty((String)corporateAdminName) ? "You have been invited to access the Clymb Dashboard from " + corporateName + "." : "You have been invited to access the Clymb Dashboard by " + corporateAdminName + " from " + corporateName + ".").replace("<website_link>", websiteLink).replace("<email>", email).replace("<password>", password).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getSendEmailToParentForDashboardAccessWithoutCorporate(String websiteLink, String email, String password, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/ParentDashboardAccessWithoutCorporate_es.html" : "static/documents/email_htmls/ParentDashboardAccessWithoutCorporate.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<website_link>", websiteLink).replace("<email>", email).replace("<password>", password).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getSendLicenseKeyEmail(String licenseKey, String license_key_email_get_started, String license_key_email_heres, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/LicenseKeyEmail_es.html" : "static/documents/email_htmls/LicenseKeyEmail.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<license_key>", licenseKey).replace("<license_key_email_get_started>", license_key_email_get_started).replace("<get_started_button>", this.getGetStartedButton()).replace("<license_key_email_heres>", license_key_email_heres).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getFreeTrialOrganizationEmail(String password, String free_trial_organization_email_get_started, String free_trial_organization_email_support_center) {
        String content = null;
        try {
            String template = Language.isSpanish() ? "static/documents/email_htmls/FreeTrailOrganizationEmail_es.html" : "static/documents/email_htmls/FreeTrailOrganizationEmail.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<password>", password).replace("<free_trial_organization_email_get_started>", free_trial_organization_email_get_started).replace("<get_started_button>", this.getGetStartedButton()).replace("<free_trial_organization_email_support_center>", free_trial_organization_email_support_center).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getPasswordChange(String firstName, String password, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/PasswordChange_es.html" : "static/documents/email_htmls/PasswordChange.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<first_name>", firstName).replace("<password>", password).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getMissingYouOnClymb(String username, String firstName, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/MissingYouOnClymb_es.html" : "static/documents/email_htmls/MissingYouOnClymb.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<first_name>", firstName).replace("<website_link>", this.configurationService.getConfiguration().getBaseUrl()).replace("<login_button>", this.getLoginButton()).replace("<unsubscribe_link>", this.configurationService.getConfiguration().getBaseUrl() + "login/unsubscribe?email_address=" + username + "&unsubscribe_type=" + UnsubscribeType.DID_NOT_LOGIN_AFTER_TWO_DAYS.getNumericValue()).replace("<unsubscribe_this_reminder_button>", this.getUnsubscribeThisReminderButton()).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getWoWPostOrPostsPendingApproval(String username, String firstName, long countOfPosts, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/WoWPostOrPostsPendingApproval_es.html" : "static/documents/email_htmls/WoWPostOrPostsPendingApproval.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<first_name>", firstName).replace("<XX_post_posts>", countOfPosts == 1L ? countOfPosts + " post" : countOfPosts + " posts").replace("<website_link>", this.configurationService.getConfiguration().getBaseUrl()).replace("<share_to_wall_of_wonder>", this.getShareToWallOfWonderButton()).replace("<unsubscribe_link>", this.configurationService.getConfiguration().getBaseUrl() + "login/unsubscribe?email_address=" + username + "&unsubscribe_type=" + UnsubscribeType.WOW_AFTER_NOT_BEING_APPROVED_AFTER_ONE_WEEK.getNumericValue()).replace("<unsubscribe_this_reminder_button>", this.getUnsubscribeThisReminderButton()).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public String getSOSEmailAskForHelpTemplate(String student_name, String grade, String language) {
        String content = null;
        try {
            String template = Language.isSpanish((String)language) ? "static/documents/email_htmls/SOSEmailAskForHelp_es.html" : "static/documents/email_htmls/SOSEmailAskForHelp.html";
            ClassPathResource classPathResource = new ClassPathResource(template);
            byte[] data = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            content = new String(data, StandardCharsets.UTF_8);
            content = content.replace("<brand_logo>", this.getBrandLogo()).replace("<style_sheet>", this.getStyleSheet()).replace("<student_name>", student_name).replace("<grade>", grade).replace("<year>", DateUtils.getCurrentYear());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    private String getBrandLogo() {
        return this.configurationService.getConfiguration().getBaseUrlApi() + "images/brand_logo/brand-logo.png";
    }

    private String getProfileButton() {
        return this.configurationService.getConfiguration().getBaseUrlApi() + "images/brand_logo/profile-btn.jpg";
    }

    private String getLearnMoreBtn() {
        return this.configurationService.getConfiguration().getBaseUrlApi() + "images/brand_logo/learn-more-btn.png";
    }

    private String getGetStartedButton() {
        return this.configurationService.getConfiguration().getBaseUrlApi() + "images/brand_logo/get-started.jpg";
    }

    private String getStyleSheet() {
        return this.configurationService.getConfiguration().getBaseUrlApi() + "images/brand_logo/stylesheet.css";
    }

    private String getLoginButton() {
        return this.getGetStartedButton();
    }

    private String getShareToWallOfWonderButton() {
        return this.configurationService.getConfiguration().getBaseUrlApi() + "images/brand_logo/share_to_wall_of_wonder.jpg";
    }

    private String getUnsubscribeThisReminderButton() {
        return this.configurationService.getConfiguration().getBaseUrlApi() + "images/brand_logo/unsubscribe_this_reminder.jpg";
    }
}

