/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.account.controller;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.request.GetEmailByAccountIdRequest;
import com.infinite.focus.server.account.response.GetEmailByAccountIdResponse;
import com.infinite.focus.server.account.service.AccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/account"})
public class AccountController {
    @Autowired
    private AccountService accountService;

    @PostMapping(value={"/get-by-id"})
    @ResponseBody
    public ResponseEntity<Account> getById(@RequestBody GetEmailByAccountIdRequest request) {
        return new ResponseEntity((Object)this.accountService.getAccountById(request.getAccount_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-email-by-account-id"})
    @ResponseBody
    public ResponseEntity<GetEmailByAccountIdResponse> getEmailByAccountId(@RequestBody GetEmailByAccountIdRequest request) {
        return new ResponseEntity((Object)GetEmailByAccountIdResponse.builder().email(this.accountService.getEmailByAccountId(request.getAccount_id())).build(), HttpStatus.OK);
    }
}

