/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.mood.controller;

import com.infinite.focus.server.data.model.EmotionCountAndAverage;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.request.GetMoodsByIdsRequest;
import com.infinite.focus.server.mood.service.MoodService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/mood"})
public class MoodController {
    private final MoodService moodService;

    public MoodController(MoodService moodService) {
        this.moodService = moodService;
    }

    @GetMapping(value={"/get-ask-for-help-moods"})
    public ResponseEntity<List<MoodDTO>> getAskForHelpMoods() {
        return new ResponseEntity((Object)this.moodService.getAskForHelpMoods(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-moods-by-ids"})
    public ResponseEntity<List<MoodDTO>> getMoodsByIds(@RequestBody GetMoodsByIdsRequest request) {
        return new ResponseEntity((Object)this.moodService.getMoodsByIds(request.getIds()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-moods"})
    public ResponseEntity<List<MoodDTO>> getAllMoods() {
        return new ResponseEntity((Object)this.moodService.getAllMoods(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-emotions-and-sub-emotions"})
    public ResponseEntity<List<EmotionCountAndAverage>> getAllEmotionsAndSubEmotions() {
        return new ResponseEntity((Object)this.moodService.getAllEmotionsAndSubEmotions(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-emotions"})
    public ResponseEntity<EmotionsByStandards> getAllEmotions() {
        return new ResponseEntity((Object)this.moodService.getAllEmotions(), HttpStatus.OK);
    }
}

