/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.helper;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.notification.model.NotificationType;
import com.infinite.focus.server.streak.entity.Streak;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.studentpushnotification.entity.StudentPushNotification;
import com.infinite.focus.server.studentpushnotification.repository.StudentPushNotificationRepository;
import com.infinite.focus.server.studentstreak.entity.StudentStreak;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.Date;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StreakHelper {
    @Autowired
    StudentPushNotificationRepository studentPushNotificationRepository;
    @Autowired
    private RealTimeMessageService realTimeMessageService;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    StudentStreakRepository studentStreakRepository;
    @Autowired
    ConfigurationRepository configurationRepository;

    public Streak saveStudentStreak(long student_id, Streak streak) {
        Student student = this.studentRepository.findByStudentId(Long.valueOf(student_id));
        StudentStreak studentStreak = new StudentStreak();
        studentStreak.setStudent_id(student_id);
        studentStreak.setStreak_id(streak.getStreak_id());
        if (student.isDemo()) {
            long lastId = this.studentStreakRepository.findLastRecordId();
            studentStreak.setStudent_streak_id(lastId);
            studentStreak.setCreatedAt(new Date());
        } else {
            this.studentStreakRepository.save((Object)studentStreak);
        }
        this.sendStreakNotification(student_id, student.isDemo(), "Streak Achieved", "Racha de logros", "You have achieved a new streak: " + streak.getTitle(), "Has conseguido una nueva racha: " + streak.getTitle_es());
        Streak s = new Streak();
        s.setStreak_id(streak.getStreak_id());
        s.setTitle(streak.getTitle());
        s.setTitle_es(streak.getTitle_es());
        s.setDescription(streak.getDescription());
        s.setDescription_es(streak.getDescription_es());
        s.setImage(this.configurationRepository.getConfiguration().getStreak_images_path() + streak.getImage());
        s.setImage_es(this.configurationRepository.getConfiguration().getStreak_images_path() + streak.getImage_es());
        s.setOccurrence(streak.getOccurrence());
        s.setStreak_type(streak.getStreak_type());
        s.setReceived(true);
        s.setCreatedAt(streak.getCreatedAt());
        return s;
    }

    public Streak getStreakFromStreak(Streak streak) {
        Streak s = new Streak();
        s.setStreak_id(streak.getStreak_id());
        s.setTitle(streak.getTitle());
        s.setTitle_es(streak.getTitle_es());
        s.setDescription(streak.getDescription());
        s.setDescription_es(streak.getDescription_es());
        s.setImage(this.configurationRepository.getConfiguration().getStreak_images_path() + streak.getImage());
        s.setImage_es(this.configurationRepository.getConfiguration().getStreak_images_path() + streak.getImage_es());
        s.setOccurrence(streak.getOccurrence());
        s.setStreak_type(streak.getStreak_type());
        s.setReceived(streak.isReceived());
        s.setCreatedAt(streak.getCreatedAt());
        return s;
    }

    @Transactional
    private void sendStreakNotification(long student_id, boolean demo, String title, String title_es, String message, String message_es) {
        StudentPushNotification studentPushNotification = new StudentPushNotification();
        studentPushNotification.setStudent_id(student_id);
        studentPushNotification.setNotification_type(NotificationType.STREAK_RECEIVED);
        studentPushNotification.setTitle(title);
        studentPushNotification.setTitle_es(title_es);
        studentPushNotification.setMessage(message);
        studentPushNotification.setMessage_es(message_es);
        if (!demo) {
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
        }
        this.realTimeMessageService.sendTitleAndMessage(student_id, studentPushNotification.getTitle(), studentPushNotification.getMessage());
        Student student = this.studentRepository.findByStudentId(Long.valueOf(student_id));
        student.setNew_notificaitons(true);
        this.studentRepository.save((Object)student);
    }
}

