/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dailyappreciation.controller;

import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.dailyappreciation.dto.DailyAppreciationDTO;
import com.infinite.focus.server.dailyappreciation.service.DailyAppreciationService;
import com.infinite.focus.server.home.request.GetDailyAppreciationForStudentRequest;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/appreciation"})
public class DailyAppreciationController {
    private final AuthService authService;
    private final DailyAppreciationService dailyAppreciationService;

    public DailyAppreciationController(AuthService authService, DailyAppreciationService dailyAppreciationService) {
        this.authService = authService;
        this.dailyAppreciationService = dailyAppreciationService;
    }

    @PostMapping(value={"/get-page-by-student-id"})
    public ResponseEntity<Page<DailyAppreciationDTO>> getAllDailyAppreciationForStudent(@RequestHeader(value="Authorization") String token, @RequestBody GetDailyAppreciationForStudentRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.dailyAppreciationService.getDailyAppreciationPageByStudentId(request.getStudent_id().longValue(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy()), HttpStatus.OK);
    }
}

