/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dataset.service;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.category.service.CategoryService;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.dataset.dataservice.DataSetDataService;
import com.infinite.focus.server.dataset.entity.DataSet;
import com.infinite.focus.server.dataset.model.AssessmentCategory;
import com.infinite.focus.server.dataset.model.AssessmentCategoryAndName;
import com.infinite.focus.server.dataset.repository.DataSetCoreRepository;
import com.infinite.focus.server.dataset.service.DataSetService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class DataSetServiceImpl
implements DataSetService {
    private final ConfigurationService configurationService;
    private final DataSetDataService dataSetDataService;
    private final CategoryService categoryService;
    private final MessageService messageService;
    private final DataSetCoreRepository dataSetCoreRepository;

    public DataSetServiceImpl(ConfigurationService configurationService, DataSetDataService dataSetDataService, CategoryService categoryService, MessageService messageService, DataSetCoreRepository dataSetCoreRepository) {
        this.configurationService = configurationService;
        this.dataSetDataService = dataSetDataService;
        this.categoryService = categoryService;
        this.messageService = messageService;
        this.dataSetCoreRepository = dataSetCoreRepository;
    }

    public Boolean isValidDataSet(DataSet dataSet) {
        if (dataSet == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.data.set.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)dataSet.getAssessment_category_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.dataset.s.assessment.category.name.is.null.or.empty"));
        }
        if (AppUtils.isNullOrEmpty((String)dataSet.getTitle())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.dataset.s.title.is.null.or.empty"));
        }
        if (dataSet.getSub_title() != null && AppUtils.isNullOrEmpty((String)dataSet.getSub_title())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.dataset.s.sub.title.is.null.or.empty"));
        }
        if (dataSet.getScore() <= 0.0) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.dataset.s.score.should.be.greater.than.zero"));
        }
        return true;
    }

    public List<DataSet> getDataSets() {
        return this.dataSetDataService.getDataSets();
    }

    public DataSet getDataSetById(long data_set_id) {
        return this.dataSetDataService.getDataSetById(data_set_id);
    }

    public DataSet createDataSet(AssessmentCategory assessment_category, String assessment_category_name, String title, String sub_title, double score) {
        DataSet dataSet = new DataSet();
        dataSet.setAssessment_category(assessment_category);
        dataSet.setAssessment_category_name(assessment_category_name);
        dataSet.setTitle(title);
        dataSet.setSub_title(sub_title);
        dataSet.setScore(score);
        return this.createDataSet(dataSet);
    }

    public DataSet createDataSet(DataSet dataSet) {
        this.isValidDataSet(dataSet);
        return this.dataSetDataService.createDataSet(dataSet);
    }

    public DataSet updateDataSet(DataSet dataSet) {
        DataSet dataSetItem = this.getDataSetById(dataSet.getData_set_id());
        dataSetItem.setAssessment_category(dataSet.getAssessment_category());
        dataSetItem.setAssessment_category_name(dataSet.getAssessment_category_name());
        dataSetItem.setTitle(dataSet.getTitle());
        dataSetItem.setSub_title(dataSet.getSub_title());
        dataSetItem.setScore(dataSet.getScore());
        dataSetItem.setCreatedAt(dataSet.getCreatedAt());
        dataSetItem.setUpdatedAt(new Date());
        this.isValidDataSet(dataSet);
        return this.dataSetDataService.updateDataSet(dataSet);
    }

    public Message deleteDataSetById(long data_set_id) {
        DataSet dataSet = this.dataSetDataService.getDataSetById(data_set_id);
        if (dataSet == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.data.set.is.not.found"));
        }
        this.dataSetDataService.deleteDataSet(dataSet);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("the.dataset.is.deleted.successfully"));
        return message;
    }

    public List<DataSet> getDataSetsByAssessmentCategory(AssessmentCategory assessmentCategory) {
        return this.dataSetDataService.getDataSetsByAssessmentCategory(assessmentCategory);
    }

    public DataSet addDataSetImages(DataSet dataSet) {
        String data_set_images_path = this.configurationService.getConfiguration().getData_set_images_path();
        if (dataSet != null && dataSet.getImage() != null && !dataSet.getImage().contains(data_set_images_path)) {
            System.out.println(data_set_images_path);
            String dataSetImage = data_set_images_path + dataSet.getImage();
            dataSet.setImage(dataSetImage);
        }
        return dataSet;
    }

    public List<DataSet> addDataSetsImages(List<DataSet> dataSets) {
        if (AppUtils.isNotNullOrEmpty(dataSets)) {
            for (DataSet dataSet : dataSets) {
                this.addDataSetImages(dataSet);
            }
        }
        return dataSets;
    }

    public CategoryDTO getCategoryByDataSetId(long data_set_id) {
        DataSet dataSet = this.getDataSetById(data_set_id);
        return this.categoryService.getCategoryById(dataSet.getResource_library_category_id());
    }

    public List<AssessmentCategoryAndName> getAssessmentChildCategoriesAndNamesByAssessmentCategory(AssessmentCategory assessmentCategory) {
        return this.dataSetDataService.getAssessmentChildCategoriesAndNamesByAssessmentCategory(assessmentCategory);
    }

    public List<PVState> getPVStatesByDataSetIds(List<Long> data_set_ids) {
        ArrayList<PVState> pvStates = new ArrayList<PVState>();
        List dataSetDTOS = this.dataSetCoreRepository.findByIds(data_set_ids);
        for (long data_set_id : data_set_ids) {
            dataSetDTOS.stream().filter(d -> d.getData_set_id() == data_set_id).findAny().ifPresent(dataSetDTO -> pvStates.add(dataSetDTO.getPv_state()));
        }
        return pvStates;
    }
}

