/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.studentstreak.entity.StudentStreak;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.StudentStreakService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class StudentStreakServiceImpl
implements StudentStreakService {
    private final StreakRepository streakRepository;
    private final StudentStreakRepository studentStreakRepository;
    private final ConfigurationRepository configurationRepository;

    public StudentStreakServiceImpl(StreakRepository streakRepository, StudentStreakRepository studentStreakRepository, ConfigurationRepository configurationRepository) {
        this.streakRepository = streakRepository;
        this.studentStreakRepository = studentStreakRepository;
        this.configurationRepository = configurationRepository;
    }

    public List<StreakDTO> getStudentStreaksByStudentId(long student_id) {
        String streakImagePath = this.configurationRepository.getConfiguration().getStreak_images_path();
        List streaks = this.streakRepository.findByStreaksOrderByStreakIdASC();
        block0: for (StudentStreak studentStreak : this.studentStreakRepository.findByStudentId(Long.valueOf(student_id))) {
            for (StreakDTO streak2 : streaks) {
                if (streak2.getStreak_id() != studentStreak.getStreak_id()) continue;
                streak2.setReceived(true);
                continue block0;
            }
        }
        return streaks.stream().peek(streak -> {
            streak.setImage(streakImagePath + streak.getImage());
            streak.setImage_es(streakImagePath + streak.getImage_es());
        }).sorted((c1, c2) -> Boolean.compare(c2.isReceived(), c1.isReceived())).collect(Collectors.toList());
    }
}

