/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service.resourcelibrary;

import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.favorite.repository.FavoriteRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.studentstreak.helper.StreakHelper;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.resourcelibrary.StreakResourceLibraryService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class StreakResourceLibraryServiceImpl
implements StreakResourceLibraryService {
    private final StreakRepository streakRepository;
    private final StudentStreakRepository studentStreakRepository;
    private final FavoriteRepository favoriteRepository;
    private final StreakHelper streakHelper;

    public StreakResourceLibraryServiceImpl(StreakRepository streakRepository, StudentStreakRepository studentStreakRepository, FavoriteRepository favoriteRepository, StreakHelper streakHelper) {
        this.streakRepository = streakRepository;
        this.studentStreakRepository = studentStreakRepository;
        this.favoriteRepository = favoriteRepository;
        this.streakHelper = streakHelper;
    }

    public StreakDTO addStreakResourceLibrary(long student_id) {
        List streaks = this.streakRepository.findByStreakType(StreakType.RESOURCE_LIBRARY.name());
        if (!AppUtils.isNullOrEmpty((List)streaks) && this.studentStreakRepository.findByStudentIdAndStreakId(Long.valueOf(student_id), Long.valueOf(((StreakDTO)streaks.get(0)).getStreak_id())) == null) {
            return this.streakHelper.saveStudentStreak(student_id, (StreakDTO)streaks.get(0));
        }
        return null;
    }

    public StreakDTO addStreakSaveVideos(long student_id) {
        List favorites = this.favoriteRepository.findByStudentId(Long.valueOf(student_id));
        List streaks = this.streakRepository.findByStreakType(StreakType.SAVED_VIDEOS.name());
        for (StreakDTO streak : streaks) {
            if (streak.getOccurrence() != favorites.size() || this.studentStreakRepository.findByStudentIdAndStreakId(Long.valueOf(student_id), Long.valueOf(streak.getStreak_id())) != null) continue;
            return this.streakHelper.saveStudentStreak(student_id, streak);
        }
        return null;
    }

    public StreakDTO addStreakClymbTime(long student_id, List<Activity> activities) {
        List streaks = this.streakRepository.findByStreakType(StreakType.CLYMB_TIME.name());
        for (StreakDTO streak : streaks) {
            if (streak.getOccurrence() != activities.size() || this.studentStreakRepository.findByStudentIdAndStreakId(Long.valueOf(student_id), Long.valueOf(streak.getStreak_id())) != null) continue;
            return this.streakHelper.saveStudentStreak(student_id, streak);
        }
        return null;
    }
}

