/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpost.service;

import com.infinite.focus.server.avatar.entity.Avatar;
import com.infinite.focus.server.avatar.repository.AvatarRepository;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.instructor.view.InstructorView;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.request.ReviewWOWPostNotification;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.studentpushnotification.request.WOWPostUnacceptableContentNotification;
import com.infinite.focus.server.studentpushnotification.request.WOWPostUnacceptableContentNotifications;
import com.infinite.focus.server.studentpushnotification.request.WOWReactionNotification;
import com.infinite.focus.server.studentstreak.service.wallpost.StreakWallPostService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.wallpost.component.WallPostBadWordFilterComponent;
import com.infinite.focus.server.wallpost.entity.WallPost;
import com.infinite.focus.server.wallpost.model.Reaction;
import com.infinite.focus.server.wallpost.model.WallPostType;
import com.infinite.focus.server.wallpost.repository.WallPostRepository;
import com.infinite.focus.server.wallpost.request.RespondRequest;
import com.infinite.focus.server.wallpost.response.AddWallPostReactionResponse;
import com.infinite.focus.server.wallpost.response.CreateWallPostResponse;
import com.infinite.focus.server.wallpost.response.GetWallPostsWithBadWordsResponse;
import com.infinite.focus.server.wallpost.service.WallPostService;
import com.infinite.focus.server.wallpost.view.WallPostView;
import com.infinite.focus.server.wallpost.wrapper.WallPostProfileWrapper;
import com.infinite.focus.server.wallpost.wrapper.WallPostWrapper;
import com.infinite.focus.server.wallpostattachment.entity.WallPostAttachment;
import com.infinite.focus.server.wallpostattachment.repository.WallPostAttachmentRepository;
import com.infinite.focus.server.wallpostimage.dto.WallPostImageDTO;
import com.infinite.focus.server.wallpostimage.repository.WallPostImageRepository;
import com.infinite.focus.server.wallpostreaction.entity.WallPostReaction;
import com.infinite.focus.server.wallpostreaction.repository.WallPostReactionRepository;
import com.infinite.focus.server.wallpostreaction.view.WallPostReactionView;
import com.infinite.focus.server.wallpostrequest.entity.WallPostRequest;
import com.infinite.focus.server.wallpostrequest.request.WallPostRequestRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class WallPostServiceImpl
implements WallPostService {
    private final RestComponent restComponent;
    private final MessageService messageService;
    private final StreakWallPostService streakWallPostService;
    private final WallPostRepository wallPostRepository;
    private final WallPostRequestRepository wallPostRequestRepository;
    private final StudentRepository studentRepository;
    private final InstructorRepository instructorRepository;
    private final WallPostAttachmentRepository wallPostAttachmentRepository;
    private final WallPostImageRepository wallPostImageRepository;
    private final WallPostReactionRepository wallPostReactionRepository;
    private final PostRepository postRepository;
    private final StreakRepository streakRepository;
    private final ConfigurationRepository configurationRepository;
    private final SchoolRepository schoolRepository;
    private final AvatarRepository avatarRepository;
    private final WallPostBadWordFilterComponent badWordFilterComponent;

    public WallPostServiceImpl(RestComponent restComponent, MessageService messageService, StreakWallPostService streakWallPostService, WallPostRepository wallPostRepository, WallPostRequestRepository wallPostRequestRepository, StudentRepository studentRepository, InstructorRepository instructorRepository, WallPostAttachmentRepository wallPostAttachmentRepository, WallPostImageRepository wallPostImageRepository, WallPostReactionRepository wallPostReactionRepository, PostRepository postRepository, StreakRepository streakRepository, ConfigurationRepository configurationRepository, SchoolRepository schoolRepository, AvatarRepository avatarRepository, WallPostBadWordFilterComponent badWordFilterComponent) {
        this.restComponent = restComponent;
        this.messageService = messageService;
        this.streakWallPostService = streakWallPostService;
        this.wallPostRepository = wallPostRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.studentRepository = studentRepository;
        this.instructorRepository = instructorRepository;
        this.wallPostAttachmentRepository = wallPostAttachmentRepository;
        this.wallPostImageRepository = wallPostImageRepository;
        this.wallPostReactionRepository = wallPostReactionRepository;
        this.postRepository = postRepository;
        this.streakRepository = streakRepository;
        this.configurationRepository = configurationRepository;
        this.schoolRepository = schoolRepository;
        this.avatarRepository = avatarRepository;
        this.badWordFilterComponent = badWordFilterComponent;
    }

    public WallPostBadWordFilterComponent getWallPostBadWordFilterComponent() {
        return this.badWordFilterComponent;
    }

    public Page<Object> getWallPosts(Student student, Instructor instructor, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.wallPostRepository.findAllActive((Pageable)paging);
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(wallPostView -> {
            PostDTO postView;
            InstructorView instructorView;
            School school;
            LinkedHashMap wrapper = new LinkedHashMap();
            LinkedHashMap<String, Object> wrapperWallPost = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> wallPost = new LinkedHashMap<String, Object>();
            wallPost.put("wall_post_id", wallPostView.getWall_post_id());
            wallPost.put("student_id", wallPostView.getStudent_id());
            wallPost.put("instructor_id", wallPostView.getInstructor_id());
            wallPost.put("post_id", wallPostView.getPost_id());
            wallPost.put("streak_id", wallPostView.getStreak_id());
            wallPost.put("text", wallPostView.getText());
            wallPost.put("type", wallPostView.getType());
            String title = wallPostView.getTitle();
            if (Language.isSpanish() && !AppUtils.isNullOrEmpty((String)wallPostView.getTitle_es())) {
                title = wallPostView.getTitle_es();
            }
            wallPost.put("title", title);
            String description = wallPostView.getDescription();
            if (Language.isSpanish() && !AppUtils.isNullOrEmpty((String)wallPostView.getDescription_es())) {
                description = wallPostView.getDescription_es();
            }
            wallPost.put("description", description);
            wallPost.put("image", wallPostView.getImage());
            wallPost.put("wow_message", wallPostView.getWow_message());
            wallPost.put("wow_message_es", wallPostView.getWow_message_es());
            wallPost.put("wall_post_type", wallPostView.getWall_post_type());
            wallPost.put("isActive", wallPostView.getIsActive());
            wallPost.put("likes", wallPostView.getLikes());
            if (student != null && student.getStudent_id() != wallPostView.getStudent_id()) {
                long views = wallPostView.getViews() + 1L;
                this.wallPostRepository.updateView(views, wallPostView.getWall_post_id());
                wallPost.put("views", views);
            } else {
                wallPost.put("views", wallPostView.getViews());
            }
            if (wallPostView.getWall_post_type().equals(WallPostType.BADGE.name())) {
                // empty if block
            }
            wallPost.put("isDeleted", wallPostView.getIsDeleted());
            wallPost.put("approved_date", wallPostView.getApproved_date());
            wallPost.put("deleted_date", wallPostView.getDeleted_date());
            Set wallPostReactionViews = this.wallPostReactionRepository.findWallPostReactionViewByWallPostId(Long.valueOf(wallPostView.getWall_post_id()));
            wallPost.put("wallPostReactions", wallPostReactionViews.stream().collect(Collectors.groupingBy(WallPostReactionView::getReaction, Collectors.counting())));
            wallPost.put("reaction", wallPostReactionViews.stream().filter(wallPostReactionView -> student != null && wallPostReactionView.getStudent_id().longValue() == student.getStudent_id()).findFirst().map(WallPostReactionView::getReaction).orElse(null));
            wallPost.put("createdAt", wallPostView.getCreated_at());
            wrapperWallPost.put("wallPost", wallPost);
            List wallPostAttachments = this.getWallPostAttachmentsByWallPostId(Long.valueOf(wallPostView.getWall_post_id()));
            wrapperWallPost.put("attachments", wallPostAttachments);
            wrapperWallPost.put("hasBadWords", this.badWordFilterComponent.isThereAnyBadWordInText(wallPostView.getText()));
            boolean auto_approve_wall_posts = false;
            if (student != null && (school = this.schoolRepository.findBySchoolId(Long.valueOf(student.getSchool_id()))) != null) {
                auto_approve_wall_posts = school.isAuto_approve_wall_posts();
            }
            wrapperWallPost.put("auto_approve_wall_posts", auto_approve_wall_posts);
            wrapper.put("wallPost", wrapperWallPost);
            System.out.println("Type was " + wallPostView.getType());
            if (wallPostView.getType().toLowerCase().trim().equals("student")) {
                LinkedHashMap<String, Object> wrapperStudent = new LinkedHashMap<String, Object>();
                StudentView studentView = this.studentRepository.findStudentViewByStudentId(Long.valueOf(wallPostView.getStudent_id()));
                wrapperStudent.put("student_id", studentView.getStudent_id());
                wrapperStudent.put("account_id", studentView.getAccount_id());
                wrapperStudent.put("instructor_id", studentView.getInstructor_id());
                wrapperStudent.put("parent_id", studentView.getParent_id());
                wrapperStudent.put("first_name", studentView.getFirst_name());
                wrapperStudent.put("last_name", studentView.getLast_name());
                wrapperStudent.put("avatar_id", studentView.getAvatar_id());
                Avatar avatar = this.avatarRepository.findByAvatarId(studentView.getAvatar_id());
                if (avatar != null) {
                    wrapperStudent.put("avatar_name", avatar.getAvatar_name());
                    wrapperStudent.put("avatar_url", avatar.getPreview_url());
                } else {
                    wrapperStudent.put("avatar_url", null);
                }
                wrapper.put("student", wrapperStudent);
            }
            if (wallPostView.getType().toLowerCase().trim().equals("instructor") && (instructorView = this.instructorRepository.findInstructorViewByInstructorId(Long.valueOf(wallPostView.getInstructor_id()))) != null) {
                LinkedHashMap<String, Object> wrapperInstructor = new LinkedHashMap<String, Object>();
                wrapperInstructor.put("instructor_id", instructorView.getInstructor_id());
                wrapperInstructor.put("account_id", instructorView.getAccount_id());
                wrapperInstructor.put("registration_code", instructorView.getRegistration_code());
                wrapperInstructor.put("first_name", instructorView.getFirst_name());
                wrapperInstructor.put("last_name", instructorView.getLast_name());
                wrapper.put("instructor", wrapperInstructor);
            }
            if (wallPostView.getWall_post_type().equals(WallPostType.RESOURCE_LIBRARY.name()) && (postView = this.postRepository.findById(wallPostView.getPost_id())) != null) {
                LinkedHashMap<String, Object> wrapperPost = new LinkedHashMap<String, Object>();
                wrapperPost.put("post_id", postView.getPost_id());
                wrapperPost.put("post_title", postView.getPost_title());
                wrapperPost.put("post_title_es", postView.getPost_title_es());
                wrapperPost.put("post_description", postView.getPost_description());
                wrapperPost.put("post_description_es", postView.getPost_description_es());
                wrapperPost.put("post_cover_image_url", postView.getPost_cover_image_url());
                wrapperPost.put("post_cover_image_url_es", postView.getPost_cover_image_url_es());
                wrapperPost.put("post_duration", postView.getPost_duration());
                wrapperPost.put("post_duration_es", postView.getPost_duration_es());
                wrapperPost.put("post_video_url", postView.getPost_video_url());
                wrapperPost.put("post_video_url_es", postView.getPost_video_url_es());
                wrapperPost.put("oEmbed_html", postView.getoEmbed_html());
                wrapperPost.put("oEmbed_html_es", postView.getoEmbed_html_es());
                wrapperPost.put("post_type", postView.getPost_type());
                wrapperPost.put("createdAt", postView.getCreatedAt());
                wrapperPost.put("updatedAt", postView.getUpdatedAt());
                wrapper.put("post", wrapperPost);
            }
            if (wallPostView.getWall_post_type().equals(WallPostType.STREAK.name())) {
                StreakDTO streakView = this.streakRepository.findByStreakId(wallPostView.getStreak_id());
                LinkedHashMap<String, Object> wrapperStreak = new LinkedHashMap<String, Object>();
                wrapperStreak.put("streak_id", streakView.getStreak_id());
                wrapperStreak.put("image", this.configurationRepository.getConfiguration().getStreak_images_path() + streakView.getImage());
                wrapperStreak.put("image_es", this.configurationRepository.getConfiguration().getStreak_images_path() + streakView.getImage_es());
                wrapperStreak.put("title", streakView.getTitle());
                wrapperStreak.put("title_es", streakView.getTitle_es());
                wrapperStreak.put("description", streakView.getDescription());
                wrapperStreak.put("description_es", streakView.getDescription_es());
                wrapperStreak.put("occurrence", streakView.getOccurrence());
                wrapperStreak.put("streak_type", streakView.getStreak_type());
                wrapperStreak.put("createdAt", streakView.getCreatedAt());
                wrapper.put("streak", wrapperStreak);
            }
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public Page<Object> getMyChildPosts(Parent parent, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        Student student = null;
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.wallPostRepository.findAllActiveByStudentIds(parent.getStudents().stream().map(Student::getStudent_id).collect(Collectors.toSet()), (Pageable)paging);
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(wallPostView -> {
            PostDTO postView;
            InstructorView instructorView;
            School school;
            LinkedHashMap wrapper = new LinkedHashMap();
            LinkedHashMap<String, Object> wrapperWallPost = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> wallPost = new LinkedHashMap<String, Object>();
            wallPost.put("wall_post_id", wallPostView.getWall_post_id());
            wallPost.put("student_id", wallPostView.getStudent_id());
            wallPost.put("instructor_id", wallPostView.getInstructor_id());
            wallPost.put("post_id", wallPostView.getPost_id());
            wallPost.put("streak_id", wallPostView.getStreak_id());
            wallPost.put("text", wallPostView.getText());
            wallPost.put("type", wallPostView.getType());
            String title = wallPostView.getTitle();
            if (Language.isSpanish() && !AppUtils.isNullOrEmpty((String)wallPostView.getTitle_es())) {
                title = wallPostView.getTitle_es();
            }
            wallPost.put("title", title);
            String description = wallPostView.getDescription();
            if (Language.isSpanish() && !AppUtils.isNullOrEmpty((String)wallPostView.getDescription_es())) {
                description = wallPostView.getDescription_es();
            }
            wallPost.put("description", description);
            wallPost.put("image", wallPostView.getImage());
            wallPost.put("wow_message", wallPostView.getWow_message());
            wallPost.put("wow_message_es", wallPostView.getWow_message_es());
            wallPost.put("wall_post_type", wallPostView.getWall_post_type());
            wallPost.put("isActive", wallPostView.getIsActive());
            wallPost.put("likes", wallPostView.getLikes());
            if (student != null && student.getStudent_id() != wallPostView.getStudent_id()) {
                long views = wallPostView.getViews() + 1L;
                this.wallPostRepository.updateView(views, wallPostView.getWall_post_id());
                wallPost.put("views", views);
            } else {
                wallPost.put("views", wallPostView.getViews());
            }
            if (wallPostView.getWall_post_type().equals(WallPostType.BADGE.name())) {
                // empty if block
            }
            wallPost.put("isDeleted", wallPostView.getIsDeleted());
            wallPost.put("approved_date", wallPostView.getApproved_date());
            wallPost.put("deleted_date", wallPostView.getDeleted_date());
            Set wallPostReactionViews = this.wallPostReactionRepository.findWallPostReactionViewByWallPostId(Long.valueOf(wallPostView.getWall_post_id()));
            wallPost.put("wallPostReactions", wallPostReactionViews.stream().collect(Collectors.groupingBy(WallPostReactionView::getReaction, Collectors.counting())));
            wallPost.put("reaction", wallPostReactionViews.stream().filter(wallPostReactionView -> student != null && wallPostReactionView.getStudent_id().longValue() == student.getStudent_id()).findFirst().map(WallPostReactionView::getReaction).orElse(null));
            wallPost.put("createdAt", wallPostView.getCreated_at());
            wrapperWallPost.put("wallPost", wallPost);
            List wallPostAttachments = this.getWallPostAttachmentsByWallPostId(Long.valueOf(wallPostView.getWall_post_id()));
            wrapperWallPost.put("attachments", wallPostAttachments);
            wrapperWallPost.put("hasBadWords", this.badWordFilterComponent.isThereAnyBadWordInText(wallPostView.getText()));
            boolean auto_approve_wall_posts = false;
            if (student != null && (school = this.schoolRepository.findBySchoolId(Long.valueOf(student.getSchool_id()))) != null) {
                auto_approve_wall_posts = school.isAuto_approve_wall_posts();
            }
            wrapperWallPost.put("auto_approve_wall_posts", auto_approve_wall_posts);
            wrapper.put("wallPost", wrapperWallPost);
            System.out.println("Type was " + wallPostView.getType());
            if (wallPostView.getType().toLowerCase().trim().equals("student")) {
                LinkedHashMap<String, Object> wrapperStudent = new LinkedHashMap<String, Object>();
                StudentView studentView = this.studentRepository.findStudentViewByStudentId(Long.valueOf(wallPostView.getStudent_id()));
                wrapperStudent.put("student_id", studentView.getStudent_id());
                wrapperStudent.put("account_id", studentView.getAccount_id());
                wrapperStudent.put("instructor_id", studentView.getInstructor_id());
                wrapperStudent.put("parent_id", studentView.getParent_id());
                wrapperStudent.put("first_name", studentView.getFirst_name());
                wrapperStudent.put("last_name", studentView.getLast_name());
                wrapperStudent.put("avatar_id", studentView.getAvatar_id());
                Avatar avatar = this.avatarRepository.findByAvatarId(studentView.getAvatar_id());
                if (avatar != null) {
                    wrapperStudent.put("avatar_name", avatar.getAvatar_name());
                    wrapperStudent.put("avatar_url", avatar.getPreview_url());
                } else {
                    wrapperStudent.put("avatar_url", null);
                }
                wrapper.put("student", wrapperStudent);
            }
            if (wallPostView.getType().toLowerCase().trim().equals("instructor") && (instructorView = this.instructorRepository.findInstructorViewByInstructorId(Long.valueOf(wallPostView.getInstructor_id()))) != null) {
                LinkedHashMap<String, Object> wrapperInstructor = new LinkedHashMap<String, Object>();
                wrapperInstructor.put("instructor_id", instructorView.getInstructor_id());
                wrapperInstructor.put("account_id", instructorView.getAccount_id());
                wrapperInstructor.put("registration_code", instructorView.getRegistration_code());
                wrapperInstructor.put("first_name", instructorView.getFirst_name());
                wrapperInstructor.put("last_name", instructorView.getLast_name());
                wrapper.put("instructor", wrapperInstructor);
            }
            if (wallPostView.getWall_post_type().equals(WallPostType.RESOURCE_LIBRARY.name()) && (postView = this.postRepository.findById(wallPostView.getPost_id())) != null) {
                LinkedHashMap<String, Object> wrapperPost = new LinkedHashMap<String, Object>();
                wrapperPost.put("post_id", postView.getPost_id());
                wrapperPost.put("post_title", postView.getPost_title());
                wrapperPost.put("post_title_es", postView.getPost_title_es());
                wrapperPost.put("post_description", postView.getPost_description());
                wrapperPost.put("post_description_es", postView.getPost_description_es());
                wrapperPost.put("post_cover_image_url", postView.getPost_cover_image_url());
                wrapperPost.put("post_cover_image_url_es", postView.getPost_cover_image_url_es());
                wrapperPost.put("post_duration", postView.getPost_duration());
                wrapperPost.put("post_duration_es", postView.getPost_duration_es());
                wrapperPost.put("post_video_url", postView.getPost_video_url());
                wrapperPost.put("post_video_url_es", postView.getPost_video_url_es());
                wrapperPost.put("oEmbed_html", postView.getoEmbed_html());
                wrapperPost.put("oEmbed_html_es", postView.getoEmbed_html_es());
                wrapperPost.put("post_type", postView.getPost_type());
                wrapperPost.put("createdAt", postView.getCreatedAt());
                wrapperPost.put("updatedAt", postView.getUpdatedAt());
                wrapper.put("post", wrapperPost);
            }
            if (wallPostView.getWall_post_type().equals(WallPostType.STREAK.name())) {
                StreakDTO streakView = this.streakRepository.findByStreakId(wallPostView.getStreak_id());
                LinkedHashMap<String, Object> wrapperStreak = new LinkedHashMap<String, Object>();
                wrapperStreak.put("streak_id", streakView.getStreak_id());
                wrapperStreak.put("image", this.configurationRepository.getConfiguration().getStreak_images_path() + streakView.getImage());
                wrapperStreak.put("image_es", this.configurationRepository.getConfiguration().getStreak_images_path() + streakView.getImage_es());
                wrapperStreak.put("title", streakView.getTitle());
                wrapperStreak.put("title_es", streakView.getTitle_es());
                wrapperStreak.put("description", streakView.getDescription());
                wrapperStreak.put("description_es", streakView.getDescription_es());
                wrapperStreak.put("occurrence", streakView.getOccurrence());
                wrapperStreak.put("streak_type", streakView.getStreak_type());
                wrapperStreak.put("createdAt", streakView.getCreatedAt());
                wrapper.put("streak", wrapperStreak);
            }
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public Page<Object> getWallPostsByStudent(Student student, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.wallPostRepository.findAllActiveByStudentId(student.getStudent_id(), (Pageable)paging);
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(wallPostView -> {
            PostDTO postView;
            InstructorView instructorView;
            LinkedHashMap wrapper = new LinkedHashMap();
            LinkedHashMap<String, Object> wrapperWallPost = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> wallPost = new LinkedHashMap<String, Object>();
            wallPost.put("wall_post_id", wallPostView.getWall_post_id());
            wallPost.put("student_id", wallPostView.getStudent_id());
            wallPost.put("instructor_id", wallPostView.getInstructor_id());
            wallPost.put("post_id", wallPostView.getPost_id());
            wallPost.put("streak_id", wallPostView.getStreak_id());
            wallPost.put("text", wallPostView.getText());
            wallPost.put("type", wallPostView.getType());
            String title = wallPostView.getTitle();
            if (Language.isSpanish() && !AppUtils.isNullOrEmpty((String)wallPostView.getTitle_es())) {
                title = wallPostView.getTitle_es();
            }
            wallPost.put("title", title);
            String description = wallPostView.getDescription();
            if (Language.isSpanish() && !AppUtils.isNullOrEmpty((String)wallPostView.getDescription_es())) {
                description = wallPostView.getDescription_es();
            }
            wallPost.put("description", description);
            wallPost.put("image", wallPostView.getImage());
            wallPost.put("wow_message", wallPostView.getWow_message());
            wallPost.put("wow_message_es", wallPostView.getWow_message_es());
            wallPost.put("wall_post_type", wallPostView.getWall_post_type());
            wallPost.put("isActive", wallPostView.getIsActive());
            wallPost.put("likes", wallPostView.getLikes());
            if (student.getStudent_id() != wallPostView.getStudent_id()) {
                long views = wallPostView.getViews() + 1L;
                this.wallPostRepository.updateView(views, wallPostView.getWall_post_id());
                wallPost.put("views", views);
            } else {
                wallPost.put("views", wallPostView.getViews());
            }
            if (wallPostView.getWall_post_type().equals(WallPostType.BADGE.name())) {
                // empty if block
            }
            wallPost.put("isDeleted", wallPostView.getIsDeleted());
            wallPost.put("approved_date", wallPostView.getApproved_date());
            wallPost.put("deleted_date", wallPostView.getDeleted_date());
            Set wallPostReactionViews = this.wallPostReactionRepository.findWallPostReactionViewByWallPostId(Long.valueOf(wallPostView.getWall_post_id()));
            wallPost.put("wallPostReactions", wallPostReactionViews.stream().collect(Collectors.groupingBy(WallPostReactionView::getReaction, Collectors.counting())));
            wallPost.put("reaction", wallPostReactionViews.stream().filter(wallPostReactionView -> wallPostReactionView.getStudent_id().longValue() == student.getStudent_id()).findFirst().map(WallPostReactionView::getReaction).orElse(null));
            wallPost.put("createdAt", wallPostView.getCreated_at());
            wrapperWallPost.put("wallPost", wallPost);
            List wallPostAttachments = this.getWallPostAttachmentsByWallPostId(Long.valueOf(wallPostView.getWall_post_id()));
            wrapperWallPost.put("attachments", wallPostAttachments);
            wrapperWallPost.put("hasBadWords", this.badWordFilterComponent.isThereAnyBadWordInText(wallPostView.getText()));
            boolean auto_approve_wall_posts = false;
            School school = this.schoolRepository.findBySchoolId(Long.valueOf(student.getSchool_id()));
            if (school != null) {
                auto_approve_wall_posts = school.isAuto_approve_wall_posts();
            }
            wrapperWallPost.put("auto_approve_wall_posts", auto_approve_wall_posts);
            wrapper.put("wallPost", wrapperWallPost);
            System.out.println("Type was " + wallPostView.getType());
            if (wallPostView.getType().toLowerCase().trim().equals("student")) {
                LinkedHashMap<String, Object> wrapperStudent = new LinkedHashMap<String, Object>();
                StudentView studentView = this.studentRepository.findStudentViewByStudentId(Long.valueOf(wallPostView.getStudent_id()));
                wrapperStudent.put("student_id", studentView.getStudent_id());
                wrapperStudent.put("account_id", studentView.getAccount_id());
                wrapperStudent.put("instructor_id", studentView.getInstructor_id());
                wrapperStudent.put("parent_id", studentView.getParent_id());
                wrapperStudent.put("first_name", studentView.getFirst_name());
                wrapperStudent.put("last_name", studentView.getLast_name());
                wrapperStudent.put("avatar_id", studentView.getAvatar_id());
                Avatar avatar = this.avatarRepository.findByAvatarId(studentView.getAvatar_id());
                if (avatar != null) {
                    wrapperStudent.put("avatar_name", avatar.getAvatar_name());
                    wrapperStudent.put("avatar_url", avatar.getPreview_url());
                } else {
                    wrapperStudent.put("avatar_url", null);
                }
                wrapper.put("student", wrapperStudent);
            }
            if (wallPostView.getType().toLowerCase().trim().equals("instructor") && (instructorView = this.instructorRepository.findInstructorViewByInstructorId(Long.valueOf(wallPostView.getInstructor_id()))) != null) {
                LinkedHashMap<String, Object> wrapperInstructor = new LinkedHashMap<String, Object>();
                wrapperInstructor.put("instructor_id", instructorView.getInstructor_id());
                wrapperInstructor.put("account_id", instructorView.getAccount_id());
                wrapperInstructor.put("registration_code", instructorView.getRegistration_code());
                wrapperInstructor.put("first_name", instructorView.getFirst_name());
                wrapperInstructor.put("last_name", instructorView.getLast_name());
                wrapper.put("instructor", wrapperInstructor);
            }
            if (wallPostView.getWall_post_type().equals(WallPostType.RESOURCE_LIBRARY.name()) && (postView = this.postRepository.findById(wallPostView.getPost_id())) != null) {
                LinkedHashMap<String, Object> wrapperPost = new LinkedHashMap<String, Object>();
                wrapperPost.put("post_id", postView.getPost_id());
                wrapperPost.put("post_title", postView.getPost_title());
                wrapperPost.put("post_title_es", postView.getPost_title_es());
                wrapperPost.put("post_description", postView.getPost_description());
                wrapperPost.put("post_description_es", postView.getPost_description_es());
                wrapperPost.put("post_cover_image_url", postView.getPost_cover_image_url());
                wrapperPost.put("post_cover_image_url_es", postView.getPost_cover_image_url_es());
                wrapperPost.put("post_duration", postView.getPost_duration());
                wrapperPost.put("post_duration_es", postView.getPost_duration_es());
                wrapperPost.put("post_video_url", postView.getPost_video_url());
                wrapperPost.put("post_video_url_es", postView.getPost_video_url_es());
                wrapperPost.put("oEmbed_html", postView.getoEmbed_html());
                wrapperPost.put("oEmbed_html_es", postView.getoEmbed_html_es());
                wrapperPost.put("post_type", postView.getPost_type());
                wrapperPost.put("createdAt", postView.getCreatedAt());
                wrapperPost.put("updatedAt", postView.getUpdatedAt());
                wrapper.put("post", wrapperPost);
            }
            if (wallPostView.getWall_post_type().equals(WallPostType.STREAK.name())) {
                StreakDTO streakView = this.streakRepository.findByStreakId(wallPostView.getStreak_id());
                LinkedHashMap<String, Object> wrapperStreak = new LinkedHashMap<String, Object>();
                wrapperStreak.put("streak_id", streakView.getStreak_id());
                wrapperStreak.put("image", this.configurationRepository.getConfiguration().getStreak_images_path() + streakView.getImage());
                wrapperStreak.put("image_es", this.configurationRepository.getConfiguration().getStreak_images_path() + streakView.getImage_es());
                wrapperStreak.put("title", streakView.getTitle());
                wrapperStreak.put("title_es", streakView.getTitle_es());
                wrapperStreak.put("description", streakView.getDescription());
                wrapperStreak.put("description_es", streakView.getDescription_es());
                wrapperStreak.put("occurrence", streakView.getOccurrence());
                wrapperStreak.put("streak_type", streakView.getStreak_type());
                wrapperStreak.put("createdAt", streakView.getCreatedAt());
                wrapper.put("streak", wrapperStreak);
            }
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public List<WallPostAttachment> getWallPostAttachmentsByWallPostId(Long wall_post_id) {
        List wallPostAttachments = this.wallPostAttachmentRepository.findByWallPost(wall_post_id);
        for (WallPostAttachment attachment : wallPostAttachments) {
            WallPostImageDTO wallPostImage;
            if (attachment.getWall_post_image_id() == 0L || (wallPostImage = this.wallPostImageRepository.findById(attachment.getWall_post_image_id())) == null) continue;
            String attachmentUrl = wallPostImage.getUrl();
            if (Language.isSpanish() && !AppUtils.isNullOrEmpty((String)wallPostImage.getUrl_es())) {
                attachmentUrl = wallPostImage.getUrl_es();
            }
            attachment.setUrl(attachmentUrl);
        }
        return wallPostAttachments;
    }

    public Page<WallPostProfileWrapper> getWallPostsByInstructorId(long instructor_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.wallPostRepository.findAllActiveByInstructorId(instructor_id, (Pageable)paging);
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(w -> {
            WallPostProfileWrapper wr = new WallPostProfileWrapper();
            WallPostWrapper wpr = new WallPostWrapper();
            wpr.setWallPost(w);
            wpr.setAttachments(this.getWallPostAttachmentsByWallPostId(Long.valueOf(w.getWall_post_id())));
            wr.setWallPost(wpr);
            if (w.getType().toLowerCase().trim().equals("student")) {
                wr.setStudent(this.studentRepository.findByStudentId(Long.valueOf(w.getStudent_id())));
            }
            if (w.getType().toLowerCase().trim().equals("instructor")) {
                wr.setInstructor(this.instructorRepository.findByInstructorId(Long.valueOf(w.getInstructor_id())));
            }
            return wr;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public AddWallPostReactionResponse addWallPostReaction(long student_id, String first_name, String last_name, long wall_post_id, String reaction) {
        WallPostReaction wallPostReaction = this.wallPostReactionRepository.findByStudentIdAndWallPostId(student_id, wall_post_id);
        if (wallPostReaction != null) {
            if (AppUtils.isNullOrEmpty((String)reaction)) {
                this.wallPostReactionRepository.delete((Object)wallPostReaction);
            } else {
                wallPostReaction.setReaction(Reaction.valueOf((String)reaction));
                this.wallPostReactionRepository.save((Object)wallPostReaction);
            }
        } else if (!AppUtils.isNullOrEmpty((String)reaction)) {
            wallPostReaction = new WallPostReaction();
            Student student = this.studentRepository.findByStudentId(Long.valueOf(student_id));
            wallPostReaction.setStudent(student);
            WallPost wallPost = this.wallPostRepository.findByWallPostId(wall_post_id);
            wallPostReaction.setWallPost(wallPost);
            wallPostReaction.setReaction(Reaction.valueOf((String)reaction));
            this.wallPostReactionRepository.save((Object)wallPostReaction);
        }
        WallPost wallPost = this.wallPostRepository.findByWallPostId(wall_post_id);
        wallPost.setReaction(student_id);
        if (student_id != wallPost.getStudent_id()) {
            StudentCoreDTO studentCoreDTO = this.restComponent.getStudentByStudentId(wallPost.getStudent_id());
            WOWReactionNotification wowReactionNotification = WOWReactionNotification.builder().student_id(studentCoreDTO.getStudent_id()).account_id(studentCoreDTO.getAccount_id()).demo(studentCoreDTO.isDemo()).reaction(reaction).text(wallPost.getText()).format_text(first_name.trim() + " " + last_name.trim()).build();
            this.restComponent.wowReaction(wowReactionNotification);
        }
        AddWallPostReactionResponse addWallPostReactionResponse = new AddWallPostReactionResponse();
        addWallPostReactionResponse.setWall_post(wallPost);
        StreakDTO streak = this.streakWallPostService.addStreakWallPostReaction(student_id);
        addWallPostReactionResponse.setStreak(streak);
        return addWallPostReactionResponse;
    }

    public List<WallPostRequest> syncWallPostRequests() {
        List wallPostRequests = this.wallPostRequestRepository.findAll();
        return this.syncWallPostRequests(wallPostRequests);
    }

    @Async
    public void syncWallPostRequests(Student student) {
        List wallPostIds;
        if (student != null && !AppUtils.isNullOrEmpty(wallPostIds = this.wallPostRepository.findByStudentId(student.getStudent_id()).stream().map(WallPost::getWall_post_id).collect(Collectors.toList()))) {
            List wallPostRequests = this.wallPostRequestRepository.findByWallPostIds(wallPostIds);
            this.syncWallPostRequests(wallPostRequests);
        }
    }

    public WallPost approveRejectWallPost(RespondRequest respondRequest) {
        WallPostRequest w = this.wallPostRequestRepository.findByWallPostRequestId(respondRequest.getWall_post_request_id());
        if (w == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT);
        }
        WallPost p = this.wallPostRepository.findByWallPostId(w.getWall_post_id());
        if (p == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT);
        }
        if (respondRequest.getResponse().booleanValue()) {
            this.wallPostRequestRepository.delete((Object)w);
            p.setIsActive(Boolean.valueOf(true));
            p.setApproved_date(new Date());
            return (WallPost)this.wallPostRepository.save((Object)p);
        }
        this.wallPostRequestRepository.delete((Object)w);
        p.setIsDeleted(Boolean.valueOf(true));
        p.setDeleted_date(new Date());
        return (WallPost)this.wallPostRepository.save((Object)p);
    }

    public WallPost approveRejectWallPostByWallPostId(RespondRequest respondRequest) {
        WallPostRequest w = this.wallPostRequestRepository.findByWallPostRequestId(respondRequest.getWall_post_request_id());
        if (w == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT);
        }
        WallPost p = this.wallPostRepository.findByWallPostId(w.getWall_post_id());
        if (p == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT);
        }
        if (this.badWordFilterComponent.isThereAnyBadWordInText(p.getText()).booleanValue()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Post contains bad word.");
        }
        if (respondRequest.getResponse().booleanValue()) {
            this.wallPostRequestRepository.delete((Object)w);
            p.setIsActive(Boolean.valueOf(true));
            p.setApproved_date(new Date());
            return (WallPost)this.wallPostRepository.save((Object)p);
        }
        this.wallPostRequestRepository.delete((Object)w);
        p.setIsDeleted(Boolean.valueOf(true));
        p.setDeleted_date(new Date());
        return (WallPost)this.wallPostRepository.save((Object)p);
    }

    public WallPost getByWallPostId(long wall_post_id) {
        return this.wallPostRepository.findByWallPostId(wall_post_id);
    }

    public GetWallPostsWithBadWordsResponse getWallPostsWithBadWords(Date fromDate) {
        ArrayList<WallPostView> wallPostViewsActiveAndBadWords = new ArrayList<WallPostView>();
        List allActivePosts = this.wallPostRepository.findAllActive(fromDate);
        for (WallPostView wallPostView : allActivePosts) {
            if (AppUtils.isNullOrEmpty((String)wallPostView.getText()) || !this.badWordFilterComponent.isThereAnyBadWordInText(wallPostView.getText()).booleanValue()) continue;
            wallPostViewsActiveAndBadWords.add(wallPostView);
        }
        return GetWallPostsWithBadWordsResponse.builder().count_of_active_wall_post_with_bad_words((long)wallPostViewsActiveAndBadWords.size()).active_wall_post_with_bad_words(wallPostViewsActiveAndBadWords).build();
    }

    public CreateWallPostResponse createWallPostStudent(WallPostWrapper wallPostWrapper) {
        StreakDTO streakWallPostPicture;
        WallPost wallPost;
        Student student = this.studentRepository.findByStudentId(Long.valueOf(wallPostWrapper.getWallPost().getStudent_id()));
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT);
        }
        boolean auto_approve_wall_posts = false;
        if (student.getSchool() != null && student.getSchool().isAuto_approve_wall_posts()) {
            boolean bl = auto_approve_wall_posts = student.getInstructor() != null && student.getInstructor().isAuto_approve_wall_posts();
        }
        if (this.badWordFilterComponent.isThereAnyBadWordInText(wallPostWrapper.getWallPost().getText()).booleanValue()) {
            auto_approve_wall_posts = false;
            WOWPostUnacceptableContentNotification wowPostUnacceptableContentNotification = WOWPostUnacceptableContentNotification.builder().student_id(student.getStudent_id()).account_id(student.getAccount_id()).demo(student.isDemo()).build();
            this.restComponent.wowPostUnacceptableContent(wowPostUnacceptableContentNotification);
        }
        wallPostWrapper.getWallPost().setType("student");
        if (!auto_approve_wall_posts) {
            wallPostWrapper.getWallPost().setIsActive(Boolean.valueOf(false));
        } else {
            wallPostWrapper.getWallPost().setIsActive(Boolean.valueOf(true));
            wallPostWrapper.getWallPost().setApproved_date(new Date());
        }
        wallPostWrapper.getWallPost().setIsDeleted(Boolean.valueOf(false));
        if (student.isDemo()) {
            long id = this.wallPostRepository.getLastRecordId() + 1L;
            wallPostWrapper.getWallPost().setWall_post_id(id);
            wallPostWrapper.getWallPost().setCreatedAt(new Date());
            wallPost = wallPostWrapper.getWallPost();
        } else {
            wallPost = (WallPost)this.wallPostRepository.save((Object)wallPostWrapper.getWallPost());
        }
        for (WallPostAttachment w : wallPostWrapper.getAttachments()) {
            w.setWall_post_id(wallPost.getWall_post_id());
            if (student.isDemo()) continue;
            this.wallPostAttachmentRepository.save((Object)w);
        }
        if (!auto_approve_wall_posts) {
            WallPostRequest wallPostRequest = new WallPostRequest();
            wallPostRequest.setInstructor_id(student.getInstructor() != null ? student.getInstructor().getInstructor_id() : 0L);
            wallPostRequest.setParent_id(student.getParent() != null ? student.getParent().getParent_id() : 0L);
            wallPostRequest.setWall_post_id(wallPost.getWall_post_id());
            if (!student.isDemo()) {
                this.wallPostRequestRepository.save((Object)wallPostRequest);
            }
        }
        CreateWallPostResponse createWallPostResponse = new CreateWallPostResponse();
        createWallPostResponse.setWall_post(wallPost);
        StreakDTO streakWallPost = this.streakWallPostService.addStreakWallPost(student.getStudent_id());
        if (streakWallPost != null) {
            createWallPostResponse.setStreak(streakWallPost);
        }
        if ((streakWallPostPicture = this.streakWallPostService.addStreakWallPostPicture(student.getStudent_id())) != null) {
            createWallPostResponse.setStreak(streakWallPostPicture);
        }
        if (auto_approve_wall_posts) {
            return createWallPostResponse;
        }
        ReviewWOWPostNotification reviewWOWPostNotification = ReviewWOWPostNotification.builder().student_id(student.getStudent_id()).text(wallPost.getText()).build();
        this.restComponent.reviewWOWPost(reviewWOWPostNotification);
        return createWallPostResponse;
    }

    public WallPost deleteWallPost(long wall_post_id) {
        WallPost wp = this.wallPostRepository.findByWallPostId(wall_post_id);
        if (wp == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.post.is.not.found"));
        }
        wp.setIsDeleted(Boolean.valueOf(true));
        wp.setDeleted_date(new Date());
        WallPost wallPost = (WallPost)this.wallPostRepository.save((Object)wp);
        if (wallPost.getType().equalsIgnoreCase("student") && wallPost.getStudent_id() > 0L && !AppUtils.isNullOrEmpty((String)wallPost.getText()) && this.badWordFilterComponent.isThereAnyBadWordInText(wallPost.getText()).booleanValue()) {
            StudentCoreDTO studentCoreDTO = this.restComponent.getStudentByStudentId(wallPost.getStudent_id());
            WOWPostUnacceptableContentNotification wowPostUnacceptableContentNotification = WOWPostUnacceptableContentNotification.builder().student_id(studentCoreDTO.getStudent_id()).account_id(studentCoreDTO.getAccount_id()).demo(studentCoreDTO.isDemo()).build();
            this.restComponent.wowPostUnacceptableContent(wowPostUnacceptableContentNotification);
        }
        return wallPost;
    }

    public void deleteWallPosts(Set<Long> wall_post_ids) {
        HashSet<Long> studentIds = new HashSet<Long>();
        for (long wall_post_id : wall_post_ids) {
            WallPost wallPost = this.deleteWallPost(wall_post_id);
            if (!wallPost.getType().equalsIgnoreCase("student") || wallPost.getStudent_id() <= 0L || AppUtils.isNullOrEmpty((String)wallPost.getText()) || !this.badWordFilterComponent.isThereAnyBadWordInText(wallPost.getText()).booleanValue()) continue;
            studentIds.add(wallPost.getStudent_id());
        }
        WOWPostUnacceptableContentNotifications wowPostUnacceptableContentNotifications = WOWPostUnacceptableContentNotifications.builder().student_ids(studentIds).build();
        this.restComponent.wowPostUnacceptableContents(wowPostUnacceptableContentNotifications);
    }

    private List<WallPostRequest> syncWallPostRequests(List<WallPostRequest> wallPostRequests) {
        for (WallPostRequest wallPostRequest : wallPostRequests) {
            Student student;
            WallPost wallPost = this.wallPostRepository.findByWallPostId(wallPostRequest.getWall_post_id());
            if (wallPost == null || (student = this.studentRepository.findByStudentId(Long.valueOf(wallPost.getStudent_id()))) == null) continue;
            wallPostRequest.setInstructor_id(student.getInstructor() != null ? student.getInstructor().getInstructor_id() : 0L);
            wallPostRequest.setParent_id(student.getParent() != null ? student.getParent().getParent_id() : 0L);
            this.wallPostRequestRepository.save((Object)wallPostRequest);
        }
        return wallPostRequests;
    }
}

