/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.category.repository;

import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.category.repository.CategoryRepository;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.web.server.ResponseStatusException;

@Repository
public class CategoryRepositoryImpl
implements CategoryRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static CategoryDTO mapRow(ResultSet rs, int i) throws SQLException {
        return CategoryDTO.builder().category_id(rs.getLong("category_id")).category_name(rs.getString("category_name")).category_name_es(rs.getString("category_name_es")).status(rs.getInt("status")).createdAt((Date)rs.getTimestamp("created_at")).updatedAt((Date)rs.getTimestamp("updated_at")).build();
    }

    public CategoryDTO create(String category_name, String category_name_es, int status) {
        String INSERT_SQL = "INSERT INTO category (category_name, category_name_es, status, created_at, updated_at) VALUES (?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO category (category_name, category_name_es, status, created_at, updated_at) VALUES (?,?,?,?,?)", 1);
            ps.setString(1, category_name);
            ps.setString(2, category_name_es);
            ps.setInt(3, status);
            ps.setTimestamp(4, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(5, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int category_id = Objects.requireNonNull(holder.getKey()).intValue();
        return this.findById((long)category_id);
    }

    public CategoryDTO update(long category_id, String category_name, String category_name_es, int status) {
        String SQL = "UPDATE category SET category_name = ?, category_name_es = ?, status = ?, updated_at = ? WHERE category_id = ? ";
        int updateCount = this.jdbcTemplate.update("UPDATE category SET category_name = ?, category_name_es = ?, status = ?, updated_at = ? WHERE category_id = ? ", new Object[]{category_name, category_name_es, status, Timestamp.valueOf(LocalDateTime.now()), category_id});
        if (updateCount == 1) {
            return this.findById(category_id);
        }
        throw new ResponseStatusException(HttpStatus.CONFLICT, "Not updated!!!");
    }

    public CategoryDTO findById(long id) {
        String SQL = "SELECT * FROM category WHERE category_id = ?";
        try {
            return (CategoryDTO)this.jdbcTemplate.queryForObject(SQL, CategoryRepositoryImpl::mapRow, new Object[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<CategoryDTO> findAll() {
        String SQL = "SELECT * FROM category ORDER BY category_id ASC";
        try {
            return this.jdbcTemplate.query(SQL, CategoryRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<CategoryDTO>();
        }
    }

    public Page<CategoryDTO> findPageByCategoryName(String category_name, Pageable pageable) {
        String rowCountSql = "SELECT count(1) AS row_count FROM category WHERE CASE WHEN ? IS NOT NULL " + (Language.isSpanish() ? "THEN category_name_es LIKE '%" : "THEN category_name LIKE '%") + category_name + "%' ELSE true END ";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(rowCountSql, new Object[]{category_name}, (rs, rowNum) -> rs.getInt(1));
        StringBuilder querySql = new StringBuilder("SELECT * FROM category WHERE CASE WHEN ? IS NOT NULL " + (Language.isSpanish() ? "THEN category_name_es LIKE '%" : "THEN category_name LIKE '%") + category_name + "%' ELSE true END ");
        for (Sort.Order order : pageable.getSort()) {
            System.out.println("Property: " + order.getProperty());
            System.out.println("Direction: " + order.getDirection());
            querySql.append("ORDER BY ").append(order.getProperty()).append(" ").append(order.getDirection()).append(" ");
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(querySql.toString(), new Object[]{category_name}, CategoryRepositoryImpl::mapRow);
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }

    public void deleteById(long id) {
        String SQL = "DELETE FROM category WHERE category_id = ?";
        this.jdbcTemplate.update("DELETE FROM category WHERE category_id = ?", new Object[]{id});
    }

    public List<CategoryDTO> findByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<CategoryDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM category WHERE category_id IN(%s) ORDER BY category_id ASC";
        List categoryDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), CategoryRepositoryImpl::mapRow);
        return categoryDTOS;
    }
}

