/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.notification.service;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.fcm.dto.PushNotificationDTO;
import com.infinite.focus.server.fcm.request.SendFirebasePushNotificationRequest;
import com.infinite.focus.server.home.request.GetNotificationsRequest;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.repository.MessageRepository;
import com.infinite.focus.server.notification.entity.Notification;
import com.infinite.focus.server.notification.model.NotificationType;
import com.infinite.focus.server.notification.repository.NotificationRepository;
import com.infinite.focus.server.notification.request.BadWordInJournalNotification;
import com.infinite.focus.server.notification.request.CorporateNotification;
import com.infinite.focus.server.notification.request.MoodUpdateNotification;
import com.infinite.focus.server.notification.request.ReviewWOWPostNotification;
import com.infinite.focus.server.notification.request.SOSAlertNotification;
import com.infinite.focus.server.notification.service.NotificationService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NotificationServiceImpl
implements NotificationService {
    private final EntityManager entityManager;
    private final NotificationRepository notificationRepository;
    private final MessageRepository messageRepository;
    private final RealTimeMessageService realTimeMessageService;
    private final RestComponent restComponent;
    private final ConfigurationRepository configurationRepository;

    public NotificationServiceImpl(EntityManager entityManager, NotificationRepository notificationRepository, MessageRepository messageRepository, RealTimeMessageService realTimeMessageService, RestComponent restComponent, ConfigurationRepository configurationRepository) {
        this.entityManager = entityManager;
        this.notificationRepository = notificationRepository;
        this.messageRepository = messageRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.restComponent = restComponent;
        this.configurationRepository = configurationRepository;
    }

    public Page<Notification> getNotificationsByInstructorId(GetNotificationsRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Notification.class);
        Root root = query.from(Notification.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getStudentIds())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)root.get("student_id")).value((Object)request.getStudentIds());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((Set)request.getNotification_types())) {
            CriteriaBuilder.In notificationTypePredicate = qb.in((Expression)root.get("notification_type")).value((Object)request.getNotification_types());
            predicates.add(notificationTypePredicate);
        }
        if (request.getViewed() != null) {
            predicates.add(qb.equal((Expression)root.get("viewed_instructor"), (Object)request.getViewed()));
        }
        predicates.add(qb.equal((Expression)root.get("instructor_id"), (Object)request.getInstructor_id()));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getNotifications FromDate " + DateUtils.dayWitTimeFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dayWitTimeFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("createdAt"), (Comparable)DateUtils.getFromDateWithoutTime((Date)request.getFromDate()), (Comparable)DateUtils.getToDateWithoutTime((Date)request.getToDate())));
        }
        query.where(predicates.toArray(new Predicate[0]));
        if (request.getOrderBy().equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)root.get(request.getSortBy()))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)root.get(request.getSortBy()))});
        }
        PageRequest pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(Notification.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        for (Notification notification : pagedResult) {
            notification.setViewed_instructor(true);
            this.notificationRepository.save((Object)notification);
        }
        return pagedResult;
    }

    public Page<Notification> getNotificationsByParentIds(List<Long> studentIds, List<Long> parentIds, Integer pageNo, Integer pageSize, String sortBy, String orderBy, Date fromDate, Date toDate, Boolean viewed) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Notification.class);
        Root root = query.from(Notification.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty(studentIds)) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)root.get("student_id")).value(studentIds);
            predicates.add(genderPredicate);
        }
        if (viewed != null) {
            predicates.add(qb.equal((Expression)root.get("viewed_parent"), (Object)viewed));
        }
        predicates.add(qb.in((Expression)root.get("parent_id")).value(parentIds));
        if (fromDate != null && toDate != null) {
            System.out.println("getNotifications FromDate " + DateUtils.dayWitTimeFormat.format(fromDate) + " - ToDate " + DateUtils.dayWitTimeFormat.format(toDate));
            predicates.add(qb.between((Expression)root.get("createdAt"), (Comparable)DateUtils.getFromDateWithoutTime((Date)fromDate), (Comparable)DateUtils.getToDateWithoutTime((Date)toDate)));
        }
        query.where(predicates.toArray(new Predicate[0]));
        if (orderBy.equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)root.get(sortBy))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)root.get(sortBy))});
        }
        PageRequest pageable = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(Notification.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        for (Notification notification : pagedResult) {
            if (!notification.isViewed_parent()) {
                notification.setViewed_parent(true);
                this.notificationRepository.save((Object)notification);
            }
            if (notification.getNotification_type() != NotificationType.SOS_ALERT) continue;
            if (!AppUtils.isNullOrEmpty((String)notification.getText())) {
                notification.setText(notification.getText().replace("Please reach out to this student as soon as you can.", "Please reach out to this child as soon as you can."));
            }
            if (AppUtils.isNullOrEmpty((String)notification.getText_es())) continue;
            notification.setText_es(notification.getText_es().replace("Por favor comun\u00edquese con este estudiante lo m\u00e1s pronto que pueda.", "Por favor, ac\u00e9rquese a este ni\u00f1o tan pronto como pueda."));
        }
        return pagedResult;
    }

    @Async
    public void sosAlertNotification(SOSAlertNotification sosAlertNotification) {
        StudentCoreDTO student = this.restComponent.getStudentByStudentId(sosAlertNotification.getStudent_id());
        Instructor instructor = this.restComponent.getInstructorById(student.getInstructor_id());
        StandardDTO standardDTO = this.restComponent.getStandardById(student.getStandard_id());
        Notification notification = new Notification();
        notification.setInstructor_id(student.getInstructor_id());
        notification.setParent_id(student.getParent_id());
        notification.setStudent_id(student.getInstructor_id());
        notification.setNotification_type(NotificationType.SOS_ALERT);
        notification.setTitle(this.messageRepository.getMessage().getSos_alert_title());
        notification.setTitle_es(this.messageRepository.getMessage().getSos_alert_title_es());
        notification.setText(this.messageRepository.getMessage().getSos_alert_message().replace("<grade>", standardDTO.getStandard_name()));
        notification.setText_es(this.messageRepository.getMessage().getSos_alert_message_es().replace("<grade>", standardDTO.getStandard_name()));
        notification.setFormat_text(student.getFirst_name() + " " + student.getLast_name());
        this.notificationRepository.save((Object)notification);
        if (instructor != null) {
            this.restComponent.setNewNotificationsForInstructor(Long.valueOf(instructor.getInstructor_id()), true);
            this.realTimeMessageService.sendJsonMessage(student.getInstructor_id(), notification.getFormat_text() + " " + notification.getText());
        }
        try {
            ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
            if (instructor != null) {
                PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).account_id(instructor.getAccount_id()).format_text(notification.getFormat_text()).title(notification.getTitle()).title_es(notification.getTitle_es()).message(notification.getMessage()).message_es(notification.getMessage_es()).screen_type(notification.getNotification_type()).build();
                pushNotificationDTOS.add(pushNotificationDTO);
            }
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moodUpdate(MoodUpdateNotification moodUpdateNotification) {
        StudentCoreDTO student = this.restComponent.getStudentByStudentId(moodUpdateNotification.getStudent_id());
        Instructor instructor = this.restComponent.getInstructorById(student.getInstructor_id());
        Parent parent = this.restComponent.getParentById(student.getParent_id());
        Notification notification = new Notification();
        notification.setStudent_id(student.getStudent_id());
        notification.setInstructor_id(instructor != null ? instructor.getInstructor_id() : 0L);
        notification.setParent_id(parent != null && parent.getCorporate_id() > 0L ? parent.getCorporate_id() : 0L);
        notification.setNotification_type(NotificationType.MOOD_UPDATE);
        notification.setText(moodUpdateNotification.getText());
        notification.setText_es(moodUpdateNotification.getText_es());
        notification.setFormat_text(student.getFirst_name() + " " + student.getLast_name());
        this.notificationRepository.save((Object)notification);
        if (instructor != null) {
            this.restComponent.setNewNotificationsForInstructor(Long.valueOf(instructor.getInstructor_id()), true);
            this.realTimeMessageService.sendJsonMessage(instructor.getInstructor_id(), notification.getFormat_text() + " " + notification.getText());
        }
        if (parent != null && parent.getCorporate_id() > 0L) {
            ArrayList<Long> parent_ids = new ArrayList<Long>();
            parent_ids.add(parent.getParent_id());
            this.restComponent.setNewNotificationsForParent(parent_ids, true);
            this.realTimeMessageService.sendMessage(parent.getParent_id(), notification.getFormat_text() + " " + notification.getText());
        }
        if (parent != null && parent.getCorporate_id() > 0L) {
            this.restComponent.setNewNotificationsForCorporate(parent.getCorporate_id(), true);
            this.realTimeMessageService.sendMessage(parent.getCorporate_id(), notification.getFormat_text() + " " + notification.getText());
        }
        try {
            Corporate corporate;
            PushNotificationDTO pushNotificationDTO;
            ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
            if (instructor != null) {
                pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).account_id(instructor.getAccount_id()).format_text(notification.getFormat_text()).title(notification.getTitle()).title_es(notification.getTitle_es()).message(notification.getMessage()).message_es(notification.getMessage_es()).screen_type(notification.getNotification_type()).build();
                pushNotificationDTOS.add(pushNotificationDTO);
            }
            if (parent != null && parent.getCorporate_id() > 0L) {
                pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).account_id(parent.getAccount_id()).format_text(notification.getFormat_text()).title(notification.getTitle()).title_es(notification.getTitle_es()).message(notification.getMessage()).message_es(notification.getMessage_es()).screen_type(notification.getNotification_type()).build();
                pushNotificationDTOS.add(pushNotificationDTO);
            }
            if (parent != null && parent.getCorporate_id() > 0L && (corporate = this.restComponent.getCorporateById(parent.getCorporate_id())) != null) {
                PushNotificationDTO pushNotificationDTO2 = PushNotificationDTO.builder().push_notification_id(0L).account_id(corporate.getAccount_id()).format_text(notification.getFormat_text()).title(notification.getTitle()).title_es(notification.getTitle_es()).message(notification.getMessage()).message_es(notification.getMessage_es()).screen_type(notification.getNotification_type()).build();
                pushNotificationDTOS.add(pushNotificationDTO2);
            }
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reviewWOWPost(ReviewWOWPostNotification reviewWOWPostNotification) {
        StudentCoreDTO student = this.restComponent.getStudentByStudentId(reviewWOWPostNotification.getStudent_id());
        Instructor instructor = this.restComponent.getInstructorById(student.getInstructor_id());
        Parent parent = this.restComponent.getParentById(student.getParent_id());
        Notification notification = new Notification();
        notification.setNotification_type(NotificationType.WOW_POST_BY_STUDENT);
        notification.setStudent_id(student.getStudent_id());
        notification.setParent_id(parent != null && parent.getCorporate_id() > 0L ? parent.getParent_id() : 0L);
        notification.setInstructor_id(instructor != null ? instructor.getInstructor_id() : 0L);
        notification.setTitle("Review WoW Post");
        notification.setTitle_es("Revisar publicaci\u00f3n del Muro de las Maravillas.");
        String message = null;
        message = !AppUtils.isNullOrEmpty((String)reviewWOWPostNotification.getText()) ? " posted on WoW: " + reviewWOWPostNotification.getText() : " posted on WoW";
        notification.setText(message);
        String message_es = null;
        message_es = !AppUtils.isNullOrEmpty((String)reviewWOWPostNotification.getText()) ? " public\u00f3 en el Muro de las Maravillas: " + reviewWOWPostNotification.getText() : " public\u00f3 en el Muro de las Maravillas.";
        notification.setText_es(message_es);
        notification.setFormat_text(student.getFirst_name().trim() + " " + student.getLast_name().trim());
        if (!student.isDemo()) {
            this.notificationRepository.save((Object)notification);
        }
        if (instructor != null) {
            this.restComponent.setNewNotificationsForInstructor(Long.valueOf(instructor.getInstructor_id()), true);
            this.realTimeMessageService.sendTitleAndMessage(instructor.getInstructor_id(), notification.getTitle(), notification.getText());
        }
        if (parent != null) {
            this.realTimeMessageService.sendTitleAndMessage(parent.getParent_id(), notification.getTitle(), notification.getText());
        }
        if (parent != null && parent.getCorporate_id() > 0L) {
            ArrayList<Long> parent_ids = new ArrayList<Long>();
            parent_ids.add(student.getParent_id());
            this.restComponent.setNewNotificationsForParent(parent_ids, true);
        }
        try {
            PushNotificationDTO pushNotificationDTO;
            ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
            if (instructor != null) {
                pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).account_id(instructor.getAccount_id()).format_text(notification.getFormat_text()).title(notification.getTitle()).title_es(notification.getTitle_es()).message(notification.getMessage()).message_es(notification.getMessage_es()).screen_type(notification.getNotification_type()).build();
                pushNotificationDTOS.add(pushNotificationDTO);
            }
            if (parent != null && parent.getCorporate_id() > 0L) {
                pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).account_id(parent.getAccount_id()).format_text(notification.getFormat_text()).title(notification.getTitle()).title_es(notification.getTitle_es()).message(notification.getMessage()).message_es(notification.getMessage_es()).screen_type(notification.getNotification_type()).build();
                pushNotificationDTOS.add(pushNotificationDTO);
            }
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void badWordInJournal(BadWordInJournalNotification badWordInJournalNotification) {
        StudentCoreDTO student = this.restComponent.getStudentByStudentId(badWordInJournalNotification.getStudent_id());
        Instructor instructor = this.restComponent.getInstructorById(student.getInstructor_id());
        Parent parent = this.restComponent.getParentById(student.getParent_id());
        Notification notification = new Notification();
        notification.setInstructor_id(student.getInstructor_id());
        notification.setParent_id(student.getParent_id());
        notification.setStudent_id(student.getStudent_id());
        notification.setNotification_type(NotificationType.BAD_WORD_IN_JOURNAL);
        notification.setText("is reported (" + badWordInJournalNotification.getBad_words() + ") today (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").");
        notification.setText_es("se informa (" + badWordInJournalNotification.getBad_words() + ") hoy (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").");
        notification.setFormat_text(student.getFirst_name() + " " + student.getLast_name());
        this.notificationRepository.save((Object)notification);
        String language = badWordInJournalNotification.getLanguage();
        if (instructor != null && !AppUtils.isNullOrEmpty((String)instructor.getLanguage())) {
            language = student.getLanguage();
        }
        String message = null;
        message = Language.isSpanish((String)language) ? this.configurationRepository.getConfiguration().getJournal_bad_words_notification() : this.configurationRepository.getConfiguration().getJournal_bad_words_notification_es();
        if (message != null) {
            message = message.replace("<name_of_student>", notification.getFormat_text());
        }
        if (instructor != null) {
            this.restComponent.setNewNotificationsForInstructor(Long.valueOf(instructor.getInstructor_id()), true);
            this.realTimeMessageService.sendJsonMessage(instructor.getInstructor_id(), message);
        }
        if (parent != null) {
            this.realTimeMessageService.sendJsonMessage(parent.getParent_id(), message);
        }
        if (parent != null && parent.getCorporate_id() > 0L) {
            ArrayList<Long> parent_ids = new ArrayList<Long>();
            parent_ids.add(student.getParent_id());
            this.restComponent.setNewNotificationsForParent(parent_ids, true);
        }
        try {
            PushNotificationDTO pushNotificationDTO;
            ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
            if (instructor != null) {
                pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).account_id(instructor.getAccount_id()).format_text(notification.getFormat_text()).title(notification.getTitle()).title_es(notification.getTitle_es()).message(notification.getMessage()).message_es(notification.getMessage_es()).screen_type(notification.getNotification_type()).build();
                pushNotificationDTOS.add(pushNotificationDTO);
            }
            if (parent != null && parent.getCorporate_id() > 0L) {
                pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).account_id(parent.getAccount_id()).format_text(notification.getFormat_text()).title(notification.getTitle()).title_es(notification.getTitle_es()).message(notification.getMessage()).message_es(notification.getMessage_es()).screen_type(notification.getNotification_type()).build();
                pushNotificationDTOS.add(pushNotificationDTO);
            }
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void corporateNotification(CorporateNotification corporateNotification) {
        ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
        Iterator iterator = corporateNotification.getParent_ids_and_account_ids().keySet().iterator();
        while (iterator.hasNext()) {
            long parent_id = (Long)iterator.next();
            Notification notification = new Notification();
            notification.setText(corporateNotification.getText());
            notification.setText_es(corporateNotification.getText_es());
            notification.setNotification_type(NotificationType.CORPORATE_NOTIFICATION);
            notification.setParent_id(parent_id);
            this.notificationRepository.save((Object)notification);
            this.realTimeMessageService.sendTitleAndMessage(parent_id, notification.getTitle(), notification.getText());
            PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).account_id(((Long)corporateNotification.getParent_ids_and_account_ids().get(parent_id)).longValue()).format_text(notification.getFormat_text()).title(notification.getTitle()).title_es(notification.getTitle_es()).message(notification.getMessage()).message_es(notification.getMessage_es()).screen_type(notification.getNotification_type()).build();
            pushNotificationDTOS.add(pushNotificationDTO);
        }
        this.restComponent.setNewNotificationsForParent(new ArrayList(corporateNotification.getParent_ids_and_account_ids().keySet()), true);
        try {
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

