/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.logging.interceptor;

import com.infinite.focus.server.logging.helper.LoggingHelper;
import com.infinite.focus.server.logging.service.LoggingService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class InterceptLog
implements HandlerInterceptor {
    private final LoggingService loggingService;

    public InterceptLog(LoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (request.getMethod().equals(HttpMethod.GET.name()) || request.getMethod().equals(HttpMethod.DELETE.name()) || request.getMethod().equals(HttpMethod.PUT.name())) {
            this.displayReq(request, null);
        } else if (request.getMethod().equals(HttpMethod.POST.name())) {
            Map parameterMap = request.getParameterMap();
            if (parameterMap != null && !parameterMap.isEmpty()) {
                this.displayReq(request, null);
            } else if (request.getContentLengthLong() <= 0L) {
                this.displayReq(request, null);
            }
        }
        return true;
    }

    public void displayReq(HttpServletRequest request, Object body) {
        String authorization = request.getHeader("Authorization");
        String url = request.getRequestURI();
        String method = request.getMethod();
        Map headers = LoggingHelper.getHeaders((HttpServletRequest)request);
        Map parameters = LoggingHelper.getParameters((HttpServletRequest)request);
        Object requestBody = body;
        this.loggingService.saveRequest(authorization, url, method, headers, parameters, requestBody);
    }
}

