/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.poststandard.repository;

import com.infinite.focus.server.poststandard.dto.PostStandardDTO;
import com.infinite.focus.server.poststandard.repository.PostStandardRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class PostStandardRepositoryImpl
implements PostStandardRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static PostStandardDTO mapRow(ResultSet rs, int i) throws SQLException {
        return PostStandardDTO.builder().post_standard_id(rs.getLong("post_standard_id")).post_id(rs.getLong("post_id")).standard_id(rs.getLong("standard_id")).build();
    }

    public List<PostStandardDTO> create(long post_id, Set<Long> standard_ids) {
        String INSERT_SQL = "INSERT INTO post_standard (post_id, standard_id, created_at, updated_at) VALUES (?,?,?,?)";
        Set insertedIds = (Set)this.jdbcTemplate.execute(connection -> connection.prepareStatement("INSERT INTO post_standard (post_id, standard_id, created_at, updated_at) VALUES (?,?,?,?)", 1), ps -> {
            for (Long standard_id : standard_ids) {
                ps.setLong(1, post_id);
                ps.setLong(2, standard_id);
                ps.setTimestamp(3, Timestamp.valueOf(LocalDateTime.now()));
                ps.setTimestamp(4, Timestamp.valueOf(LocalDateTime.now()));
                ps.addBatch();
            }
            ps.executeBatch();
            ResultSet resultSet = ps.getGeneratedKeys();
            HashSet<Long> ids = new HashSet<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            return ids;
        });
        return this.findByIds(insertedIds);
    }

    public List<PostStandardDTO> findByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<PostStandardDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM post_standard WHERE post_standard_id IN(%s) ORDER BY post_standard_id ASC";
        List postAndStandardDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), PostStandardRepositoryImpl::mapRow);
        return postAndStandardDTOS;
    }

    public void delete(long post_id) {
        String SQL = "DELETE FROM post_standard WHERE post_id = ?";
        this.jdbcTemplate.update("DELETE FROM post_standard WHERE post_id = ?", new Object[]{post_id});
    }

    public List<Long> findPostIdsByStandardIds(Set<Long> standard_ids) {
        if (AppUtils.isNullOrEmpty(standard_ids)) {
            return new ArrayList<Long>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(standard_ids.size(), "?"));
        String SQL = "SELECT DISTINCT(post_id) FROM post_standard WHERE standard_id IN(%s) ORDER BY post_id ASC";
        List post_ids = this.jdbcTemplate.query(String.format(SQL, inSql), standard_ids.toArray(), (rs, i) -> rs.getLong(1));
        return post_ids;
    }

    public List<PostStandardDTO> findPostStandardListByPostIds(Set<Long> post_ids) {
        if (AppUtils.isNullOrEmpty(post_ids)) {
            return new ArrayList<PostStandardDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(post_ids.size(), "?"));
        String SQL = "SELECT * FROM post_standard WHERE post_id IN(%s) ORDER BY post_id ASC";
        List postStandardDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), post_ids.toArray(), PostStandardRepositoryImpl::mapRow);
        return postStandardDTOS;
    }
}

