/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.service.data;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.infinite.focus.server.accesscode.entity.AccessCode;
import com.infinite.focus.server.accesscode.service.AccessCodeService;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.clever.constant.CleverAppConstants;
import com.infinite.focus.server.clever.model.AccessToken;
import com.infinite.focus.server.clever.model.CleverDistrict;
import com.infinite.focus.server.clever.model.CleverDistrictGraph;
import com.infinite.focus.server.clever.model.CleverInstructor;
import com.infinite.focus.server.clever.model.CleverMeInfo;
import com.infinite.focus.server.clever.model.CleverParent;
import com.infinite.focus.server.clever.model.CleverRoleStudent;
import com.infinite.focus.server.clever.model.CleverSchool;
import com.infinite.focus.server.clever.model.CleverSection;
import com.infinite.focus.server.clever.model.CleverStudent;
import com.infinite.focus.server.clever.model.CleverStudentToken;
import com.infinite.focus.server.clever.model.CleverUser;
import com.infinite.focus.server.clever.request.CleverCodeRequest;
import com.infinite.focus.server.clever.request.CleverInstructorAddRequest;
import com.infinite.focus.server.clever.service.CleverService;
import com.infinite.focus.server.clever.service.data.CleverDataService;
import com.infinite.focus.server.clever.service.district.CleverDistrictService;
import com.infinite.focus.server.clever.service.instructor.CleverInstructorService;
import com.infinite.focus.server.clever.service.parent.CleverParentService;
import com.infinite.focus.server.clever.service.school.CleverSchoolService;
import com.infinite.focus.server.clever.service.section.CleverSectionService;
import com.infinite.focus.server.clever.service.student.CleverStudentService;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.email.service.EmailSenderService;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.standard.service.StandardService;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.template.service.TemplateService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.io.IOException;
import java.sql.Date;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Service
@Transactional
public class CleverDataServiceImpl
implements CleverDataService {
    private static final Logger log = LoggerFactory.getLogger(CleverDataServiceImpl.class);
    @Autowired
    CleverService cleverService;
    @Autowired
    MessageService messageService;
    @Autowired
    CleverDistrictService cleverDistrictService;
    @Autowired
    CleverSchoolService cleverSchoolService;
    @Autowired
    CleverInstructorService cleverInstructorService;
    @Autowired
    CleverStudentService cleverStudentService;
    @Autowired
    CleverSectionService cleverSectionService;
    @Autowired
    CleverParentService cleverParentService;
    @Autowired
    AccountService accountService;
    @Autowired
    DistrictService districtService;
    @Autowired
    SchoolService schoolService;
    @Autowired
    InstructorService instructorService;
    @Autowired
    ClassService classService;
    @Autowired
    StudentService studentService;
    @Autowired
    StandardService standardService;
    @Autowired
    ParentService parentService;
    @Autowired
    AccessCodeService accessCodeService;
    @Autowired
    private RealTimeMessageService realTimeMessageService;
    String starting_after = "null";
    @Autowired
    private EmailSenderService emailSenderService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private ConfigurationService configurationService;

    public CleverDistrict getDistrictByCleverId(String clever_id) {
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(clever_id);
        if (accessToken == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("clever.district.is.not.found.for.clever.id") + " " + clever_id);
        }
        return this.cleverDistrictService.getDistrictById(accessToken.getAccess_token(), clever_id);
    }

    public CleverSchool getSchoolByDistrictIdAndSchoolCleverId(long district_id, String school_clever_id) {
        District district = this.districtService.getDistrictById(district_id);
        if (district == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("district.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("district.has.no.clever.access"));
        }
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
        if (accessToken == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("district.has.no.valid.clever.id"));
        }
        return this.cleverSchoolService.getCleverSchoolById(accessToken.getAccess_token(), school_clever_id);
    }

    public CleverInstructor getInstructorBySchoolIdAndInstructorCleverId(long school_id, String instructor_clever_id) {
        School school = this.schoolService.getSchoolById(school_id);
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("school.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("district.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("district.has.no.clever.access"));
        }
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
        if (accessToken == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("district.has.no.valid.clever.id"));
        }
        return this.cleverInstructorService.getCleverInstructorByCleverId(accessToken.getAccess_token(), instructor_clever_id);
    }

    public CleverStudent getStudentByInstructorIdAndStudentCleverId(long instructor_id, String student_clever_id) {
        Instructor instructor = this.instructorService.getInstructorById(instructor_id);
        if (instructor == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("instructor.is.not.found"));
        }
        School school = this.schoolService.getSchoolById(instructor.getSchool_id());
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("school.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("district.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("district.has.no.clever.access"));
        }
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
        if (accessToken == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("district.has.no.valid.clever.id"));
        }
        return this.cleverStudentService.getCleverStudentByCleverId(accessToken.getAccess_token(), student_clever_id);
    }

    public CleverDistrictGraph getDistrictGraphById(String district_clever_id) {
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district_clever_id);
        if (accessToken == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("district.has.no.valid.clever.id"));
        }
        CleverDistrictGraph cleverDistrictGraph = new CleverDistrictGraph();
        cleverDistrictGraph.setCleverDistrict(this.getDistrictByCleverId(district_clever_id));
        cleverDistrictGraph.setCleverSchools(this.cleverSchoolService.getCleverSchools(accessToken.getAccess_token()));
        cleverDistrictGraph.setCleverInstructors(this.cleverInstructorService.getCleverInstructors(accessToken.getAccess_token()));
        cleverDistrictGraph.setCleverStudents(this.cleverStudentService.getCleverStudents(accessToken.getAccess_token()));
        cleverDistrictGraph.setCleverSections(this.cleverSectionService.getCleverSections(accessToken.getAccess_token()));
        cleverDistrictGraph.setCleverParents(this.cleverParentService.getCleverParents(accessToken.getAccess_token()));
        return cleverDistrictGraph;
    }

    public void syncSectionByUserid(long school_id, String CleverId) {
        School school = this.schoolService.getSchoolById(school_id);
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("district.is.not.found"));
        }
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("school.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)school.getClever_id())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("school.has.no.clever.access"));
        }
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
        LinkedHashSet cleverSections = this.cleverSectionService.getCleverSectionsByUser(accessToken.getAccess_token(), CleverId, CleverAppConstants.SECTIONS_LIMIT, null, null);
        for (CleverSection cleverSection : cleverSections) {
            System.out.println("Class id: " + cleverSection.getId() + " name: " + cleverSection.getName());
            ArrayList classes = new ArrayList();
            for (Instructor instructor : this.instructorService.getInstructorsBySchoolId(school.getSchool_id())) {
                classes.addAll(this.classService.getClassesByInstructorId(instructor.getInstructor_id()));
            }
            Instructor instructor = this.instructorService.getInstructorsByCleverId(cleverSection.getTeacher());
            List instructors = this.instructorService.getInstructorsByCleverIds(new ArrayList(cleverSection.getTeachers()));
            AtomicBoolean isNew = new AtomicBoolean(true);
            classes.parallelStream().forEach(class_ -> {
                if (class_.getClever_id().equals(cleverSection.getId()) || class_.getClass_name().equals(cleverSection.getName()) && class_.getInstructor().getClever_id().equals(instructor.getClever_id())) {
                    isNew.set(false);
                    class_.setClass_name(cleverSection.getName());
                    class_.setSubject(cleverSection.getSubject());
                    class_.setInstructor(instructor);
                    class_.getInstructors().addAll(instructors);
                    class_.setClever_id(cleverSection.getId());
                    class_.setLast_sync(new java.util.Date());
                    if (!AppUtils.isNullOrEmpty((Set)cleverSection.getStudents())) {
                        List students = this.studentService.getStudentsByCleverId(new ArrayList(cleverSection.getStudents()));
                        class_.setStudents(new HashSet(students));
                    }
                    System.out.println("Section updated:-" + cleverSection.getId());
                    this.classService.save(class_);
                }
            });
            if (!isNew.get() || AppUtils.isNullOrEmpty((String)cleverSection.getName()) || instructor == null) continue;
            Class class_2 = new Class();
            class_2.setClass_name(cleverSection.getName());
            class_2.setSubject(cleverSection.getSubject());
            class_2.setInstructor(instructor);
            class_2.getInstructors().addAll(instructors);
            class_2.setClever_id(cleverSection.getId());
            class_2.setLast_sync(new java.util.Date());
            if (!AppUtils.isNullOrEmpty((Set)cleverSection.getStudents())) {
                List students = this.studentService.getStudentsByCleverId(new ArrayList(cleverSection.getStudents()));
                class_2.setStudents(new HashSet(students));
            }
            this.classService.save(class_2);
            System.out.println("New Section Added successfully !!! ");
        }
        System.out.println("Section updated successfully !!! ");
    }

    @Async
    public void syncDistrict(long district_id) {
        this.syncDistrictNonAsync(district_id);
    }

    public void syncDistrictNonAsync(long district_id) {
        log.info("Starting Thread District {} - Processing District {}", (Object)district_id);
        District district = this.districtService.getDistrictById(district_id);
        System.out.println("district id is:-" + district_id);
        if (district == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("district.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("district.has.no.clever.access"));
        }
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
        log.info("Access token is {}", (Object)accessToken.getAccess_token());
        CleverDistrict cleverDistrict = this.cleverDistrictService.getDistrictById(accessToken.getAccess_token(), district.getClever_id());
        district.setDistrict_name(cleverDistrict.getName());
        district.setSync_progressed(false);
        this.districtService.save(district);
        log.info("Exiting Thread - Processing District {} completed", (Object)district.getDistrict_id());
        String message = this.messageService.getMessage("sync.completed.for.the.district");
        String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + message + "\"}";
        this.realTimeMessageService.sendMessage(district.getDistrict_id(), json_message);
        System.out.println(district_id + " " + district.getDistrict_name() + " " + message);
    }

    public void SyncInstructorByCleverId(long school_id, String CleverId) {
        School school = this.schoolService.getSchoolById(school_id);
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("school.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("district.is.not.found"));
        }
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
        CleverInstructor cleverInstructor = this.cleverInstructorService.getCleverInstructorByCleverId(accessToken.getAccess_token(), CleverId);
        System.out.println("    Instructor id: " + cleverInstructor.getId() + " name: " + cleverInstructor.getName().toString());
        List instructors = this.instructorService.getInstructorsBySchoolId(school.getSchool_id());
        for (Instructor instructor : instructors) {
            if ((!AppUtils.isValidateEmail((String)cleverInstructor.getEmail()) || !instructor.getClever_id().equals(cleverInstructor.getId())) && !instructor.getAccount().getUsername().equals(cleverInstructor.getEmail())) continue;
            System.out.println("Last sync time before:-" + instructor.getLast_sync());
            long hours = DateUtils.countHoursBetweenFromDateAndToDate((java.util.Date)instructor.getLast_sync(), (java.util.Date)new java.util.Date());
            System.out.println("Hours:- " + hours);
            if (hours < 24L) {
                System.out.println("sync will not be done at this moment");
                continue;
            }
            if (cleverInstructor.getName() != null) {
                instructor.setFirst_name(cleverInstructor.getName().getFirst());
                instructor.setLast_name(cleverInstructor.getName().getLast());
            }
            instructor.setClever_id(cleverInstructor.getId());
            instructor.setLast_sync(new java.util.Date());
            this.instructorService.save(instructor);
            System.out.println("Last sync time after:-" + instructor.getLast_sync());
            System.out.println("instructor sync completed...");
        }
    }

    public CleverUser GetUserInfoFromCleverCode(CleverCodeRequest request) throws IOException {
        CleverStudentToken cleverStudentToken = this.cleverService.getStudentTokenByCleverCode(request);
        if (cleverStudentToken == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("user.token.not.found.please.send.correct.code.and.redirect.url"));
        }
        CleverMeInfo cleverMeInfo = this.cleverStudentService.getCleverMeInfo(cleverStudentToken.getAccess_token());
        if (cleverMeInfo == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("clever.me.info.not.found"));
        }
        CleverUser cleverUser = this.cleverStudentService.getCleverStudentByIdForCleverCode(cleverStudentToken.getAccess_token(), cleverMeInfo.getData().getId());
        cleverUser.setToken(cleverStudentToken.getAccess_token());
        System.out.println("Clever student is :-" + cleverUser);
        return cleverUser;
    }

    @Transactional
    public Instructor syncInstructor(Instructor instructor) {
        School school = this.schoolService.getSchoolById(instructor.getSchool_id());
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
        CleverInstructor cleverInstructor = this.cleverInstructorService.getCleverInstructorByCleverId(accessToken.getAccess_token(), instructor.getClever_id());
        if (cleverInstructor == null) {
            instructor.setArchived(true);
            return this.instructorService.save(instructor);
        }
        instructor.setArchived(false);
        this.instructorService.save(instructor);
        long hours = DateUtils.countHoursBetweenFromDateAndToDate((java.util.Date)instructor.getLast_sync(), (java.util.Date)new java.util.Date());
        System.out.println("Hours:- " + hours);
        if (hours < 24L) {
            System.out.println("sync will not be done at this moment");
        } else {
            School school1;
            String school_clever_id;
            if (cleverInstructor.getName() != null) {
                instructor.setFirst_name(cleverInstructor.getName().getFirst());
                instructor.setLast_name(cleverInstructor.getName().getLast());
            }
            instructor.setClever_id(cleverInstructor.getId());
            instructor.setLast_sync(new java.util.Date());
            System.out.println("Updated instructor:-" + instructor.getClever_id());
            if (cleverInstructor.getRoles() != null && cleverInstructor.getRoles().getTeacher() != null && !AppUtils.isNullOrEmpty((String)cleverInstructor.getRoles().getTeacher().getSchool())) {
                school_clever_id = cleverInstructor.getRoles().getTeacher().getSchool();
                School school12 = this.schoolService.getSchoolByCleverId(school_clever_id);
                if (school12 != null) {
                    instructor.setSchool_id(school12.getSchool_id());
                }
            } else if (cleverInstructor.getRoles() != null && cleverInstructor.getRoles().getStaff() != null && !AppUtils.isNullOrEmpty((List)cleverInstructor.getRoles().getStaff().getSchools()) && (school1 = this.schoolService.getSchoolByCleverId(school_clever_id = (String)cleverInstructor.getRoles().getStaff().getSchools().get(0))) != null) {
                instructor.setSchool_id(school1.getSchool_id());
            }
            instructor = this.instructorService.save(instructor);
            if (cleverInstructor.getRoles() != null && cleverInstructor.getRoles().getTeacher() != null) {
                LinkedHashSet cleverSections = this.cleverInstructorService.getCleverSectionsByCleverInstructor(accessToken.getAccess_token(), instructor.getClever_id());
                new Thread(() -> this.syncCleverSections(cleverSections, school)).start();
            }
        }
        return instructor;
    }

    private void syncCleverSections(LinkedHashSet<CleverSection> cleverSections, School school) {
        if (school.isSync_progressed()) {
            return;
        }
        for (CleverSection cleverSection : cleverSections) {
            this.saveOrUpdateCleverSection(cleverSection, school);
        }
    }

    private void saveOrUpdateCleverSection(CleverSection cleverSection, School school) {
        try {
            Class class_ = this.classService.getClassByCleverId(cleverSection.getId());
            if (class_ == null) {
                class_ = new Class();
            }
            class_.setClass_name(cleverSection.getName());
            Instructor instructor_ = this.instructorService.getInstructorsByCleverId(cleverSection.getTeacher());
            List instructors = this.instructorService.getInstructorsByCleverIds(new ArrayList(cleverSection.getTeachers()));
            class_.setInstructor(instructor_);
            class_.setInstructors(new HashSet(instructors));
            if (!AppUtils.isNullOrEmpty((Set)cleverSection.getStudents())) {
                List students = this.studentService.getStudentsByCleverId(new ArrayList(cleverSection.getStudents()));
                class_.setStudents(new HashSet(students));
            }
            if (!AppUtils.isNullOrEmpty((String)cleverSection.getSchool())) {
                school = this.schoolService.getSchoolByCleverId(cleverSection.getSchool());
            }
            class_.setSchool(school);
            class_.setSubject(cleverSection.getSubject());
            class_.setClever_id(cleverSection.getId());
            class_.setLast_sync(new java.util.Date());
            class_.setCreatedAt(new java.util.Date());
            this.classService.save(class_);
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    @Transactional
    public Student syncStudent(Student student) {
        District district = this.districtService.getDistrictById(student.getSchool().getDistrict_id());
        if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
            return student;
        }
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
        CleverStudent cleverStudent = this.cleverStudentService.getCleverStudentByCleverId(accessToken.getAccess_token(), student.getClever_id());
        if (cleverStudent == null) {
            student.setArchived(true);
            return this.studentService.save(student);
        }
        student.setArchived(false);
        this.studentService.save(student);
        long hours = DateUtils.countHoursBetweenFromDateAndToDate((java.util.Date)student.getLast_sync(), (java.util.Date)new java.util.Date());
        System.out.println("Hours:- " + hours);
        if (hours < 24L) {
            System.out.println("sync will not be done at this moment");
        } else {
            if (cleverStudent.getName() != null) {
                student.setFirst_name(cleverStudent.getName().getFirst());
                student.setLast_name(cleverStudent.getName().getLast());
            }
            if (cleverStudent.getRoles() != null && cleverStudent.getRoles().getStudent() != null) {
                Standard standard;
                CleverRoleStudent cleverRoleStudent = cleverStudent.getRoles().getStudent();
                String gender = null;
                if (cleverRoleStudent.getGender().equals("M")) {
                    gender = "Male";
                } else if (cleverRoleStudent.getGender().equals("F")) {
                    gender = "Female";
                }
                student.setGender(gender);
                String ethnicity = cleverRoleStudent.getRace();
                if (cleverRoleStudent.getHispanic_ethnicity().equals("Y")) {
                    ethnicity = "Hispanic, Latino, or Spanish origin";
                } else if ("Caucasian".equals(ethnicity)) {
                    ethnicity = "White European";
                } else if ("American Indian".equals(ethnicity)) {
                    ethnicity = "Native Americans/Alaska Natives";
                }
                student.setEthnicity(ethnicity);
                try {
                    LocalDate date = OffsetDateTime.parse(cleverRoleStudent.getDob()).toLocalDate();
                    student.setDate_of_birth(Date.valueOf(date));
                }
                catch (Exception e) {
                    System.out.println(e.getLocalizedMessage());
                }
                String schoolCleverId = cleverRoleStudent.getSchool();
                if (!AppUtils.isNullOrEmpty((String)schoolCleverId)) {
                    School school = this.schoolService.getSchoolByCleverId(schoolCleverId);
                    if (school != null && student.getSchool() != null && school.getSchool_id() != student.getSchool().getSchool_id()) {
                        student.setInstructor(null);
                    }
                    student.setSchool(school);
                } else {
                    student.setSchool(null);
                }
                student.setSchool(this.schoolService.getSchoolByCleverId(schoolCleverId));
                String cleverGrade = cleverRoleStudent.getGrade();
                if (this.getCleverGradeRelatedToK().contains(cleverGrade)) {
                    cleverGrade = "K";
                }
                if ((standard = this.standardService.getStandardByStandardName(cleverGrade)) != null) {
                    student.setStandard(standard);
                    student.setArchived(false);
                } else {
                    student.setStandard(null);
                    student.setArchived(true);
                }
            }
            student.setClever_id(cleverStudent.getId());
            student.setLast_sync(new java.util.Date());
            System.out.println("saving student");
            this.studentService.save(student);
            AccessCode accessCode = this.accessCodeService.getAccessCodeByStudentId(student.getStudent_id());
            if (accessCode == null) {
                accessCode = new AccessCode(student, student.getInstructor(), student.getParent());
            }
            accessCode.setInstructor(student.getInstructor());
            accessCode.setParent(student.getParent());
            accessCode.setStatus(Status.ACCEPTED);
            this.accessCodeService.save(accessCode);
            this.syncStudentContact(accessToken, student);
            LinkedHashSet cleverSections = this.cleverStudentService.getCleverSectionsByCleverStudent(accessToken.getAccess_token(), student.getClever_id());
            new Thread(() -> this.syncCleverSections(cleverSections, student.getSchool())).start();
            log.info("Student Updated {}", (Object)cleverStudent.getId());
        }
        return student;
    }

    public List<String> getCleverGradeRelatedToK() {
        ArrayList<String> grades = new ArrayList<String>();
        grades.add("PreKindergarten");
        grades.add("TransitionalKindergarten");
        grades.add("Kindergarten");
        grades.add("InfantToddler");
        grades.add("Preschool");
        return grades;
    }

    private void syncStudentContact(AccessToken accessToken, Student student) {
        LinkedHashSet cleverParents = this.cleverStudentService.getCleverParentsByCleverStudent(accessToken.getAccess_token(), student.getClever_id());
        CleverParent cleverParent = cleverParents.stream().peek(contact -> {
            if (contact.getRoles() != null && contact.getRoles().getContact() != null && !AppUtils.isNullOrEmpty((Set)contact.getRoles().getContact().getStudent_relationships())) {
                Set studentRelationships = contact.getRoles().getContact().getStudent_relationships().stream().filter(cleverStudentRelationship -> cleverStudentRelationship.getType().contains("Parent")).collect(Collectors.toSet());
                contact.getRoles().getContact().setStudent_relationships(studentRelationships);
            }
        }).filter(contact -> contact.getRoles() != null && contact.getRoles().getContact() != null && !AppUtils.isNullOrEmpty((Set)contact.getRoles().getContact().getStudent_relationships()) && !AppUtils.isNullOrEmpty((Set)contact.getRoles().getContact().getStudent_relationships())).findFirst().orElse(null);
        if (cleverParent != null && !AppUtils.isNullOrEmpty((String)cleverParent.getEmail())) {
            List<String> name;
            Account account;
            String AmericanShortCode = "US";
            PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
            String password = AppUtils.generatePassword();
            boolean isNew = false;
            Parent parent = this.parentService.findByCleverId(cleverParent.getId());
            if (parent == null && (account = this.accountService.findByEmail(cleverParent.getEmail())) != null) {
                parent = this.parentService.getParentByAccountId(account.getAccount_id());
            }
            if (parent == null) {
                parent = new Parent();
                account = this.accountService.findByEmail(cleverParent.getEmail());
                if (account == null) {
                    account = this.accountService.createAccountByEmailAndPassword(cleverParent.getEmail(), password);
                    isNew = true;
                }
                parent.setAccount(account);
            }
            if (parent.getAccount() == null) {
                account = this.accountService.findByEmail(cleverParent.getEmail());
                if (account == null) {
                    account = this.accountService.createAccountByEmailAndPassword(cleverParent.getEmail(), password);
                    isNew = true;
                }
                parent.setAccount(account);
            }
            parent.setClever_id(cleverParent.getId());
            District district = this.districtService.getDistrictById(parent.getDistrict_id());
            if (isNew && district == null) {
                District districtByCleverId = this.districtService.getDistrictByCleverId(cleverParent.getDistrict());
                parent.setDistrict_id(districtByCleverId.getDistrict_id());
            }
            School school = this.schoolService.getSchoolById(parent.getSchool_id());
            if (student.getSchool() != null && school == null) {
                parent.setSchool_id(student.getSchool().getSchool_id());
            }
            parent.setLast_sync(new java.util.Date());
            if (cleverParent.getName() != null && !AppUtils.isNullOrEmpty(name = Arrays.asList(cleverParent.getName().getLast().split("\\s+")))) {
                parent.setFirst_name((String)AppUtils.getFirstElement(name));
                parent.setLast_name((String)AppUtils.getLastElement(name));
            }
            if (cleverParent.getRoles() != null && cleverParent.getRoles().getContact() != null && cleverParent.getRoles().getContact().getPhone() != null) {
                Phonenumber.PhoneNumber phoneNumberProto = null;
                try {
                    phoneNumberProto = phoneUtil.parse((CharSequence)cleverParent.getRoles().getContact().getPhone(), AmericanShortCode);
                    if (phoneNumberProto.hasCountryCode()) {
                        int countryCode = phoneNumberProto.getCountryCode();
                        parent.setCountry_code("+1");
                    } else {
                        parent.setCountry_code(null);
                    }
                    if (phoneNumberProto.hasNationalNumber()) {
                        System.out.println("phone number is:-" + phoneNumberProto.getNationalNumber());
                        parent.setPhone(String.valueOf(phoneNumberProto.getNationalNumber()));
                        parent.setPhone_type(cleverParent.getRoles().getContact().getPhone_type());
                    } else {
                        parent.setPhone(null);
                        parent.setPhone_type(null);
                    }
                }
                catch (NumberParseException e) {
                    System.out.println(e.getMessage());
                }
            }
            parent.setRegistration_code(this.parentService.generateRegistrationCodeForParent());
            try {
                Parent p = this.parentService.save(parent);
                try {
                    student.setParent(p);
                    this.studentService.save(student);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (isNew) {
                    new Thread(() -> {
                        try {
                            this.emailSenderService.sendHtmlMail(p.getAccount().getUsername(), Language.isSpanish((String)Language.getLanguage()) ? "Bienvenido a Clymb" : "Welcome to Clymb", this.templateService.getSendEmailToParentForDashboardAccessWithoutCorporate(this.configurationService.getConfiguration().getBaseUrlCorporate(), p.getAccount().getUsername(), password, Language.getLanguage()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Instructor syncInstructorFromRedirectUrl(CleverUser cleverUser) {
        String clever_id = cleverUser.getId();
        Instructor instructor = this.instructorService.getInstructorsByCleverId(clever_id);
        if (instructor == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.create.account.at.the.moment.please.try.after.some.time"));
        }
        return this.syncInstructor(instructor);
    }

    public Student syncStudentFromRedirectUrl(CleverUser cleverUser) {
        String clever_id = cleverUser.getId();
        Student student = this.studentService.getStudentByCleverId(clever_id);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.create.account.at.the.moment.please.try.after.some.time"));
        }
        return this.syncStudent(student);
    }

    public Student addInstructorForStudent(CleverInstructorAddRequest cleverInstructorAddRequest) {
        Instructor instructor = this.instructorService.getInstructorById(cleverInstructorAddRequest.getInstructor_id());
        if (instructor == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("instructor.not.found.please.contact.your.school.admin.to.sync.instructor.for.school"));
        }
        Student student = this.studentService.getStudentById(cleverInstructorAddRequest.getStudent_id());
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.not.found"));
        }
        if (student.getSchool_id() != instructor.getSchool_id()) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("instructor.s.school.and.student.s.school.must.be.same"));
        }
        student.setInstructor(instructor);
        this.studentService.save(student);
        return student;
    }

    public void isCleverIdAlreadyInUse(String clever_id) {
        District district = this.districtService.getDistrictByCleverId(clever_id);
        if (district != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("this.clever.id.is.already.in.use.please.try.with.a.unique.clever.id"));
        }
        School school = this.schoolService.getSchoolByCleverId(clever_id);
        if (school != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("this.clever.id.is.already.in.use.please.try.with.a.unique.clever.id"));
        }
        Instructor instructor = this.instructorService.getInstructorsByCleverId(clever_id);
        if (instructor != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("this.clever.id.is.already.in.use.please.try.with.a.unique.clever.id"));
        }
        Student student = this.studentService.getStudentByCleverId(clever_id);
        if (student != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("this.clever.id.is.already.in.use.please.try.with.a.unique.clever.id"));
        }
        Parent parent = this.parentService.getParentByCleverId(clever_id);
        if (parent != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("this.clever.id.is.already.in.use.please.try.with.a.unique.clever.id"));
        }
        Class class_ = this.classService.getClassByCleverId(clever_id);
        if (class_ != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("this.clever.id.is.already.in.use.please.try.with.a.unique.clever.id"));
        }
    }
}

