/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.student.controller;

import com.infinite.focus.server.accesscode.entity.AccessCode;
import com.infinite.focus.server.accesscode.repository.AccessCodeRepository;
import com.infinite.focus.server.accesscode.service.AccessCodeService;
import com.infinite.focus.server.accesscode.view.AccessCodeView;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.avatar.entity.Avatar;
import com.infinite.focus.server.avatar.service.AvatarService;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.service.ClassAndStudentService;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.standard.service.StandardService;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.request.AssignToGroupRequest;
import com.infinite.focus.server.student.request.AssignToGroupsRequest;
import com.infinite.focus.server.student.request.ChangeGradeRequest;
import com.infinite.focus.server.student.request.DeleteRequest;
import com.infinite.focus.server.student.request.GetByAccountIdRequest;
import com.infinite.focus.server.student.request.GetByStudentIdRequest;
import com.infinite.focus.server.student.request.GetByStudentIdsRequest;
import com.infinite.focus.server.student.request.GetClassesByInstructorAndStudentRequest;
import com.infinite.focus.server.student.request.GetClassesByInstructorRequest;
import com.infinite.focus.server.student.request.GetNotificationsRequest;
import com.infinite.focus.server.student.request.GetStudentByInstructorIdAndStudentNameRequest;
import com.infinite.focus.server.student.request.GetStudentByInstructorRequest;
import com.infinite.focus.server.student.request.GetStudentIdsByDemographicsRequest;
import com.infinite.focus.server.student.request.GetStudentProfileRequest;
import com.infinite.focus.server.student.request.GetStudentRequest;
import com.infinite.focus.server.student.request.GetStudentsByClassRequest;
import com.infinite.focus.server.student.request.GetStudentsByIdsRequest;
import com.infinite.focus.server.student.request.GetStudentsBySchoolIdRequest;
import com.infinite.focus.server.student.request.SearchStudentRequest;
import com.infinite.focus.server.student.request.SetNewNotificationsRequest;
import com.infinite.focus.server.student.request.ShouldShareWithInstructorAndParentsRequest;
import com.infinite.focus.server.student.request.StudentChangePasswordRequest;
import com.infinite.focus.server.student.response.GetStudentCountResponse;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.student.wrapper.StudentClassWrapper;
import com.infinite.focus.server.student.wrapper.StudentIdAndStandardIdWrapper;
import com.infinite.focus.server.studentpushnotification.entity.StudentPushNotification;
import com.infinite.focus.server.studentpushnotification.repository.StudentPushNotificationRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.wallpost.service.WallPostService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/student"})
public class StudentController {
    private final AuthService authService;
    private final AccessCodeService accessCodeService;
    private final AvatarService avatarService;
    private final InstructorService instructorService;
    private final ParentService parentService;
    private final StudentService studentService;
    private final ClassService classService;
    private final StandardService standardService;
    private final ClassAndStudentService classAndStudentService;
    private final WallPostService wallPostService;
    private final SchoolRepository schoolRepository;
    private final StudentRepository studentRepository;
    private final ClassRepository classRepository;
    private final AccessCodeRepository accessCodeRepository;
    private final StudentPushNotificationRepository studentPushNotificationRepository;
    private final AccountService accountService;
    private final MessageService messageService;

    public StudentController(AuthService authService, AccessCodeService accessCodeService, AvatarService avatarService, InstructorService instructorService, ParentService parentService, StudentService studentService, ClassService classService, StandardService standardService, ClassAndStudentService classAndStudentService, WallPostService wallPostService, SchoolRepository schoolRepository, ClassRepository classRepository, StudentRepository studentRepository, AccessCodeRepository accessCodeRepository, StudentPushNotificationRepository studentPushNotificationRepository, AccountService accountService, MessageService messageService) {
        this.authService = authService;
        this.accessCodeService = accessCodeService;
        this.avatarService = avatarService;
        this.instructorService = instructorService;
        this.parentService = parentService;
        this.studentService = studentService;
        this.classService = classService;
        this.standardService = standardService;
        this.classAndStudentService = classAndStudentService;
        this.wallPostService = wallPostService;
        this.schoolRepository = schoolRepository;
        this.classRepository = classRepository;
        this.studentRepository = studentRepository;
        this.accessCodeRepository = accessCodeRepository;
        this.studentPushNotificationRepository = studentPushNotificationRepository;
        this.accountService = accountService;
        this.messageService = messageService;
    }

    @GetMapping(value={"/get/count"})
    public ResponseEntity<Long> getCount() {
        return new ResponseEntity((Object)this.studentRepository.count(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-student-by-id"})
    public ResponseEntity<Student> getStudentById(@RequestBody GetStudentRequest request) {
        Student s = this.studentService.getStudentById(request.getStudent_id().longValue());
        return new ResponseEntity((Object)s, HttpStatus.OK);
    }

    @PostMapping(value={"/set-new-notifications"})
    public ResponseEntity<Void> setNewNotifications(@RequestBody SetNewNotificationsRequest request) {
        this.studentService.setNewNotifications(request.getStudent_ids(), request.isNew_notifications());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/get/student"})
    public ResponseEntity<Student> getStudent(@RequestHeader(value="Authorization") String token, @RequestBody GetStudentRequest request) {
        this.authService.isAuthenticated(token);
        Student s = this.studentService.getStudentById(request.getStudent_id().longValue());
        s.setIsVerified(true);
        return new ResponseEntity((Object)s, HttpStatus.OK);
    }

    @PostMapping(value={"/get/profile"})
    public ResponseEntity<Student> getStudentProfile(@RequestBody GetStudentProfileRequest request) {
        Student s = this.studentRepository.findByStudentId(request.getStudent_id());
        if (s == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.is.not.found"));
        }
        return new ResponseEntity((Object)s, HttpStatus.OK);
    }

    @GetMapping(value={"/get/class"})
    public ResponseEntity<Class> getClass(@RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        Class c = (Class)this.classRepository.getOne((Object)class_id);
        if (c == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)c, HttpStatus.OK);
    }

    @PostMapping(value={"/get/students/by/class"})
    public ResponseEntity<List<StudentView>> getStudentsByClass(@RequestBody GetStudentsByClassRequest request) {
        return new ResponseEntity((Object)this.classService.findStudentsByClassId(request.getClass_id().longValue()), HttpStatus.OK);
    }

    @PostMapping(value={"/search/students/by/instructor/and/demographic"})
    public ResponseEntity<Page<Object>> searchStudentByInstructorAndDemographic(@RequestHeader(value="Authorization") String token, @RequestBody SearchStudentRequest searchStudentRequest) {
        Instructor i = this.authService.isInstructor(token);
        if (i == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.instructor.is.not.found"));
        }
        return new ResponseEntity((Object)this.studentService.searchStudentByInstructorAndDemographic(i, searchStudentRequest), HttpStatus.OK);
    }

    @PostMapping(value={"/get/students/by/instructor"})
    public ResponseEntity<List<StudentClassWrapper>> getStudentByInstructor(@RequestBody GetStudentByInstructorRequest request) {
        ArrayList<StudentClassWrapper> list = new ArrayList<StudentClassWrapper>();
        for (StudentView studentView : this.studentRepository.findByInstructorId(request.getInstructor_id())) {
            AccessCodeView accessCodeView = this.accessCodeRepository.findAccessCodeViewByStudentId(studentView.getStudent_id());
            if (accessCodeView == null || accessCodeView.getStatus() == null || accessCodeView.getStatus() == Status.PENDING) continue;
            StudentClassWrapper w = new StudentClassWrapper();
            Student student = this.studentRepository.findByStudentId(studentView.getStudent_id());
            w.setStudent(student);
            w.setParent(student.getParent());
            list.add(w);
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @PostMapping(value={"/get-student-ids-by-student-demographics"})
    public ResponseEntity<List<Long>> getStudentIdsByDemographics(@RequestBody GetStudentIdsByDemographicsRequest request) {
        return new ResponseEntity((Object)this.studentService.getStudentIdsByDemographics(request.getSchool_id(), request.getName(), request.getGenders(), request.getAges(), request.getEthnicity(), request.getGradeIds(), request.getClassIds()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-students-by-ids"})
    public ResponseEntity<List<StudentCoreDTO>> getStudentsByIds(@RequestBody GetStudentsByIdsRequest request) {
        return new ResponseEntity((Object)this.studentService.getStudentsByIds(request.getIds()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-students-by-instructor-id"})
    public ResponseEntity<List<Student>> getStudentByInstructorId(@RequestBody GetStudentByInstructorRequest request) {
        return new ResponseEntity((Object)this.studentService.getStudentsByInstructorId(request.getInstructor_id().longValue()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-student-ids-by-instructor-id"})
    public ResponseEntity<List<Long>> getStudentIdsByInstructorId(@RequestBody GetStudentByInstructorRequest request) {
        return new ResponseEntity((Object)this.studentService.getStudentIdsByInstructorId(request.getInstructor_id().longValue()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-student-ids-by-school-id"})
    public ResponseEntity<List<Long>> getStudentIdsBySchoolId(@RequestBody GetStudentsBySchoolIdRequest request) {
        return new ResponseEntity((Object)this.studentService.getStudentIdsBySchoolId(request.getSchool_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-students-by-instructor-id-and-student-name"})
    public ResponseEntity<List<StudentDTO>> getStudentByInstructorIdAndStudentName(@RequestBody GetStudentByInstructorIdAndStudentNameRequest request) {
        return new ResponseEntity((Object)this.studentService.getStudentsByInstructorIdAndStudentName(request.getInstructor_id(), request.getStudent_name()), HttpStatus.OK);
    }

    @PostMapping(value={"/get/classes/by/instructor"})
    public ResponseEntity<List<Class>> getClassesByInstructor(@RequestBody GetClassesByInstructorRequest request) {
        return new ResponseEntity((Object)this.classService.getClassesByInstructorId(request.getInstructor_id().longValue()), HttpStatus.OK);
    }

    @PostMapping(value={"/get/classes/by/instructor/and/student"})
    public ResponseEntity<Set<Class>> getClassesByInstructorAndStudent(@RequestBody GetClassesByInstructorAndStudentRequest request) {
        HashSet classes = new HashSet(this.classService.getClassesByInstructorId(request.getInstructor_id().longValue()));
        Student student = this.studentRepository.findByStudentId(request.getStudent_id());
        classes.addAll(student.getClasses());
        return new ResponseEntity(classes, HttpStatus.OK);
    }

    @PostMapping(value={"/create/class"})
    @ResponseBody
    public ResponseEntity<Class> createClass(@RequestBody Class request) {
        Class exist_class = this.classRepository.findByClassNameAndInstructorId(request.getClass_name(), Long.valueOf(request.getInstructor_id()));
        if (exist_class != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.group.is.already.exist"));
        }
        Instructor instructor = this.instructorService.getInstructorById(request.getInstructor_id());
        request.setInstructor(instructor);
        request.getInstructors().add(instructor);
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()));
        request.setSchool(school);
        return new ResponseEntity(this.classRepository.save((Object)request), HttpStatus.OK);
    }

    @PostMapping(value={"/update/class"})
    @ResponseBody
    public ResponseEntity<Class> updateClass(@RequestBody Class request) {
        Class exist_class = this.classRepository.findByClassNameAndInstructorId(request.getClass_name(), Long.valueOf(request.getInstructor_id()));
        if (exist_class != null && exist_class.getClass_id() != request.getClass_id()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.group.is.already.exist"));
        }
        Class c = this.classRepository.findByClassId(request.getClass_id());
        if (c == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        c.setClass_name(request.getClass_name());
        Instructor instructor = this.instructorService.getInstructorById(request.getInstructor_id());
        c.setInstructor(instructor);
        c.getInstructors().add(instructor);
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()));
        c.setSchool(school);
        c.setCreatedAt(c.getCreatedAt());
        return new ResponseEntity(this.classRepository.save((Object)c), HttpStatus.OK);
    }

    @GetMapping(value={"/delete/class"})
    public ResponseEntity<Class> deleteClass(@RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        Class c = this.classRepository.findByClassId(class_id.longValue());
        if (c == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.classRepository.delete((Object)c);
        return new ResponseEntity((Object)c, HttpStatus.OK);
    }

    @GetMapping(value={"/add/student/to/class"})
    public ResponseEntity<Student> addStudentToClass(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id, @RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        Student s = this.studentRepository.findByStudentId(student_id);
        if (s == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Class c = this.classRepository.findByClassId(class_id.longValue());
        if (c == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        s.getClasses().add(c);
        return new ResponseEntity(this.studentRepository.save((Object)s), HttpStatus.OK);
    }

    @PostMapping(value={"/verify-access-code"})
    public ResponseEntity<Student> verifyAccessCodeStudent(@RequestParam(value="student_id") long student_id, @RequestParam(value="access_code") String access_code) {
        AccessCode accessCode = this.accessCodeRepository.findByAccessCode(access_code);
        if (accessCode != null) {
            if (accessCode.getStudent().getStudent_id() == student_id) {
                if (accessCode.getStatus() == Status.ACCEPTED) {
                    Student student = accessCode.getStudent();
                    student.setIsVerified(true);
                    this.studentRepository.save((Object)student);
                    return new ResponseEntity((Object)student, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.UNAUTHORIZED);
            }
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/set/fcm/token"})
    public ResponseEntity<Message> setFCMToken(@RequestHeader(value="Authorization") String token, @RequestParam(value="fcm_token") String fcm_token) {
        Student student = this.authService.getStudentByToken(token);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.user.is.not.a.student"));
        }
        student.setFcm_token(fcm_token);
        this.studentRepository.save((Object)student);
        Message message = new Message(this.messageService.getMessage("the.fcm.token.is.set"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/get/notifications"})
    public ResponseEntity<Page<StudentPushNotification>> getNotificationsByStudentId(@RequestHeader(value="Authorization") String token, @RequestBody GetNotificationsRequest request) {
        Student student = this.authService.isStudent(token);
        AccessCode accessCode = this.accessCodeRepository.findByStudentId(Long.valueOf(student.getStudent_id()));
        PageRequest paging = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)Sort.by((String[])new String[]{request.getSortBy()}).descending());
        Page pagedResult = null;
        pagedResult = request.getViewed() == null ? this.studentPushNotificationRepository.findByGreaterThanEqualToStudentApproveDateAndStudentId(DateUtils.getDateInString((Date)accessCode.getCreatedDate()), Long.valueOf(student.getStudent_id()), (Pageable)paging) : (request.getViewed() == false ? this.studentPushNotificationRepository.findByGreaterThanEqualToStudentApproveDateAndStudentIdAndViewed(DateUtils.getDateInString((Date)accessCode.getCreatedDate()), Long.valueOf(student.getStudent_id()), Boolean.valueOf(false), (Pageable)paging) : this.studentPushNotificationRepository.findByGreaterThanEqualToStudentApproveDateAndStudentIdAndViewed(DateUtils.getDateInString((Date)accessCode.getCreatedDate()), Long.valueOf(student.getStudent_id()), Boolean.valueOf(true), (Pageable)paging));
        for (StudentPushNotification studentPushNotification : pagedResult) {
            studentPushNotification.setViewed(true);
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
        }
        long countOfUnread = this.studentPushNotificationRepository.getCountOfGreaterThanEqualToStudentApproveDateAndStudentIdAndViewed(DateUtils.getDateInString((Date)accessCode.getCreatedDate()), Long.valueOf(student.getStudent_id()), Boolean.valueOf(false));
        if (countOfUnread == 0L) {
            student.setNew_notificaitons(false);
            this.studentRepository.save((Object)student);
        }
        return new ResponseEntity((Object)pagedResult, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/students"})
    public ResponseEntity<Page<Student>> getStudents(@RequestHeader(value="Authorization") String token, @RequestParam(value="name", defaultValue="") String name, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="student_id") String sortBy) {
        this.authService.isAuthenticated(token);
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)Sort.by((String[])new String[]{sortBy}).ascending());
        Page pagedResult = null;
        pagedResult = name == null || name.isEmpty() ? this.studentRepository.findAllStudents((Pageable)paging) : this.studentRepository.findByStudentByName(name, (Pageable)paging);
        return new ResponseEntity((Object)pagedResult, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @GetMapping(value={"/logout"})
    public ResponseEntity<Message> logout(@RequestHeader(value="Authorization") String token) {
        Student student = this.authService.getStudentByToken(token);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.user.is.not.a.student"));
        }
        student.setFcm_token(null);
        this.studentRepository.save((Object)student);
        Message message = new Message(this.messageService.getMessage("the.user.is.logout.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/edit/profile"})
    public ResponseEntity<Student> editProfile(@RequestHeader(value="Authorization") String token, @RequestBody Student student) {
        this.authService.isAuthenticated(token);
        Student s = this.studentRepository.findByStudentId(Long.valueOf(student.getStudent_id()));
        if (s == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)student.getFirst_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.first.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)student.getLast_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.last.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)student.getEthnicity())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.ethnicity.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)student.getGender())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.gender.is.required"));
        }
        int age = DateUtils.getAge((Date)student.getDate_of_birth());
        if (age < 4 || age > 19) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.age.must.be.four.to.nineteen"));
        }
        Avatar avatar = this.avatarService.getAvatarById(student.getAvatar_id());
        if (avatar == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.avatar.is.not.found"));
        }
        Standard std = this.standardService.getStandardById(student.getStandard_id());
        if (std == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.standard.is.not.found"));
        }
        Account account = this.accountService.changeUsername2(s.getAccount_id(), student.getUsername2());
        s.setFirst_name(student.getFirst_name());
        s.setLast_name(student.getLast_name());
        s.setAvatar(avatar);
        s.setDate_of_birth(student.getDate_of_birth());
        s.setEthnicity(student.getEthnicity());
        s.setGender(student.getGender());
        s.setStandard(std);
        Student stud = (Student)this.studentRepository.save((Object)s);
        return new ResponseEntity((Object)stud, HttpStatus.OK);
    }

    @PostMapping(value={"/change-password"})
    public ResponseEntity<Message> changePassword(@RequestHeader(value="Authorization") String token, @RequestBody StudentChangePasswordRequest request) {
        this.authService.isAuthenticated(token);
        if (request.getPassword().length() < 6) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.password.should.be.six.character.long"));
        }
        Student s = this.studentRepository.findByStudentId(Long.valueOf(request.getStudent_id()));
        if (s == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.is.not.found"));
        }
        Account account = this.accountService.changePassword(s.getAccount_id(), request.getPassword());
        Message message = new Message(this.messageService.getMessage("password.updated.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/edit/profile/youth"})
    public ResponseEntity<Student> editProfileYouth(@RequestHeader(value="Authorization") String token, @RequestBody Student student) {
        Standard standard;
        Student s = this.authService.isStudent(token);
        if (s == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.is.not.found"));
        }
        Instructor instructor = this.instructorService.getInstructorById(student.getInstructor_id());
        Parent parent = this.parentService.getParentById(student.getParent_id());
        if (instructor == null && parent == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("please.provide.a.valid.parent.or.instructor"));
        }
        if (student.getDate_of_birth() != null && s.getDate_of_birth() == null) {
            DateUtils.isAgeInRange((Date)student.getDate_of_birth(), (int)4, (int)19);
            s.setDate_of_birth(student.getDate_of_birth());
        }
        if (instructor != null) {
            if (s.getSchool() != null && s.getSchool_id() != instructor.getSchool_id()) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("instructor.s.school.and.student.s.school.must.be.same"));
            }
            s.setInstructor(instructor);
            if (s.getSchool() == null) {
                School schoolByInstructor = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()));
                s.setSchool(schoolByInstructor);
            }
        } else {
            s.setInstructor(null);
        }
        s.setParent(parent);
        Avatar avatar = this.avatarService.getAvatarById(student.getAvatar_id());
        if (avatar == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.avatar.is.not.found"));
        }
        s.setAvatar(avatar);
        if (!AppUtils.isNullOrEmpty((String)student.getGender()) && AppUtils.isNullOrEmpty((String)s.getGender())) {
            s.setGender(student.getGender());
        }
        if ((standard = this.standardService.getStandardById(student.getStandard_id())) != null && s.getStandard() == null) {
            s.setStandard(standard);
        }
        if (!AppUtils.isNullOrEmpty((String)student.getEthnicity()) && AppUtils.isNullOrEmpty((String)s.getEthnicity())) {
            s.setEthnicity(student.getEthnicity());
        }
        s.setShare_your_success(student.isShare_your_success());
        Student stud = (Student)this.studentRepository.save((Object)s);
        try {
            this.accessCodeRepository.updateUpdateInstructorIdAndParentIdByStudentId(stud.getInstructor() != null ? stud.getInstructor().getInstructor_id() : 0L, stud.getParent() != null ? stud.getParent().getParent_id() : 0L, stud.getStudent_id());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.wallPostService.syncWallPostRequests(stud);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ResponseEntity((Object)stud, HttpStatus.OK);
    }

    @PostMapping(value={"/assign-to-group"})
    public ResponseEntity<Message> assignToGroup(@RequestHeader(value="Authorization") String token, @RequestBody AssignToGroupRequest request) {
        Instructor instructor = this.authService.isInstructor(token);
        this.classService.assignClassToStudents(instructor.getInstructor_id(), request.getClass_id(), request.getStudent_ids());
        Message message = new Message(this.messageService.getMessage("the.group.is.assigned.to.students.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/assign-to-groups"})
    public ResponseEntity<Message> assignToGroups(@RequestHeader(value="Authorization") String token, @RequestBody AssignToGroupsRequest request) {
        Instructor instructor = this.authService.isInstructor(token);
        this.classService.assignClassesToStudents(instructor.getInstructor_id(), request.getClass_ids(), request.getStudent_ids());
        Message message = new Message(this.messageService.getMessage("the.group.is.assigned.to.students.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/change-grade"})
    public ResponseEntity<Message> changeGrade(@RequestHeader(value="Authorization") String token, @RequestBody ChangeGradeRequest request) {
        Instructor instructor = this.authService.isInstructor(token);
        this.standardService.changeStandard(instructor.getInstructor_id(), request.getStandard_id(), request.getStudent_ids());
        Message message = new Message(this.messageService.getMessage("the.group.is.changed.for.students.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @GetMapping(value={"/set-access-code-for-students"})
    public ResponseEntity<Message> setAccessCodeForStudents(@RequestHeader(value="Authorization") String token) {
        this.authService.isAdmin(token);
        this.studentRepository.findAllOrderByIdAsc().parallelStream().forEach(student -> {
            AccessCode accessCodeForStudent = this.accessCodeRepository.findByStudentId(student.getStudent_id());
            AccessCode accessCode = this.accessCodeService.createAccessCode(student.getStudent_id().longValue(), accessCodeForStudent == null ? Status.PENDING : accessCodeForStudent.getStatus());
            System.out.println("setAccessCodeForStudents Student Id " + student.getStudent_id() + " Status" + accessCode.getStatus());
        });
        return new ResponseEntity((Object)new Message("Done"), HttpStatus.OK);
    }

    @PostMapping(value={"/delete-by-ids"})
    public ResponseEntity<Message> deleteByIds(@RequestHeader(value="Authorization") String token, @RequestBody DeleteRequest request) {
        List schools = this.authService.getSchoolByToken(token);
        Instructor instructor = this.authService.getInstructorByToken(token);
        if (AppUtils.isNullOrEmpty((List)schools) && instructor == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        if (AppUtils.isNullOrEmpty((List)request.getStudentIds())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.ids.should.not.be.empty"));
        }
        this.classAndStudentService.deleteStudentsByIds(request.getStudentIds());
        Message message = new Message(this.messageService.getMessage("the.student.is.deleted.successfully"));
        if (request.getStudentIds().size() > 1) {
            message.setMessage(this.messageService.getMessage("the.students.are.deleted.successfully"));
        }
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/should-share-with-instructor-and-parents"})
    public ResponseEntity<Student> shouldShareWithInstructorAndParents(@RequestHeader(value="Authorization") String token, @RequestBody ShouldShareWithInstructorAndParentsRequest request) {
        Student student = this.authService.isStudent(token);
        return new ResponseEntity((Object)this.studentService.shouldShareWithInstructorAndParents(student.getStudent_id(), request.isShare_journal_with_instructor(), request.isShare_journal_with_parents()), HttpStatus.OK);
    }

    @GetMapping(value={"/get-count"})
    public ResponseEntity<GetStudentCountResponse> getCount(@RequestHeader(value="Authorization") String token) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)GetStudentCountResponse.builder().count(this.studentService.getAll().size()).build(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-student-id-and-standard-id-by-student-ids"})
    public ResponseEntity<List<StudentIdAndStandardIdWrapper>> getStudentIdAndStandardIdByStudentIds(@RequestBody GetByStudentIdsRequest request) {
        return new ResponseEntity((Object)this.studentService.getStudentIdAndStandardIdByStudentIds(request.getStudent_ids()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-account-id"})
    public ResponseEntity<StudentCoreDTO> getByAccountId(@RequestBody GetByAccountIdRequest request) {
        return new ResponseEntity((Object)this.studentService.getByAccountId(request.getAccount_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-student-id"})
    public ResponseEntity<StudentCoreDTO> getByStudentId(@RequestBody GetByStudentIdRequest request) {
        return new ResponseEntity((Object)this.studentService.getByStudentId(request.getStudent_id()), HttpStatus.OK);
    }
}

