/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.service;

import com.infinite.focus.server.accesscode.entity.AccessCode;
import com.infinite.focus.server.accesscode.service.AccessCodeService;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.auth.request.StudentSignUpRequest;
import com.infinite.focus.server.auth.response.ValidationResponse;
import com.infinite.focus.server.auth.service.ValidationService;
import com.infinite.focus.server.avatar.service.AvatarService;
import com.infinite.focus.server.clever.model.AccessToken;
import com.infinite.focus.server.clever.model.CleverInstructor;
import com.infinite.focus.server.clever.model.CleverStudent;
import com.infinite.focus.server.clever.service.CleverService;
import com.infinite.focus.server.clever.service.student.CleverStudentService;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.freetrial.service.FreeTrialService;
import com.infinite.focus.server.grade.service.GradeService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organization.service.OrganizationService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.standard.service.StandardService;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ValidationServiceImpl
implements ValidationService {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    MessageService messageService;
    @Autowired
    StudentService studentService;
    @Autowired
    InstructorService instructorService;
    @Autowired
    SchoolService schoolService;
    @Autowired
    DistrictService districtService;
    @Autowired
    OrganizationService organizationService;
    @Autowired
    FreeTrialService freeTrialService;
    @Autowired
    ParentService parentService;
    @Autowired
    CorporateService corporateService;
    @Autowired
    GradeService gradeService;
    @Autowired
    StandardService standardService;
    @Autowired
    AvatarService avatarService;
    @Autowired
    AccountService accountService;
    @Autowired
    AccessCodeService accessCodeService;
    @Autowired
    CleverService cleverService;
    @Autowired
    CleverStudentService cleverStudentService;

    public ValidationResponse isValidStudent(long student_id) {
        Student student = this.studentService.getStudentById(student_id);
        if (student == null) {
            return new ValidationResponse(false, this.messageService.getMessage("the.student.is.not.found"));
        }
        if (student.isArchived()) {
            return new ValidationResponse(false, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
        }
        if (student.isAccess_removed_by_parent()) {
            return new ValidationResponse(false, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
        }
        AccessCode accessCode = this.accessCodeService.getAccessCodeByStudentId(student.getStudent_id());
        if (accessCode != null) {
            if (accessCode.getStatus() == Status.PENDING) {
                return new ValidationResponse(false, this.messageService.getMessage("the.teacher.or.parent.has.not.verified.your.account"));
            }
            if (accessCode.getStatus() == Status.REJECTED) {
                return new ValidationResponse(false, this.messageService.getMessage("the.teacher.or.parent.has.rejected.your.account"));
            }
        }
        return this.isValidInstructorOrParent(student.getInstructor_id(), student.getParent_id());
    }

    public ValidationResponse isValidInstructorOrParent(long instructor_id, long parent_id) {
        ValidationResponse validationResponseInstructor = this.isValidInstructor(instructor_id);
        ValidationResponse validationResponseParent = this.isValidParent(parent_id);
        if (validationResponseInstructor.isValid() || validationResponseParent.isValid()) {
            ValidationResponse validationResponse = new ValidationResponse(true);
            if (validationResponseInstructor.isValid()) {
                validationResponse = validationResponseInstructor;
            } else if (validationResponseParent.isValid()) {
                validationResponse = validationResponseParent;
            }
            return validationResponse;
        }
        if (instructor_id > 0L) {
            return validationResponseInstructor;
        }
        if (parent_id > 0L) {
            return validationResponseParent;
        }
        return new ValidationResponse(false, this.messageService.getMessage("the.student.don.t.have.an.instructor.or.a.parent"));
    }

    public ValidationResponse isValidInstructor(long instructor_id) {
        Instructor instructor = this.instructorService.getInstructorById(instructor_id);
        if (instructor == null) {
            return new ValidationResponse(false, this.messageService.getMessage("instructor.is.not.found"));
        }
        if (instructor.isArchived()) {
            return new ValidationResponse(false, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
        }
        return this.isValidSchool(instructor.getSchool_id());
    }

    public ValidationResponse isValidSchool(long school_id) {
        School school = this.schoolService.getSchoolById(school_id);
        if (school == null) {
            return new ValidationResponse(false, this.messageService.getMessage("school.is.not.found"));
        }
        if (school.getDistrict_id() > 0L) {
            return this.isValidDistrict(school.getDistrict_id());
        }
        if (school.isDeleted()) {
            ValidationResponse validationResponse = new ValidationResponse();
            validationResponse.setValid(false);
            validationResponse.setFromSchool(true);
            validationResponse.setDeleted(school.isDeleted());
            validationResponse.setSubscriptionActive(this.isSchoolSubscriptionActive(school));
            validationResponse.setActive(school.isActive());
            validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)school.getLicense_key()));
            validationResponse.setRenewalDate(this.schoolService.getRenewalDate(school.getSchool_id()));
            validationResponse.setMessage(this.messageService.getMessage().getAdmin_deletes());
            return validationResponse;
        }
        if (AppUtils.isNotNullOrEmpty((String)school.getLicense_key())) {
            boolean should_validate_license_key = this.configurationService.getConfiguration().isShould_validate_license_key();
            if (school.getLicence_key_expiry_date() != null && should_validate_license_key && DateUtils.checkDateTimeIsPassed((Date)school.getLicence_key_expiry_date())) {
                school = this.organizationService.activeDeactiveOrganization(school.getSchool_id(), false);
                ValidationResponse validationResponse = new ValidationResponse();
                validationResponse.setValid(false);
                validationResponse.setFromSchool(true);
                validationResponse.setDeleted(school.isDeleted());
                validationResponse.setActive(school.isActive());
                validationResponse.setSubscriptionActive(false);
                validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)school.getLicense_key()));
                validationResponse.setRenewalDate(this.schoolService.getRenewalDate(school.getSchool_id()));
                validationResponse.setMessage(this.messageService.getMessage().getSubscription_expired());
                return validationResponse;
            }
        } else {
            boolean trialIsActive = this.freeTrialService.checkTrialActiveBySchoolId(school.getSchool_id());
            if (!trialIsActive) {
                ValidationResponse validationResponse = new ValidationResponse();
                validationResponse.setValid(false);
                validationResponse.setFromSchool(true);
                validationResponse.setDeleted(school.isDeleted());
                validationResponse.setActive(school.isActive());
                validationResponse.setSubscriptionActive(false);
                validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)school.getLicense_key()));
                validationResponse.setRenewalDate(this.schoolService.getRenewalDate(school.getSchool_id()));
                validationResponse.setMessage(this.messageService.getMessage().getFree_trial_expired());
                return validationResponse;
            }
        }
        if (!school.isActive()) {
            ValidationResponse validationResponse = new ValidationResponse();
            validationResponse.setValid(false);
            validationResponse.setFromSchool(true);
            validationResponse.setDeleted(school.isDeleted());
            validationResponse.setSubscriptionActive(this.isSchoolSubscriptionActive(school));
            validationResponse.setActive(school.isActive());
            validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)school.getLicense_key()));
            validationResponse.setRenewalDate(this.schoolService.getRenewalDate(school.getSchool_id()));
            validationResponse.setMessage(this.messageService.getMessage().getAdmin_deactivates());
            return validationResponse;
        }
        ValidationResponse validationResponse = new ValidationResponse();
        validationResponse.setValid(true);
        validationResponse.setFromSchool(true);
        validationResponse.setDeleted(school.isDeleted());
        validationResponse.setSubscriptionActive(this.isSchoolSubscriptionActive(school));
        validationResponse.setActive(school.isActive());
        validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)school.getLicense_key()));
        validationResponse.setRenewalDate(this.schoolService.getRenewalDate(school.getSchool_id()));
        return validationResponse;
    }

    private boolean isSchoolSubscriptionActive(School school) {
        if (AppUtils.isNotNullOrEmpty((String)school.getLicense_key())) {
            boolean should_validate_license_key = this.configurationService.getConfiguration().isShould_validate_license_key();
            if (school.getLicence_key_expiry_date() != null && should_validate_license_key && DateUtils.checkDateTimeIsPassed((Date)school.getLicence_key_expiry_date())) {
                this.organizationService.activeDeactiveOrganization(school.getSchool_id(), false);
                return false;
            }
            return true;
        }
        return this.freeTrialService.checkTrialActiveBySchoolId(school.getSchool_id());
    }

    public ValidationResponse isValidDistrict(long district_id) {
        District district = this.districtService.getDistrictById(district_id);
        if (district == null) {
            return new ValidationResponse(false, this.messageService.getMessage("the.district.is.not.found"));
        }
        if (district.isDeleted()) {
            ValidationResponse validationResponse = new ValidationResponse();
            validationResponse.setValid(false);
            validationResponse.setFromDistrict(true);
            validationResponse.setDeleted(district.isDeleted());
            validationResponse.setSubscriptionActive(this.isDistrictSubscriptionActive(district));
            validationResponse.setActive(district.isActive());
            validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)district.getLicense_key()));
            validationResponse.setRenewalDate(this.districtService.getRenewalDate(district.getDistrict_id()));
            validationResponse.setMessage(this.messageService.getMessage().getAdmin_deletes());
            return validationResponse;
        }
        if (AppUtils.isNotNullOrEmpty((String)district.getLicense_key())) {
            boolean should_validate_license_key = this.configurationService.getConfiguration().isShould_validate_license_key();
            if (district.getLicence_key_expiry_date() != null && should_validate_license_key && DateUtils.checkDateTimeIsPassed((Date)district.getLicence_key_expiry_date())) {
                district = this.organizationService.activeDeactiveLargeOrganization(district.getDistrict_id(), false);
                ValidationResponse validationResponse = new ValidationResponse();
                validationResponse.setValid(false);
                validationResponse.setFromDistrict(true);
                validationResponse.setDeleted(district.isDeleted());
                validationResponse.setActive(district.isActive());
                validationResponse.setSubscriptionActive(false);
                validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)district.getLicense_key()));
                validationResponse.setRenewalDate(this.districtService.getRenewalDate(district.getDistrict_id()));
                validationResponse.setMessage(this.messageService.getMessage().getSubscription_expired());
                return validationResponse;
            }
        } else {
            boolean trialIsActive = this.freeTrialService.checkTrialActiveByDistrictId(district.getDistrict_id());
            if (!trialIsActive) {
                ValidationResponse validationResponse = new ValidationResponse();
                validationResponse.setValid(false);
                validationResponse.setFromDistrict(true);
                validationResponse.setDeleted(district.isDeleted());
                validationResponse.setActive(district.isActive());
                validationResponse.setSubscriptionActive(false);
                validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)district.getLicense_key()));
                validationResponse.setRenewalDate(this.districtService.getRenewalDate(district.getDistrict_id()));
                validationResponse.setMessage(this.messageService.getMessage().getFree_trial_expired());
                return validationResponse;
            }
        }
        if (!district.isActive()) {
            ValidationResponse validationResponse = new ValidationResponse();
            validationResponse.setValid(false);
            validationResponse.setFromDistrict(true);
            validationResponse.setDeleted(district.isDeleted());
            validationResponse.setSubscriptionActive(this.isDistrictSubscriptionActive(district));
            validationResponse.setActive(district.isActive());
            validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)district.getLicense_key()));
            validationResponse.setRenewalDate(this.districtService.getRenewalDate(district.getDistrict_id()));
            validationResponse.setMessage(this.messageService.getMessage().getAdmin_deactivates());
            return validationResponse;
        }
        ValidationResponse validationResponse = new ValidationResponse();
        validationResponse.setValid(true);
        validationResponse.setFromDistrict(true);
        validationResponse.setDeleted(district.isDeleted());
        validationResponse.setSubscriptionActive(this.isDistrictSubscriptionActive(district));
        validationResponse.setActive(district.isActive());
        validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)district.getLicense_key()));
        validationResponse.setRenewalDate(this.districtService.getRenewalDate(district.getDistrict_id()));
        return validationResponse;
    }

    private boolean isDistrictSubscriptionActive(District district) {
        if (AppUtils.isNotNullOrEmpty((String)district.getLicense_key())) {
            boolean should_validate_license_key = this.configurationService.getConfiguration().isShould_validate_license_key();
            if (district.getLicence_key_expiry_date() != null && should_validate_license_key && DateUtils.checkDateTimeIsPassed((Date)district.getLicence_key_expiry_date())) {
                this.organizationService.activeDeactiveLargeOrganization(district.getDistrict_id(), false);
                return false;
            }
            return true;
        }
        return this.freeTrialService.checkTrialActiveByDistrictId(district.getDistrict_id());
    }

    public ValidationResponse isValidParent(long parent_id) {
        Parent parent = this.parentService.getParentById(parent_id);
        if (parent == null) {
            return new ValidationResponse(false, this.messageService.getMessage("parent.is.not.found"));
        }
        if (parent.isDeleted()) {
            ValidationResponse validationResponse = new ValidationResponse();
            validationResponse.setValid(false);
            validationResponse.setFromParent(true);
            validationResponse.setDeleted(parent.isDeleted());
            validationResponse.setMessage(this.messageService.getMessage().getCorporate_deletes());
            return validationResponse;
        }
        return this.isValidCorporateOrSchool(parent.getCorporate_id(), parent.getSchool_id());
    }

    public ValidationResponse isValidCorporateOrSchool(long corporate_id, long school_id) {
        ValidationResponse validationResponseCorporate = this.isValidCorporate(corporate_id);
        ValidationResponse validationResponseSchool = this.isValidSchool(school_id);
        if (validationResponseCorporate.isValid() || validationResponseSchool.isValid()) {
            ValidationResponse validationResponse = new ValidationResponse(true);
            if (validationResponseCorporate.isValid()) {
                validationResponse = validationResponseCorporate;
            } else if (validationResponseSchool.isValid()) {
                validationResponse = validationResponseSchool;
            }
            return validationResponse;
        }
        if (corporate_id > 0L) {
            return validationResponseCorporate;
        }
        if (school_id > 0L) {
            return validationResponseSchool;
        }
        return new ValidationResponse(false, this.messageService.getMessage("the.parent.don.t.have.a.corporate.or.a.organization"));
    }

    public ValidationResponse isValidCorporate(long corporate_id) {
        Corporate corporate = this.corporateService.getCorporateById(corporate_id);
        if (corporate == null) {
            return new ValidationResponse(false, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        if (corporate.isDeleted()) {
            ValidationResponse validationResponse = new ValidationResponse();
            validationResponse.setValid(false);
            validationResponse.setFromCorporate(true);
            validationResponse.setDeleted(corporate.isDeleted());
            validationResponse.setSubscriptionActive(this.isCorporateSubscriptionActive(corporate));
            validationResponse.setActive(corporate.isActive());
            validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)corporate.getLicense_key()));
            validationResponse.setRenewalDate(this.corporateService.getRenewalDate(corporate.getCorporate_id()));
            validationResponse.setMessage(this.messageService.getMessage().getAdmin_deletes());
            return validationResponse;
        }
        if (AppUtils.isNotNullOrEmpty((String)corporate.getLicense_key())) {
            boolean should_validate_license_key = this.configurationService.getConfiguration().isShould_validate_license_key();
            if (corporate.getLicence_key_expiry_date() != null && should_validate_license_key && DateUtils.checkDateTimeIsPassed((Date)corporate.getLicence_key_expiry_date())) {
                corporate = this.corporateService.activeDeactiveCorporate(corporate.getCorporate_id(), false);
                ValidationResponse validationResponse = new ValidationResponse();
                validationResponse.setValid(false);
                validationResponse.setFromCorporate(true);
                validationResponse.setDeleted(corporate.isDeleted());
                validationResponse.setActive(corporate.isActive());
                validationResponse.setSubscriptionActive(false);
                validationResponse.setOnTrial(false);
                validationResponse.setRenewalDate(this.corporateService.getRenewalDate(corporate.getCorporate_id()));
                validationResponse.setMessage(this.messageService.getMessage().getSubscription_expired_corporate());
                return validationResponse;
            }
        } else {
            boolean trialIsActive = this.freeTrialService.checkTrialActiveByCorporateId(corporate.getCorporate_id());
            if (!trialIsActive) {
                ValidationResponse validationResponse = new ValidationResponse();
                validationResponse.setValid(false);
                validationResponse.setFromCorporate(true);
                validationResponse.setDeleted(corporate.isDeleted());
                validationResponse.setActive(corporate.isActive());
                validationResponse.setSubscriptionActive(false);
                validationResponse.setOnTrial(true);
                validationResponse.setRenewalDate(this.corporateService.getRenewalDate(corporate.getCorporate_id()));
                validationResponse.setMessage(this.messageService.getMessage().getFree_trial_expired_corporate());
                return validationResponse;
            }
        }
        if (!corporate.isActive()) {
            ValidationResponse validationResponse = new ValidationResponse();
            validationResponse.setValid(false);
            validationResponse.setFromCorporate(true);
            validationResponse.setDeleted(corporate.isDeleted());
            validationResponse.setSubscriptionActive(this.isCorporateSubscriptionActive(corporate));
            validationResponse.setActive(corporate.isActive());
            validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)corporate.getLicense_key()));
            validationResponse.setRenewalDate(this.corporateService.getRenewalDate(corporate.getCorporate_id()));
            validationResponse.setMessage(this.messageService.getMessage().getAdmin_deactivates());
            return validationResponse;
        }
        ValidationResponse validationResponse = new ValidationResponse();
        validationResponse.setValid(true);
        validationResponse.setFromCorporate(true);
        validationResponse.setDeleted(corporate.isDeleted());
        validationResponse.setSubscriptionActive(this.isCorporateSubscriptionActive(corporate));
        validationResponse.setActive(corporate.isActive());
        validationResponse.setOnTrial(AppUtils.isNullOrEmpty((String)corporate.getLicense_key()));
        validationResponse.setRenewalDate(this.corporateService.getRenewalDate(corporate.getCorporate_id()));
        return validationResponse;
    }

    private boolean isCorporateSubscriptionActive(Corporate corporate) {
        if (AppUtils.isNotNullOrEmpty((String)corporate.getLicense_key())) {
            boolean should_validate_license_key = this.configurationService.getConfiguration().isShould_validate_license_key();
            if (corporate.getLicence_key_expiry_date() != null && should_validate_license_key && DateUtils.checkDateTimeIsPassed((Date)corporate.getLicence_key_expiry_date())) {
                this.corporateService.activeDeactiveCorporate(corporate.getCorporate_id(), false);
                return false;
            }
            return true;
        }
        return this.freeTrialService.checkTrialActiveByCorporateId(corporate.getCorporate_id());
    }

    public void isValidStudentSignUpRequest(StudentSignUpRequest request) {
        ValidationResponse validationResponse;
        if (request.getStudent() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.details.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getStudent().getFirst_name())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("first.name.is.null.or.empty"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getStudent().getLast_name())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("last.name.is.null.or.empty"));
        }
        if (request.getStudent().getDate_of_birth() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.s.date.of.birth.is.not.found"));
        }
        DateUtils.isAgeInRange((Date)request.getStudent().getDate_of_birth(), (int)4, (int)19);
        if (AppUtils.isNullOrEmpty((String)request.getStudent().getGender())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("gender.is.null.or.empty"));
        }
        this.standardService.isValidStandard(request.getStudent().getStandard_id());
        if (AppUtils.isNullOrEmpty((String)request.getStudent().getEthnicity())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("ethnicity.is.null.or.empty"));
        }
        if (!AppUtils.isNullOrEmpty((String)request.getStudent().getClever_id())) {
            Instructor instructor = this.instructorService.getInstructorById(request.getStudent().getInstructor_id());
            if (instructor == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.instructor.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)instructor.getClever_id())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.instructor.has.no.clever.id"));
            }
            School school = this.schoolService.getSchoolById(instructor.getSchool_id());
            if (school == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.school.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)school.getClever_id())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.school.has.no.clever.id"));
            }
            District district = this.districtService.getDistrictById(school.getDistrict_id());
            if (district == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.district.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.district.has.no.clever.id"));
            }
            AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
            CleverStudent cleverStudent = this.cleverStudentService.getCleverStudentByCleverId(accessToken.getAccess_token(), request.getStudent().getClever_id());
            if (cleverStudent == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.clever.id.is.not.valid"));
            }
            if (!cleverStudent.getRoles().getStudent().getSchool().equals(school.getClever_id())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("your.clever.school.is.different.than.clymb.school"));
            }
            CleverInstructor cleverInstructor = this.cleverStudentService.getCleverInstructorsByCleverStudent(accessToken.getAccess_token(), cleverStudent.getId()).stream().filter(item -> item.getId().equals(instructor.getClever_id())).findFirst().orElse(null);
            if (cleverInstructor == null) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("your.clever.teacher.is.different.than.clymb.teacher"));
            }
            if (!cleverInstructor.getRoles().getTeacher().getSchool().equals(school.getClever_id())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("your.clever.s.teacher.s.primary.school.is.different.than.clymb.s.teacher.s.primary.school"));
            }
        }
        if (!(validationResponse = this.isValidInstructorOrParent(request.getStudent().getInstructor_id(), request.getStudent().getParent_id())).isValid()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, validationResponse.getMessage());
        }
        this.avatarService.isValidAvatar(request.getStudent().getAvatar_id());
        this.accountService.isValidUsername2(request.getUsername2());
        this.accountService.isValidUsername(request.getUsername(), request.getStudent().getAccount_id());
        if (AppUtils.isNullOrEmpty((String)request.getPassword())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("password.is.null.or.empty"));
        }
    }

    public ValidationResponse isReachedToTierNoOfYouthLimitByInstructorIdOrParentId(long instructor_id, long parent_id, long size) {
        ValidationResponse validationResponseInstructor = this.isReachedToTierNoOfYouthLimitByInstructorId(instructor_id, size);
        ValidationResponse validationResponseParent = this.isReachedToTierNoOfYouthLimitByParentId(parent_id, size);
        if (validationResponseInstructor.isValid() || validationResponseParent.isValid()) {
            return new ValidationResponse(true);
        }
        if (instructor_id > 0L) {
            return validationResponseInstructor;
        }
        if (parent_id > 0L) {
            return validationResponseParent;
        }
        return new ValidationResponse(false, this.messageService.getMessage("the.student.don.t.have.an.instructor.or.a.parent"));
    }

    public ValidationResponse isReachedToTierNoOfYouthLimitByInstructorId(long instructor_id, long size) {
        Instructor i = this.instructorService.getInstructorById(instructor_id);
        if (i == null) {
            return new ValidationResponse(false, this.messageService.getMessage("instructor.is.not.found"));
        }
        return this.isReachedToTierNoOfYouthLimitBySchoolId(i.getSchool_id(), size);
    }

    public ValidationResponse isReachedToTierNoOfYouthLimitByParentId(long parent_id, long size) {
        Parent parent = this.parentService.getParentById(parent_id);
        if (parent == null) {
            return new ValidationResponse(false, this.messageService.getMessage("parent.is.not.found"));
        }
        ValidationResponse validationResponseOfCorporate = this.isReachedToTierNoOfYouthLimitByCorporateId(parent.getCorporate_id(), size);
        ValidationResponse validationResponseOfSchool = this.isReachedToTierNoOfYouthLimitBySchoolId(parent.getSchool_id(), size);
        if (!validationResponseOfCorporate.isValid() && !validationResponseOfSchool.isValid()) {
            return new ValidationResponse(false, this.messageService.getMessage().getUnable_to_onboard_more_youths());
        }
        return new ValidationResponse(true);
    }

    private ValidationResponse isReachedToTierNoOfYouthLimitByCorporateId(long corporate_id, long size) {
        Corporate corporate = this.corporateService.getCorporateById(corporate_id);
        if (corporate == null) {
            return new ValidationResponse(false, this.messageService.getMessage("corporate.is.not.found"));
        }
        long studentsCount = this.corporateService.getStudentsCountByCorporateId(corporate.getCorporate_id());
        long remainDiff = corporate.getNumber_of_youth() - studentsCount;
        if (remainDiff < size) {
            return new ValidationResponse(false, this.messageService.getMessage().getUnable_to_onboard_more_youths());
        }
        return new ValidationResponse(true);
    }

    private ValidationResponse isReachedToTierNoOfYouthLimitBySchoolId(long school_id, long size) {
        School school = this.schoolService.getSchoolById(school_id);
        if (school == null) {
            return new ValidationResponse(false, this.messageService.getMessage("school.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district != null) {
            long studentsCount = this.districtService.getStudentsCountByDistrictId(district.getDistrict_id());
            long remainDiff = district.getNumber_of_youth() - studentsCount;
            if (remainDiff < size) {
                return new ValidationResponse(false, this.messageService.getMessage().getUnable_to_onboard_more_youths());
            }
        } else {
            long studentsCount = this.schoolService.getStudentsCountBySchoolId(school.getSchool_id());
            long remainDiff = school.getNumber_of_youth() - studentsCount;
            if (remainDiff < size) {
                return new ValidationResponse(false, this.messageService.getMessage().getUnable_to_onboard_more_youths());
            }
        }
        return new ValidationResponse(true);
    }

    public ValidationResponse isOverToNoOfYouthLimit(Student student) {
        Corporate corporate;
        Parent parent;
        School school = student.getSchool();
        ValidationResponse validationResponse = new ValidationResponse(true);
        if (school != null) {
            long studentsCount;
            District district = this.districtService.getDistrictById(school.getDistrict_id());
            if (district != null) {
                studentsCount = this.districtService.getStudentsCountByDistrictId(district.getDistrict_id());
                if (studentsCount > district.getNumber_of_youth()) {
                    validationResponse = new ValidationResponse(false, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
                    validationResponse.setFromDistrict(true);
                } else {
                    validationResponse.setFromDistrict(true);
                }
            } else {
                studentsCount = this.schoolService.getStudentsCountBySchoolId(school.getSchool_id());
                if (studentsCount > school.getNumber_of_youth()) {
                    validationResponse = new ValidationResponse(false, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
                    validationResponse.setFromSchool(true);
                } else {
                    validationResponse.setFromSchool(true);
                }
            }
        }
        if ((parent = student.getParent()) != null && parent.getCorporate_id() > 0L && !validationResponse.isValid() && (corporate = this.corporateService.getCorporateById(parent.getCorporate_id())) != null) {
            long studentsCount = this.corporateService.getStudentsCountByCorporateId(corporate.getCorporate_id());
            if (studentsCount > corporate.getNumber_of_youth()) {
                validationResponse = new ValidationResponse(false, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
                validationResponse.setFromCorporate(true);
            } else {
                validationResponse = new ValidationResponse(true);
                validationResponse.setFromCorporate(true);
            }
        }
        return validationResponse;
    }
}

