/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.instructor.controller;

import com.infinite.focus.server.accesscode.entity.AccessCode;
import com.infinite.focus.server.accesscode.repository.AccessCodeRepository;
import com.infinite.focus.server.accesscode.service.AccessCodeService;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.auth.request.InstructorSignUpRequest;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.clever.model.AccessToken;
import com.infinite.focus.server.clever.model.CleverInstructor;
import com.infinite.focus.server.clever.model.CleverSchool;
import com.infinite.focus.server.clever.service.CleverService;
import com.infinite.focus.server.clever.service.data.CleverDataService;
import com.infinite.focus.server.clever.service.instructor.CleverInstructorService;
import com.infinite.focus.server.clever.service.school.CleverSchoolService;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.email.service.EmailSenderService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.instructor.request.ApproveAccessCodeRequest;
import com.infinite.focus.server.instructor.request.GetAccessCodesByInstructorIdRequest;
import com.infinite.focus.server.instructor.request.GetInstructorByIdRequest;
import com.infinite.focus.server.instructor.request.GetInstructorEmailRequest;
import com.infinite.focus.server.instructor.request.SendEmailRequest;
import com.infinite.focus.server.instructor.request.SetNewNotificationsForInstructorRequest;
import com.infinite.focus.server.instructor.response.GetInstructorEmailResponse;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.parent.entity.StudentProfileOtp;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.request.AutoApproveWallPostsRequest;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.standard.service.StandardService;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.template.service.TemplateService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.wallpost.component.WallPostBadWordFilterComponent;
import com.infinite.focus.server.wallpost.entity.WallPost;
import com.infinite.focus.server.wallpost.request.RespondRequest;
import com.infinite.focus.server.wallpost.service.WallPostService;
import com.infinite.focus.server.wallpostrequest.request.WallPostRequestRepository;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/instructor"})
public class InstructorController {
    private AccountRepository accountRepository;
    private StudentRepository studentRepository;
    private InstructorRepository instructorRepository;
    private WallPostRequestRepository wallPostRequestRepository;
    private AccessCodeRepository accessCodeRepository;
    private EmailSenderService emailSenderService;
    @Autowired
    AuthService authService;
    @Autowired
    AccessCodeService accessCodeService;
    @Autowired
    ParentService parentService;
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    TemplateService templateService;
    @Autowired
    StandardService standardService;
    @Autowired
    AccountService accountService;
    @Autowired
    SchoolService schoolService;
    @Autowired
    DistrictService districtService;
    @Autowired
    CleverService cleverService;
    @Autowired
    CleverSchoolService cleverSchoolService;
    @Autowired
    CleverInstructorService cleverInstructorService;
    @Autowired
    CleverDataService cleverDataService;
    @Autowired
    MessageService messageService;
    @Autowired
    WallPostService wallPostService;
    @Autowired
    WallPostBadWordFilterComponent badWordFilterComponent;
    @Autowired
    private InstructorService instructorService;
    @Autowired
    JwtHelper jwtHelper;

    public InstructorController(WallPostRequestRepository wallPostRequestRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, AccountRepository accountRepository, AccessCodeRepository accessCodeRepository, EmailSenderService emailSenderService) {
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.accountRepository = accountRepository;
        this.accessCodeRepository = accessCodeRepository;
        this.emailSenderService = emailSenderService;
    }

    @PostMapping(value={"/get/getAccessCodesByInstructorId"})
    public ResponseEntity<Page<AccessCode>> getAccessCodesByInstructorId(@RequestBody GetAccessCodesByInstructorIdRequest request) {
        Page pagedResult = this.accessCodeService.getAccessCodesByInstructorIdAndStatus(request.getInstructor_id(), request.getStatus(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy());
        return new ResponseEntity((Object)pagedResult, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/approve-access-code"})
    public ResponseEntity<AccessCode> approveAccessCode(@RequestBody ApproveAccessCodeRequest request) throws MessagingException {
        AccessCode accessCode = this.accessCodeRepository.findById((Object)request.getAccess_code_id()).orElse(null);
        if (accessCode != null) {
            if (accessCode.getStudent().getInstructor_id() == request.getInstructor_id().longValue()) {
                accessCode.setStatus(request.getStatus());
                this.accessCodeRepository.save((Object)accessCode);
                StudentProfileOtp studentProfileOtp = this.parentService.updateStudentProfileOtpByAccountIdAndStatus(accessCode.getStudent().getAccount().getAccount_id(), request.getStatus());
                Account account = this.accountRepository.findByAccountId(accessCode.getStudent().getAccount_id());
                if (accessCode.getStatus() == Status.ACCEPTED) {
                    this.emailSenderService.sendHtmlMail(account.getUsername(), Language.isSpanish((String)accessCode.getStudent().getLanguage()) ? "\u00c9xito de la verificaci\u00f3n de la cuenta Clymb" : "Clymb Account Verification Success", this.templateService.getAccountVerificationEmailText(this.configurationService.getConfiguration().getBaseUrlStudent() + "account/login", accessCode.getStudent().getLanguage()));
                }
                return new ResponseEntity((Object)accessCode, HttpStatus.OK);
            }
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/send/email/to/all/instructors"})
    public ResponseEntity<Message> sendEmailToAllInstructors(@RequestHeader(value="Authorization") String token, @RequestBody SendEmailRequest sendEmailRequest) {
        this.authService.isAdmin(token);
        if (AppUtils.isNullOrEmpty((String)sendEmailRequest.getSubject())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.subject.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)sendEmailRequest.getBody())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.body.is.required"));
        }
        List instructorsEmails = this.instructorRepository.getAllInstructorsEmailAddresses();
        for (int i = 0; i < instructorsEmails.size(); ++i) {
            String email = (String)instructorsEmails.get(i);
            if (!AppUtils.isNotNullOrEmpty((String)email)) continue;
            try {
                this.emailSenderService.sendHtmlMail(email, sendEmailRequest.getSubject(), this.templateService.getSendEmailToAllInstructorEmailText(sendEmailRequest.getBody()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Message message = new Message(this.messageService.getMessage("email.has.been.sent.to.all.instructors"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/edit/profile"})
    public ResponseEntity<Instructor> editProfile(@RequestHeader(value="Authorization") String token, @RequestBody InstructorSignUpRequest request) {
        Object district;
        Instructor i = this.authService.isInstructor(token);
        if (i == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.instructor.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getInstructor().getFirst_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.first.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getInstructor().getLast_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.last.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getInstructor().getState())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.state.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getInstructor().getCity())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.city.is.required"));
        }
        if (!AppUtils.isNullOrEmpty((String)request.getInstructor().getClever_id())) {
            this.cleverDataService.isCleverIdAlreadyInUse(request.getInstructor().getClever_id());
            School school = this.schoolService.getSchoolById(i.getSchool_id());
            if (school == null) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.school.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)school.getClever_id())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.school.has.no.valid.clever.id"));
            }
            district = this.districtService.getDistrictById(school.getDistrict_id());
            if (district == null) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.district.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.district.has.no.valid.clever.id"));
            }
            AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
            if (accessToken == null) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.district.s.clever.id.is.not.valid"));
            }
            CleverSchool cleverSchool = this.cleverSchoolService.getCleverSchoolById(accessToken.getAccess_token(), school.getClever_id());
            if (cleverSchool == null) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.school.s.clever.id.is.not.valid"));
            }
            if (!cleverSchool.getDistrict().equals(district.getClever_id())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("your.school.s.clever.district.is.different.than.clymb.district"));
            }
            CleverInstructor cleverInstructor = this.cleverInstructorService.getCleverInstructorByCleverId(accessToken.getAccess_token(), request.getInstructor().getClever_id());
            if (cleverInstructor == null) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
            }
            if (!cleverInstructor.getRoles().getTeacher().getSchool().equals(cleverSchool.getId())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("your.clever.primary.school.is.different.than.clymb.primary.school"));
            }
        }
        Account account = this.accountService.changeEmail(i.getAccount_id(), request.getInstructor().getUsername());
        i.setFirst_name(request.getInstructor().getFirst_name());
        i.setLast_name(request.getInstructor().getLast_name());
        i.setState(request.getInstructor().getState());
        i.setCity(request.getInstructor().getCity());
        i.setUsername(account.getUsername());
        i.setClever_id(request.getInstructor().getClever_id());
        i.getStandards().clear();
        district = request.getStandard_ids().iterator();
        while (district.hasNext()) {
            long standard_id = (Long)district.next();
            Standard standard = this.standardService.findByStandardId(standard_id);
            if (standard == null) continue;
            i.getStandards().add(standard);
        }
        Instructor instru = (Instructor)this.instructorRepository.save((Object)i);
        String newToken = this.jwtHelper.generateToken(account.getUsername());
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Authorization", newToken);
        responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(account.getUsername()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)instru);
    }

    @PostMapping(value={"/auto/approve/wall/posts"})
    public ResponseEntity<Instructor> autoApproveWallPosts(@RequestHeader(value="Authorization") String token, @RequestBody AutoApproveWallPostsRequest request) {
        Instructor instructor = this.authService.isInstructor(token);
        if (instructor == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.instructor.is.not.found"));
        }
        instructor.setAuto_approve_wall_posts(request.isAuto_approve_wall_posts());
        Instructor finalInstructor = instructor = (Instructor)this.instructorRepository.save((Object)instructor);
        new Thread(() -> this.approveWallPostsByInstructor(finalInstructor)).start();
        return new ResponseEntity((Object)instructor, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    private void approveWallPostsByInstructor(Instructor instructor) {
        if (instructor != null && instructor.isAuto_approve_wall_posts()) {
            List studentViews = this.studentRepository.findAllWhoCompletedFirstLoginByInstructorId(instructor.getInstructor_id());
            Set studentIds = studentViews.stream().distinct().map(StudentView::getStudent_id).collect(Collectors.toSet());
            List list = this.wallPostRequestRepository.findAll().stream().filter(wallPostRequest -> {
                WallPost wallPost = this.wallPostService.getByWallPostId(wallPostRequest.getWall_post_id());
                return wallPost != null && studentIds.contains(wallPost.getStudent_id()) && this.badWordFilterComponent.isThereAnyBadWordInText(wallPost.getText()) == false;
            }).map(wallPostRequest -> {
                RespondRequest respondRequest = new RespondRequest();
                respondRequest.setWall_post_request_id(Long.valueOf(wallPostRequest.getWall_post_request_id()));
                respondRequest.setResponse(Boolean.valueOf(true));
                try {
                    return this.wallPostService.approveRejectWallPost(respondRequest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    @PostMapping(value={"/get/instructor/email"})
    public ResponseEntity<GetInstructorEmailResponse> getInstructorEmail(@RequestBody GetInstructorEmailRequest request) {
        return new ResponseEntity((Object)GetInstructorEmailResponse.builder().email(this.instructorService.getInstructorEmailByInstructorId(request.getInstructor_id())).build(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-instructor-by-id"})
    public ResponseEntity<Instructor> getInstructorById(@RequestBody GetInstructorByIdRequest request) {
        return new ResponseEntity((Object)this.instructorService.getById(request.getId()), HttpStatus.OK);
    }

    @PostMapping(value={"/set-new-notifications"})
    public ResponseEntity<Void> setNewNotificationsForInstructor(@RequestBody SetNewNotificationsForInstructorRequest request) {
        this.instructorService.setNewNotificationsForInstructor(request.getInstructor_id(), request.isNew_notifications());
        return new ResponseEntity(HttpStatus.OK);
    }
}

