/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.corporatenotification.service;

import com.infinite.focus.server.corporatenotification.entity.CorporateNotification;
import com.infinite.focus.server.corporatenotification.repository.CorporateNotificationRepository;
import com.infinite.focus.server.corporatenotification.service.CorporateNotificationService;
import com.infinite.focus.server.fcm.dto.PushNotificationDTO;
import com.infinite.focus.server.fcm.request.SendFirebasePushNotificationRequest;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class CorporateNotificationServiceImpl
implements CorporateNotificationService {
    private final RestComponent restComponent;
    private final EntityManager entityManager;
    private final CorporateNotificationRepository corporateNotificationRepository;
    private final RealTimeMessageService realTimeMessageService;

    public CorporateNotificationServiceImpl(RestComponent restComponent, EntityManager entityManager, CorporateNotificationRepository corporateNotificationRepository, RealTimeMessageService realTimeMessageService) {
        this.restComponent = restComponent;
        this.entityManager = entityManager;
        this.corporateNotificationRepository = corporateNotificationRepository;
        this.realTimeMessageService = realTimeMessageService;
    }

    public Page<CorporateNotification> getCorporateNotificationsByCorporateId(Long corporate_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy, Date fromDate, Date toDate) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(CorporateNotification.class);
        Root root = query.from(CorporateNotification.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(qb.equal((Expression)root.get("corporate_id"), (Object)corporate_id));
        if (fromDate != null && toDate != null) {
            System.out.println("getCorporateNotificationsByCorporateId FromDate " + DateUtils.dayWitTimeFormat.format(fromDate) + " - ToDate " + DateUtils.dayWitTimeFormat.format(toDate));
            predicates.add(qb.between((Expression)root.get("createdAt"), (Comparable)DateUtils.getFromDateWithoutTime((Date)fromDate), (Comparable)DateUtils.getToDateWithoutTime((Date)toDate)));
        }
        query.where(predicates.toArray(new Predicate[0]));
        if (orderBy.equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)root.get(sortBy))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)root.get(sortBy))});
        }
        PageRequest pageable = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(CorporateNotification.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        return pagedResult;
    }

    public void addNotificationByCorporateId(Map<Long, Long> corporate_ids_and_account_ids, String text, String text_es) {
        ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
        for (long corporate_id : corporate_ids_and_account_ids.keySet()) {
            CorporateNotification corporateNotification = new CorporateNotification();
            corporateNotification.setCorporate_id(corporate_id);
            corporateNotification.setText(text);
            corporateNotification.setText_es(text_es);
            corporateNotification.setCreatedAt(new Date());
            this.corporateNotificationRepository.save((Object)corporateNotification);
            this.restComponent.setNewNotificationsForCorporate(corporate_id, true);
            String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + text + "\",\"message_es\":\"" + text_es + "\"}";
            this.realTimeMessageService.sendMessage(corporate_id, json_message);
            PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).account_id(corporate_ids_and_account_ids.get(corporate_id).longValue()).title(corporateNotification.getText()).title_es(corporateNotification.getText_es()).message(corporateNotification.getText()).message_es(corporateNotification.getText_es()).createdAt(corporateNotification.getCreatedAt()).build();
            pushNotificationDTOS.add(pushNotificationDTO);
        }
        try {
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

