/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.email.service;

import java.io.File;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="emailSenderService")
public class EmailSenderService {
    private JavaMailSender javaMailSender;

    @Autowired
    public EmailSenderService(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    @Async
    public void sendEmail(SimpleMailMessage email) {
        email.setFrom("info@clymbup.io");
        this.javaMailSender.send(email);
    }

    @Async
    public void sendHtmlMail(String to, String subject, String body) throws MessagingException {
        MimeMessage mail = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail, true);
        try {
            helper.setFrom("info@clymbup.io", "The Clymb Team");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            helper.setFrom("info@clymbup.io");
        }
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(body, true);
        this.javaMailSender.send(mail);
    }

    @Async
    public void sendMailWithAttachment(String to, String subject, String body, String attachmentFilename, File attachment) throws MessagingException {
        MimeMessage mail = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail, true);
        try {
            helper.setFrom("info@clymbup.io", "The Clymb Team");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            helper.setFrom("info@clymbup.io");
        }
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(body, true);
        helper.addAttachment(attachmentFilename, attachment);
        this.javaMailSender.send(mail);
    }
}

