/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosoption.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.infinite.focus.server.sosoption.dto.SOSOptionDTO;
import com.infinite.focus.server.sosoption.request.GetOptionsByQuestionIdRequest;
import com.infinite.focus.server.sosoption.request.GetSOSOptionsByIdsRequest;
import com.infinite.focus.server.sosoption.service.SOSOptionService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/sos-option"})
public class SOSOptionController {
    @Autowired
    private SOSOptionService sosOptionService;
    @Autowired
    private ObjectMapper mapper;

    @PostMapping(value={"/create/option"})
    public ResponseEntity<SOSOptionDTO> create(@RequestBody SOSOptionDTO request) {
        return new ResponseEntity((Object)this.sosOptionService.create(request.getSos_question_id(), request.getSos_option(), request.getSos_option_es(), request.getSort_index()), HttpStatus.CREATED);
    }

    @PostMapping(value={"/create/options"})
    public ResponseEntity<List<SOSOptionDTO>> createOptions(@RequestBody List<SOSOptionDTO> request) {
        List options = (List)this.mapper.convertValue(request, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return new ResponseEntity((Object)this.sosOptionService.createOptions(options), HttpStatus.CREATED);
    }

    @PostMapping(value={"/get-active-by-ids"})
    public ResponseEntity<List<SOSOptionDTO>> getActiveByIds(@RequestBody List<Long> ids) {
        return new ResponseEntity((Object)this.sosOptionService.getActiveByIds(ids), HttpStatus.OK);
    }

    @PostMapping(value={"/get-sos-options-by-ids"})
    public ResponseEntity<List<SOSOptionDTO>> getActiveByIds(@RequestBody GetSOSOptionsByIdsRequest request) {
        return new ResponseEntity((Object)this.sosOptionService.getByIds(request.getSos_option_ids()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-options/by/question/id"})
    public ResponseEntity<List<SOSOptionDTO>> getOptionsByQuestionId(@RequestBody GetOptionsByQuestionIdRequest request) {
        return new ResponseEntity((Object)this.sosOptionService.getOptionsByQuestionId(request.getQuestion_id()), HttpStatus.OK);
    }
}

