/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentpushnotification.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.request.SetNotificationViewedRequest;
import com.infinite.focus.server.studentpushnotification.request.BadgeReceivedNotificationRequest;
import com.infinite.focus.server.studentpushnotification.request.StreakReceivedNotification;
import com.infinite.focus.server.studentpushnotification.request.WOWPostUnacceptableContentNotification;
import com.infinite.focus.server.studentpushnotification.request.WOWPostUnacceptableContentNotifications;
import com.infinite.focus.server.studentpushnotification.request.WOWReactionNotification;
import com.infinite.focus.server.studentpushnotification.service.StudentPushNotificationService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/student-push-notification"})
public class StudentPushNotificationController {
    private final MessageService messageService;
    private final StudentPushNotificationService studentPushNotificationService;

    public StudentPushNotificationController(MessageService messageService, StudentPushNotificationService studentPushNotificationService) {
        this.messageService = messageService;
        this.studentPushNotificationService = studentPushNotificationService;
    }

    @PostMapping(value={"/badge-received"})
    public ResponseEntity<Message> badgeReceived(@RequestBody BadgeReceivedNotificationRequest request) {
        this.studentPushNotificationService.badgeReceived(request.getBadge_received_push_notifications());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/streak-received"})
    public ResponseEntity<Message> streakReceived(@RequestBody StreakReceivedNotification request) {
        this.studentPushNotificationService.streakReceived(request);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/wow-reaction"})
    public ResponseEntity<Message> wowReaction(@RequestBody WOWReactionNotification request) {
        this.studentPushNotificationService.wowReaction(request);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/wow-post-unacceptable-content"})
    public ResponseEntity<Message> wowPostUnacceptableContent(@RequestBody WOWPostUnacceptableContentNotification request) {
        this.studentPushNotificationService.wowPostUnacceptableContent(request);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/wow-post-unacceptable-contents"})
    public ResponseEntity<Message> wowPostUnacceptableContents(@RequestBody WOWPostUnacceptableContentNotifications request) {
        this.studentPushNotificationService.wowPostUnacceptableContents(request);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/set-notification-viewed"})
    ResponseEntity<Void> setNotificationViewed(@RequestBody SetNotificationViewedRequest request) {
        this.studentPushNotificationService.setNotificationViewed(request);
        return new ResponseEntity(HttpStatus.OK);
    }
}

