/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.submood.repository;

import com.infinite.focus.server.submood.dto.SubMoodDTO;
import com.infinite.focus.server.submood.repository.SubMoodRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class SubMoodRepositoryImpl
implements SubMoodRepository {
    private final JdbcTemplate jdbcTemplate;

    public SubMoodRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static SubMoodDTO mapRow(ResultSet rs, int i) throws SQLException {
        return SubMoodDTO.builder().sub_mood_id(rs.getLong("sub_mood_id")).sub_mood(rs.getString("sub_mood")).sub_mood_es(rs.getString("sub_mood_es")).build();
    }

    public List<SubMoodDTO> findByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<SubMoodDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM sub_mood WHERE sub_mood_id IN(%s) ";
        List subMoodDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), SubMoodRepositoryImpl::mapRow);
        return subMoodDTOS;
    }

    public SubMoodDTO findById(Long sub_mood_id) {
        String SQL = "SELECT * FROM sub_mood WHERE sub_mood_id = ? ";
        try {
            return (SubMoodDTO)this.jdbcTemplate.queryForObject(SQL, SubMoodRepositoryImpl::mapRow, new Object[]{sub_mood_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<SubMoodDTO> findAllSubMoods() {
        String SQL = "SELECT * FROM sub_mood ORDER BY sub_mood_id ASC ";
        return this.jdbcTemplate.query(SQL, SubMoodRepositoryImpl::mapRow);
    }
}

