/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.assessment.repository;

import com.infinite.focus.server.assessment.dto.AssessmentDTO;
import com.infinite.focus.server.assessment.repository.AssessmentCoreRepository;
import com.infinite.focus.server.pvstate.model.PVState;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class AssessmentCoreRepositoryImpl
implements AssessmentCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public AssessmentCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static AssessmentDTO mapRow(ResultSet rs, int i) throws SQLException {
        return AssessmentDTO.builder().assessment_id(rs.getLong("assessment_id")).student_id(rs.getLong("student_id")).standard_id(rs.getLong("standard_id")).self_awareness_id(rs.getLong("self_awareness_id")).self_awareness_score(rs.getDouble("self_awareness_score")).responsible_decision_making_id(rs.getLong("responsible_decision_making_id")).responsible_decision_making_score(rs.getDouble("responsible_decision_making_score")).self_management_id(rs.getLong("self_management_id")).self_management_score(rs.getDouble("self_management_score")).social_awareness_id(rs.getLong("social_awareness_id")).social_awareness_score(rs.getDouble("social_awareness_score")).relationship_skills_id(rs.getLong("relationship_skills_id")).relationship_skills_score(rs.getDouble("relationship_skills_score")).pv_state(PVState.valueOfOrDefault((String)rs.getString("pv_state"))).createdAt((Date)rs.getTimestamp("created_at")).updatedAt((Date)rs.getTimestamp("updated_at")).build();
    }

    public List<AssessmentDTO> findByStudentIdAndBetweenFromDateAndToDate(long student_id, Date from_date, Date to_date) {
        String SQL = "SELECT * FROM assessment a WHERE a.student_id = ? AND created_at BETWEEN ? AND ? ORDER BY a.assessment_id DESC";
        try {
            List assessmentDTOS = this.jdbcTemplate.query(SQL, AssessmentCoreRepositoryImpl::mapRow, new Object[]{student_id, new Timestamp(from_date.getTime()), new Timestamp(to_date.getTime())});
            return assessmentDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

