/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.category.service;

import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.category.repository.CategoryRepository;
import com.infinite.focus.server.category.service.CategoryService;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class CategoryServiceImpl
implements CategoryService {
    @Autowired
    private CategoryRepository categoryRepository;

    public CategoryDTO getCategoryById(long category_id) {
        return this.categoryRepository.findById(category_id);
    }

    public Page<CategoryDTO> getCategories(String category_name, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        return this.categoryRepository.findPageByCategoryName(category_name, (Pageable)paging);
    }

    public void deleteById(long category_id) {
        this.categoryRepository.deleteById(category_id);
    }

    public CategoryDTO create(String category_name, String category_name_es, int status) {
        return this.categoryRepository.create(category_name, category_name_es, status);
    }

    public CategoryDTO update(long category_id, String category_name, String category_name_es, int status) {
        return this.categoryRepository.update(category_id, category_name, category_name_es, status);
    }

    public CategoryDTO getById(long id) {
        return this.categoryRepository.findById(id);
    }

    public List<CategoryDTO> getAll() {
        return this.categoryRepository.findAll();
    }

    public List<CategoryDTO> getCategoriesByIds(Set<Long> ids) {
        return this.categoryRepository.findByIds(ids);
    }
}

