/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.service.section;

import com.infinite.focus.server.clever.model.CleverSection;
import com.infinite.focus.server.clever.model.CleverSectionWrapper;
import com.infinite.focus.server.clever.response.GetCleverSectionsResponse;
import com.infinite.focus.server.clever.service.section.CleverSectionApiService;
import com.infinite.focus.server.clever.service.section.CleverSectionService;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Service
public class CleverSectionServiceImpl
implements CleverSectionService {
    private CleverSectionApiService service;

    public CleverSectionServiceImpl() {
        OkHttpClient OClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.clever.com/v3.0/").client(OClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.service = (CleverSectionApiService)retrofit.create(CleverSectionApiService.class);
    }

    public Set<CleverSection> getCleverSections(String token) {
        try {
            Call getAllSectionsResponseCall = this.service.getCleverSections("Bearer " + token);
            Response response = getAllSectionsResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverSectionsResponse)response.body()).getData() != null) {
                return ((GetCleverSectionsResponse)response.body()).getData().stream().map(CleverSectionWrapper::getData).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public LinkedHashSet<CleverSection> getCleverSectionsByUser(String access_token, String user_id, Integer limit, String starting_after, String ending_before) {
        try {
            Call getCleverSectionsResponseCall = this.service.getCleverSectionsByUser("Bearer " + access_token, user_id, limit, starting_after, ending_before);
            Response response = getCleverSectionsResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverSectionsResponse)response.body()).getData() != null) {
                return ((GetCleverSectionsResponse)response.body()).getData().stream().map(CleverSectionWrapper::getData).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new LinkedHashSet<CleverSection>();
    }
}

