/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentpushnotification.service;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.fcm.dto.PushNotificationDTO;
import com.infinite.focus.server.fcm.request.SendFirebasePushNotificationRequest;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.model.NotificationType;
import com.infinite.focus.server.notification.request.SetNotificationViewedRequest;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.studentpushnotification.entity.StudentPushNotification;
import com.infinite.focus.server.studentpushnotification.repository.StudentPushNotificationRepository;
import com.infinite.focus.server.studentpushnotification.request.BadgeReceivedNotification;
import com.infinite.focus.server.studentpushnotification.request.StreakReceivedNotification;
import com.infinite.focus.server.studentpushnotification.request.WOWPostUnacceptableContentNotification;
import com.infinite.focus.server.studentpushnotification.request.WOWPostUnacceptableContentNotifications;
import com.infinite.focus.server.studentpushnotification.request.WOWReactionNotification;
import com.infinite.focus.server.studentpushnotification.service.StudentPushNotificationService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.wallpost.model.Reaction;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class StudentPushNotificationServiceImpl
implements StudentPushNotificationService {
    private final MessageService messageService;
    private final ConfigurationRepository configurationRepository;
    private final StudentPushNotificationRepository studentPushNotificationRepository;
    private final RealTimeMessageService realTimeMessageService;
    private final RestComponent restComponent;

    public StudentPushNotificationServiceImpl(MessageService messageService, ConfigurationRepository configurationRepository, StudentPushNotificationRepository studentPushNotificationRepository, RealTimeMessageService realTimeMessageService, RestComponent restComponent) {
        this.messageService = messageService;
        this.configurationRepository = configurationRepository;
        this.studentPushNotificationRepository = studentPushNotificationRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.restComponent = restComponent;
    }

    public void wowPostNotification(long student_id, long account_id, String language) {
        if (this.studentPushNotificationRepository.findByStudentIdAndNotificationType(Long.valueOf(student_id), NotificationType.WOW_POST.toString()) == null) {
            StudentPushNotification studentPushNotification = new StudentPushNotification();
            studentPushNotification.setStudent_id(student_id);
            studentPushNotification.setNotification_type(NotificationType.WOW_POST);
            studentPushNotification.setTitle(this.configurationRepository.getConfiguration().getWow_post_title());
            studentPushNotification.setMessage(this.configurationRepository.getConfiguration().getWow_post_message());
            studentPushNotification.setTitle_es(this.configurationRepository.getConfiguration().getWow_post_title_es());
            studentPushNotification.setMessage_es(this.configurationRepository.getConfiguration().getWow_post_message_es());
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
            ArrayList<Long> student_ids = new ArrayList<Long>();
            student_ids.add(student_id);
            this.restComponent.setNewNotificationsForStudent(student_ids, true);
            this.realTimeMessageService.sendTitleAndMessage(student_id, studentPushNotification.getTitle(), studentPushNotification.getFormat_text() + " " + studentPushNotification.getMessage());
            try {
                ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
                PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).notification_id(studentPushNotification.getStudent_push_notification_id()).account_id(account_id).format_text(studentPushNotification.getFormat_text()).title(studentPushNotification.getTitle()).title_es(studentPushNotification.getTitle_es()).message(studentPushNotification.getMessage()).message_es(studentPushNotification.getMessage_es()).screen_type(studentPushNotification.getNotification_type()).language(language).createdAt(studentPushNotification.getCreatedAt()).build();
                pushNotificationDTOS.add(pushNotificationDTO);
                this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isThereNewNotificationAvailable(String approvedDate, long student_id) {
        StudentPushNotification studentPushNotification = this.studentPushNotificationRepository.findTopFirstGreaterThanEqualToStudentApproveDateAndStudentId(approvedDate, Long.valueOf(student_id));
        return !studentPushNotification.isViewed();
    }

    public void badgeReceived(List<BadgeReceivedNotification> badgeReceivedNotifications) {
        ArrayList<StudentPushNotification> studentPushNotifications = new ArrayList<StudentPushNotification>();
        ArrayList<Long> student_ids = new ArrayList<Long>();
        ArrayList<Long> student_ids_demo = new ArrayList<Long>();
        for (BadgeReceivedNotification badgeReceivedNotification : badgeReceivedNotifications) {
            StudentPushNotification studentPushNotification = new StudentPushNotification();
            studentPushNotification.setStudent_id(badgeReceivedNotification.getStudent_id());
            studentPushNotification.setNotification_type(NotificationType.BADGE_RECEIVED);
            studentPushNotification.setTitle("Badge Received");
            studentPushNotification.setTitle_es("Insignia Recibida");
            studentPushNotification.setMessage("gave you a badge: " + badgeReceivedNotification.getTitle());
            studentPushNotification.setMessage_es("te dio una insignia: " + badgeReceivedNotification.getTitle_es());
            studentPushNotification.setFormat_text(badgeReceivedNotification.getFormat_text());
            studentPushNotifications.add(studentPushNotification);
            this.realTimeMessageService.sendTitleAndMessage(studentPushNotification.getStudent_id(), studentPushNotification.getTitle(), studentPushNotification.getFormat_text() + " " + studentPushNotification.getMessage());
            student_ids.add(badgeReceivedNotification.getStudent_id());
            if (!badgeReceivedNotification.isDemo()) continue;
            student_ids_demo.add(badgeReceivedNotification.getStudent_id());
        }
        this.studentPushNotificationRepository.saveAll((Iterable)studentPushNotifications.stream().filter(s -> !student_ids_demo.contains(s.getStudent_id())).collect(Collectors.toList()));
        this.restComponent.setNewNotificationsForStudent(student_ids, true);
        ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
        for (StudentPushNotification studentPushNotification : studentPushNotifications) {
            try {
                this.realTimeMessageService.sendTitleAndMessage(studentPushNotification.getStudent_id(), studentPushNotification.getTitle(), studentPushNotification.getFormat_text() + " " + studentPushNotification.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                BadgeReceivedNotification badgeReceivedNotification = badgeReceivedNotifications.stream().filter(b -> b.getStudent_id() == studentPushNotification.getStudent_id()).findAny().orElse(null);
                if (badgeReceivedNotification == null) continue;
                PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).notification_id(studentPushNotification.getStudent_push_notification_id()).account_id(badgeReceivedNotification.getAccount_id()).format_text(studentPushNotification.getFormat_text()).title(studentPushNotification.getTitle()).title_es(studentPushNotification.getTitle_es()).message(studentPushNotification.getMessage()).message_es(studentPushNotification.getMessage_es()).screen_type(studentPushNotification.getNotification_type()).language(badgeReceivedNotification.getLanguage()).createdAt(studentPushNotification.getCreatedAt()).build();
                pushNotificationDTOS.add(pushNotificationDTO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void streakReceived(StreakReceivedNotification streakReceivedNotification) {
        StudentPushNotification studentPushNotification = new StudentPushNotification();
        studentPushNotification.setStudent_id(streakReceivedNotification.getStudent_id());
        studentPushNotification.setNotification_type(NotificationType.STREAK_RECEIVED);
        studentPushNotification.setTitle("Streak Achieved");
        studentPushNotification.setTitle_es("Racha de logros");
        studentPushNotification.setMessage("You have achieved a new streak: " + streakReceivedNotification.getTitle());
        studentPushNotification.setMessage_es("Has conseguido una nueva racha: " + streakReceivedNotification.getTitle_es());
        if (streakReceivedNotification.isDemo()) {
            studentPushNotification.setCreatedAt(new Date());
        } else {
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
        }
        this.realTimeMessageService.sendTitleAndMessage(studentPushNotification.getStudent_id(), studentPushNotification.getTitle(), studentPushNotification.getMessage());
        ArrayList<Long> student_ids = new ArrayList<Long>();
        student_ids.add(studentPushNotification.getStudent_id());
        this.restComponent.setNewNotificationsForStudent(student_ids, true);
        try {
            ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
            PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).notification_id(studentPushNotification.getStudent_push_notification_id()).account_id(streakReceivedNotification.getAccount_id()).format_text(studentPushNotification.getFormat_text()).title(studentPushNotification.getTitle()).title_es(studentPushNotification.getTitle_es()).message(studentPushNotification.getMessage()).message_es(studentPushNotification.getMessage_es()).screen_type(studentPushNotification.getNotification_type()).language(streakReceivedNotification.getLanguage()).createdAt(studentPushNotification.getCreatedAt()).build();
            pushNotificationDTOS.add(pushNotificationDTO);
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void wowReaction(WOWReactionNotification wowReactionNotification) {
        StudentPushNotification studentPushNotification = new StudentPushNotification();
        studentPushNotification.setStudent_id(wowReactionNotification.getStudent_id());
        studentPushNotification.setNotification_type(NotificationType.WOW_REACTION);
        studentPushNotification.setTitle("Received reaction on WoW Post");
        String message = "reacted " + this.getReactionCodeByReaction(wowReactionNotification.getReaction());
        message = !AppUtils.isNullOrEmpty((String)wowReactionNotification.getText()) ? message + " on your WoW post: " + wowReactionNotification.getText() : message + " on your WoW post";
        studentPushNotification.setMessage(message);
        studentPushNotification.setTitle_es("Recibiste una reacci\u00f3n en tu publicaci\u00f3n del Muro de las Maravillas.");
        String message_es = "reaccion\u00f3 " + this.getReactionCodeByReaction(wowReactionNotification.getReaction());
        message_es = !AppUtils.isNullOrEmpty((String)wowReactionNotification.getText()) ? message_es + " en tu publicaci\u00f3n del Muro de las Maravillas: " + wowReactionNotification.getText() : message_es + " en tu publicaci\u00f3n del Muro de las Maravillas.";
        studentPushNotification.setMessage_es(message_es);
        studentPushNotification.setFormat_text(wowReactionNotification.getFormat_text());
        if (!wowReactionNotification.isDemo()) {
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
        } else {
            studentPushNotification.setCreatedAt(new Date());
        }
        this.realTimeMessageService.sendTitleAndMessage(wowReactionNotification.getStudent_id(), studentPushNotification.getTitle(), studentPushNotification.getMessage());
        ArrayList<Long> student_ids = new ArrayList<Long>();
        student_ids.add(studentPushNotification.getStudent_id());
        this.restComponent.setNewNotificationsForStudent(student_ids, true);
        try {
            ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
            PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).notification_id(studentPushNotification.getStudent_push_notification_id()).account_id(wowReactionNotification.getAccount_id()).format_text(studentPushNotification.getFormat_text()).title(studentPushNotification.getTitle()).title_es(studentPushNotification.getTitle_es()).message(studentPushNotification.getMessage()).message_es(studentPushNotification.getMessage_es()).screen_type(studentPushNotification.getNotification_type()).language(wowReactionNotification.getLanguage()).createdAt(studentPushNotification.getCreatedAt()).build();
            pushNotificationDTOS.add(pushNotificationDTO);
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getReactionCodeByReaction(String reactionText) {
        Reaction reaction = Reaction.valueOf((String)reactionText);
        if (reaction.equals((Object)Reaction.STAR)) {
            reactionText = "&#x2B50";
        } else if (reaction.equals((Object)Reaction.EXCITED)) {
            reactionText = "&#x1F60D";
        } else if (reaction.equals((Object)Reaction.LAUGHTER)) {
            reactionText = "&#x1F602";
        } else if (reaction.equals((Object)Reaction.THUMBS_UP)) {
            reactionText = "&#x1F44D";
        } else if (reaction.equals((Object)Reaction.CELEBRATION)) {
            reactionText = "&#x1f973";
        }
        return reactionText;
    }

    public void wowPostUnacceptableContent(WOWPostUnacceptableContentNotification wowPostUnacceptableContentNotification) {
        StudentPushNotification studentPushNotification = new StudentPushNotification();
        studentPushNotification.setStudent_id(wowPostUnacceptableContentNotification.getStudent_id());
        studentPushNotification.setNotification_type(NotificationType.WOW_POST_UNACCEPTABLE_CONTENT);
        studentPushNotification.setTitle(this.messageService.getMessage().getUnacceptable_content_title());
        studentPushNotification.setTitle_es(this.messageService.getMessage().getUnacceptable_content_title_es());
        studentPushNotification.setMessage(this.messageService.getMessage().getUnacceptable_content_message());
        studentPushNotification.setMessage_es(this.messageService.getMessage().getUnacceptable_content_message_es());
        if (!wowPostUnacceptableContentNotification.isDemo()) {
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
        } else {
            studentPushNotification.setCreatedAt(new Date());
        }
        this.realTimeMessageService.sendTitleAndMessage(wowPostUnacceptableContentNotification.getStudent_id(), studentPushNotification.getTitle(), studentPushNotification.getMessage());
        ArrayList<Long> student_ids = new ArrayList<Long>();
        student_ids.add(wowPostUnacceptableContentNotification.getStudent_id());
        this.restComponent.setNewNotificationsForStudent(student_ids, true);
        try {
            ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
            PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).notification_id(studentPushNotification.getStudent_push_notification_id()).account_id(wowPostUnacceptableContentNotification.getAccount_id()).format_text(studentPushNotification.getFormat_text()).title(studentPushNotification.getTitle()).title_es(studentPushNotification.getTitle_es()).message(studentPushNotification.getMessage()).message_es(studentPushNotification.getMessage_es()).screen_type(studentPushNotification.getNotification_type()).language(wowPostUnacceptableContentNotification.getLanguage()).createdAt(studentPushNotification.getCreatedAt()).build();
            pushNotificationDTOS.add(pushNotificationDTO);
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void wowPostUnacceptableContents(WOWPostUnacceptableContentNotifications wowPostUnacceptableContentNotifications) {
        List studentsByIds = this.restComponent.getStudentsByIds(new ArrayList(wowPostUnacceptableContentNotifications.getStudent_ids()));
        ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
        ArrayList<StudentPushNotification> studentPushNotifications = new ArrayList<StudentPushNotification>();
        ArrayList<Long> student_ids_demo = new ArrayList<Long>();
        for (Object studentCoreDTO : studentsByIds) {
            if (studentCoreDTO.isDemo()) {
                student_ids_demo.add(studentCoreDTO.getStudent_id());
            }
            StudentPushNotification studentPushNotification = new StudentPushNotification();
            studentPushNotification.setStudent_id(studentCoreDTO.getStudent_id());
            studentPushNotification.setNotification_type(NotificationType.WOW_POST_UNACCEPTABLE_CONTENT);
            studentPushNotification.setTitle(this.messageService.getMessage().getUnacceptable_contents_title());
            studentPushNotification.setTitle_es(this.messageService.getMessage().getUnacceptable_contents_title_es());
            studentPushNotification.setMessage(this.messageService.getMessage().getUnacceptable_contents_message());
            studentPushNotification.setMessage_es(this.messageService.getMessage().getUnacceptable_contents_message_es());
            studentPushNotifications.add(studentPushNotification);
        }
        this.studentPushNotificationRepository.saveAll((Iterable)studentPushNotifications.stream().filter(s -> !student_ids_demo.contains(s.getStudent_id())).collect(Collectors.toList()));
        if (!AppUtils.isNullOrEmpty((Set)wowPostUnacceptableContentNotifications.getStudent_ids())) {
            ArrayList student_ids = new ArrayList(wowPostUnacceptableContentNotifications.getStudent_ids());
            this.restComponent.setNewNotificationsForStudent(student_ids, true);
            for (StudentPushNotification studentPushNotification : studentPushNotifications) {
                StudentCoreDTO studentCoreDTO = studentsByIds.stream().filter(s -> s.getStudent_id() == studentPushNotification.getStudent_id()).findAny().orElse(null);
                if (studentCoreDTO == null) continue;
                try {
                    this.realTimeMessageService.sendTitleAndMessage(studentCoreDTO.getStudent_id(), studentPushNotification.getTitle(), studentPushNotification.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).notification_id(studentPushNotification.getStudent_push_notification_id()).account_id(studentCoreDTO.getAccount_id()).format_text(studentPushNotification.getFormat_text()).title(studentPushNotification.getTitle()).title_es(studentPushNotification.getTitle_es()).message(studentPushNotification.getMessage()).message_es(studentPushNotification.getMessage_es()).screen_type(studentPushNotification.getNotification_type()).language(studentCoreDTO.getLanguage()).createdAt(new Date()).build();
                    pushNotificationDTOS.add(pushNotificationDTO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setNotificationViewed(SetNotificationViewedRequest request) {
        StudentPushNotification studentPushNotification = this.studentPushNotificationRepository.findById(request.getNotification_id());
        studentPushNotification.setViewed(true);
        this.studentPushNotificationRepository.save((Object)studentPushNotification);
    }
}

