/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.avatar.repository;

import com.infinite.focus.server.avatar.dto.AvatarDTO;
import com.infinite.focus.server.avatar.repository.AvatarCoreRepository;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class AvatarCoreRepositoryImpl
implements AvatarCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public AvatarCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static AvatarDTO mapRow(ResultSet rs, int i) throws SQLException {
        return AvatarDTO.builder().avatar_id(rs.getLong("avatar_id")).avatar_name(rs.getString("avatar_name")).preview_url(rs.getString("preview_url")).sort_index(rs.getInt("sort_index")).build();
    }

    public List<AvatarDTO> findAll() {
        String SQL = "SELECT * FROM avatar a ORDER BY a.avatar_id ASC ";
        try {
            return this.jdbcTemplate.query(SQL, AvatarCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<AvatarDTO>();
        }
    }

    public AvatarDTO findById(long avatar_id) {
        String SQL = "SELECT * FROM avatar a WHERE a.avatar_id = ? ";
        try {
            return (AvatarDTO)this.jdbcTemplate.queryForObject(SQL, AvatarCoreRepositoryImpl::mapRow, new Object[]{avatar_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

