/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.service.district;

import com.infinite.focus.server.clever.model.AccessToken;
import com.infinite.focus.server.clever.model.CleverDistrict;
import com.infinite.focus.server.clever.service.CleverService;
import com.infinite.focus.server.clever.service.district.CleverDistrictService;
import com.infinite.focus.server.clever.service.district.CleverDistrictSyncService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.repository.DistrictRepository;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Transactional
@Service
public class CleverDistrictSyncServiceImpl
implements CleverDistrictSyncService {
    private static final Logger log = LoggerFactory.getLogger(CleverDistrictSyncServiceImpl.class);
    private final DistrictRepository districtRepository;
    private final MessageService messageService;
    private final CleverService cleverService;
    private final CleverDistrictService cleverDistrictService;
    private final RealTimeMessageService realTimeMessageService;

    public CleverDistrictSyncServiceImpl(DistrictRepository districtRepository, MessageService messageService, CleverService cleverService, CleverDistrictService cleverDistrictService, RealTimeMessageService realTimeMessageService) {
        this.districtRepository = districtRepository;
        this.messageService = messageService;
        this.cleverService = cleverService;
        this.cleverDistrictService = cleverDistrictService;
        this.realTimeMessageService = realTimeMessageService;
    }

    @Async
    public void syncDistrict(long district_id) {
        this.syncDistrictNonAsync(district_id);
    }

    public void syncDistrictNonAsync(long district_id) {
        log.info("Starting Thread District {} - Processing District {}", (Object)Thread.currentThread().getName(), (Object)district_id);
        District district = this.districtRepository.findByDistrictId(Long.valueOf(district_id));
        if (district == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("district.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("district.has.no.clever.access"));
        }
        AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
        CleverDistrict cleverDistrict = this.cleverDistrictService.getDistrictById(accessToken.getAccess_token(), district.getClever_id());
        district.setDistrict_name(cleverDistrict.getName());
        district.setSync_progressed(false);
        this.districtRepository.save((Object)district);
        String message = this.messageService.getMessage("sync.completed.for.the.district");
        String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + message + "\"}";
        this.realTimeMessageService.sendMessage(district.getDistrict_id(), json_message);
        log.info("Exiting Thread - Processing District {} completed", (Object)district.getDistrict_id());
    }
}

