/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.askforhelp.service;

import com.infinite.focus.server.askforhelp.dto.AskForHelpDTO;
import com.infinite.focus.server.askforhelp.repository.AskForHelpRepository;
import com.infinite.focus.server.askforhelp.service.AskForHelpService;
import com.infinite.focus.server.askforhelp.wrapper.AskForHelpWrapper;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.sosrequest.dto.SOSRequestDTO;
import com.infinite.focus.server.sostime.dto.SOSTimeDTO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AskForHelpServiceImpl
implements AskForHelpService {
    @Autowired
    private AskForHelpRepository askForHelpRepository;
    @Autowired
    private RestComponent restComponent;

    public AskForHelpDTO create(long student_id, long mood_update_id) {
        return this.askForHelpRepository.create(student_id, mood_update_id);
    }

    public List<AskForHelpDTO> getAskForHelpByStudentId(long student_id) {
        return this.askForHelpRepository.findByStudentIdOrderByCreatedAtDESC(student_id);
    }

    public AskForHelpDTO setSOSRequestId(long ask_for_help_id, long sos_request_id) {
        return this.askForHelpRepository.setSOSRequestId(ask_for_help_id, sos_request_id);
    }

    public AskForHelpDTO getAskForHelpById(long ask_for_help_id) {
        return this.askForHelpRepository.findById(ask_for_help_id);
    }

    public AskForHelpDTO getPendingAskForHelpByStudentId(long student_id) {
        List askForHelpDTOS = this.getAskForHelpByStudentId(student_id);
        for (AskForHelpDTO askForHelpDTO : askForHelpDTOS) {
            SOSRequestDTO sosRequestDTO = this.restComponent.getSOSRequestByAskForHelpId(askForHelpDTO.getAsk_for_help_id());
            if (sosRequestDTO != null) continue;
            return askForHelpDTO;
        }
        return null;
    }

    public AskForHelpWrapper getByStudentIdAndSchoolId(long student_id, long school_id) {
        long activeSOSQuestionCount = this.restComponent.getActiveSOSQuestionCount();
        SOSTimeDTO sosTimeDTO = this.restComponent.getSOSTimeBySchoolId(school_id);
        boolean show_ask_for_help = activeSOSQuestionCount > 0L && sosTimeDTO != null && sosTimeDTO.getFrom_time().before(new Date()) && sosTimeDTO.getTo_time().after(new Date());
        return AskForHelpWrapper.builder().show_ask_for_help(show_ask_for_help).ask_for_help(show_ask_for_help ? this.getPendingAskForHelpByStudentId(student_id) : null).build();
    }
}

