/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.district.repository;

import com.infinite.focus.server.district.dto.DistrictDTO;
import com.infinite.focus.server.district.repository.DistrictCoreRepository;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DistrictCoreRepositoryImpl
implements DistrictCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public DistrictCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static DistrictDTO mapRow(ResultSet rs, int i) throws SQLException {
        String focus_on = rs.getString("focus_on");
        return DistrictDTO.builder().district_id(rs.getLong("district_id")).account_id(rs.getLong("account_id")).city(rs.getString("city")).district_name(rs.getString("district_name")).state(rs.getString("state")).registration_code(rs.getString("registration_code")).createdAt((Date)rs.getTimestamp("created_at")).license_key(rs.getString("license_key")).licence_key_expiry_date((Date)rs.getTimestamp("licence_key_expiry_date")).licence_key_added_date((Date)rs.getTimestamp("licence_key_added_date")).active(rs.getBoolean("active")).focus_on(!AppUtils.isNullOrEmpty((String)focus_on) ? FocusOn.valueOf((String)focus_on) : null).deleted(rs.getBoolean("deleted")).number_of_youth(rs.getLong("number_of_youth")).clever_id(rs.getString("clever_id")).sync_progressed(rs.getBoolean("sync_progressed")).language(rs.getString("language")).build();
    }

    public List<DistrictDTO> findAll() {
        String SQL = "SELECT * FROM district d JOIN account a ON d.account_id = a.account_id WHERE a.username IS NOT NULL AND a.username != '' ORDER BY d.district_id ASC ";
        try {
            return this.jdbcTemplate.query(SQL, DistrictCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public DistrictDTO findById(long district_id) {
        String SQL = "SELECT * FROM district d WHERE d.district_id = ? ";
        try {
            return (DistrictDTO)this.jdbcTemplate.queryForObject(SQL, DistrictCoreRepositoryImpl::mapRow, new Object[]{district_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<DistrictDTO> findAllFromClever() {
        String SQL = "SELECT * FROM district d JOIN account a ON d.account_id = a.account_id WHERE a.username IS NOT NULL AND a.username != '' AND d.clever_id IS NOT NULL AND d.clever_id != '' ORDER BY d.district_id ASC ";
        try {
            return this.jdbcTemplate.query(SQL, DistrictCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public List<Long> findAllIdsFromClever() {
        String SQL = "SELECT DISTINCT(d.district_id) FROM district d JOIN account a ON d.account_id = a.account_id WHERE a.username IS NOT NULL AND a.username != '' AND d.clever_id IS NOT NULL AND d.clever_id != '' ORDER BY d.district_id ASC ";
        try {
            return this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong("district_id"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

