/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.notification.repository;

import com.infinite.focus.server.home.request.GetNotificationsRequest;
import com.infinite.focus.server.notification.dto.NotificationDTO;
import com.infinite.focus.server.notification.repository.NotificationCoreRepository;
import com.infinite.focus.server.notification.repository.mapper.NotificationRowMapper;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class NotificationCoreRepositoryImpl
implements NotificationCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public NotificationCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Page<NotificationDTO> getPageByInstructorId(GetNotificationsRequest request) {
        StringBuilder sqlQuery = new StringBuilder("SELECT * FROM notification WHERE instructor_id = ?");
        ArrayList<Long> params = new ArrayList<Long>();
        params.add(request.getInstructor_id());
        this.appendDynamicQueryParts(sqlQuery, params, request);
        String sortBy = request.getSortBy();
        String orderBy = request.getOrderBy().equals("desc") ? "DESC" : "ASC";
        sqlQuery.append(" ORDER BY ").append(sortBy).append(" ").append(orderBy);
        int offset = request.getPageNo() * request.getPageSize();
        sqlQuery.append(" LIMIT ").append(request.getPageSize()).append(" OFFSET ").append(offset);
        List notifications = this.jdbcTemplate.query(sqlQuery.toString(), params.toArray(), (RowMapper)new NotificationRowMapper());
        StringBuilder countQuery = new StringBuilder("SELECT COUNT(*) FROM notification WHERE instructor_id = ?");
        ArrayList<Long> countParams = new ArrayList<Long>();
        countParams.add(request.getInstructor_id());
        this.appendDynamicQueryParts(countQuery, countParams, request);
        Long total = (Long)this.jdbcTemplate.queryForObject(countQuery.toString(), countParams.toArray(), Long.class);
        PageImpl pagedResult = new PageImpl(notifications, (Pageable)PageRequest.of((int)request.getPageNo(), (int)request.getPageSize()), total.longValue());
        this.batchUpdateViewedInstructor(pagedResult.getContent());
        return pagedResult;
    }

    private void appendDynamicQueryParts(StringBuilder query, List<Object> params, GetNotificationsRequest request) {
        if (AppUtils.isNotNullOrEmpty((List)request.getStudentIds())) {
            query.append(" AND student_id IN (").append(this.createInClause(request.getStudentIds().size())).append(")");
            params.addAll(request.getStudentIds());
        }
        if (AppUtils.isNotNullOrEmpty((Set)request.getNotification_types())) {
            query.append(" AND notification_type IN (").append(this.createInClause(request.getNotification_types().size())).append(")");
            params.addAll(request.getNotification_types());
        }
        if (request.getViewed() != null) {
            query.append(" AND viewed_instructor = ?");
            params.add(request.getViewed());
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            query.append(" AND created_at BETWEEN ? AND ?");
            params.add(request.getFromDate());
            params.add(request.getToDate());
        }
    }

    private String createInClause(int size) {
        return String.join((CharSequence)",", Collections.nCopies(size, "?"));
    }

    /*
     * Exception decompiling
     */
    public void batchUpdateViewedInstructor(List<NotificationDTO> notifications) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getCountForNotViewedByInstructorId(Long instructorId, boolean viewed) {
        String sql = "SELECT COUNT(*) FROM notification WHERE instructor_id = ? AND viewed_instructor = ?";
        return (Long)this.jdbcTemplate.queryForObject(sql, new Object[]{instructorId, viewed}, Long.class);
    }
}

