/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service.content;

import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.postcontent.dto.PostContentDTO;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.studentstreak.helper.StreakHelper;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.content.StreakContentService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class StreakContentServiceImpl
implements StreakContentService {
    private final StreakRepository streakRepository;
    private final StudentStreakRepository studentStreakRepository;
    private final StreakHelper streakHelper;
    private final RestComponent restComponent;

    public StreakContentServiceImpl(StreakRepository streakRepository, StudentStreakRepository studentStreakRepository, StreakHelper streakHelper, RestComponent restComponent) {
        this.streakRepository = streakRepository;
        this.studentStreakRepository = studentStreakRepository;
        this.streakHelper = streakHelper;
        this.restComponent = restComponent;
    }

    public StreakDTO addStreakSELCurriculumArticle(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.SEL_CURRICULUM_ARTICLE);
    }

    public StreakDTO addStreakEnergizingExercises(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.ENERGIZING_EXERCISES);
    }

    public StreakDTO addStreakCopingCues(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.COPING_CUES);
    }

    public StreakDTO addStreakMindfulStretches(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.MINDFUL_STRETCHES);
    }

    public StreakDTO addStreakMindfulnessVideos(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.MINDFULNESS_VIDEOS);
    }

    public StreakDTO addStreakGrowthMindsets(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.GROWTH_MINDSETS);
    }

    private StreakDTO addStreakByStreakType(long studentId, List<Activity> activities, StreakType streakType) {
        if (AppUtils.isNullOrEmpty(activities)) {
            return null;
        }
        Set entityIds = activities.stream().map(Activity::getEntity_id).filter(postId -> postId > 0L).collect(Collectors.toSet());
        if (AppUtils.isNullOrEmpty(entityIds)) {
            return null;
        }
        Set postContentList = this.restComponent.getPostContentListByPostIds(entityIds);
        if (AppUtils.isNullOrEmpty((Set)postContentList)) {
            return null;
        }
        Set contentIds = postContentList.stream().map(PostContentDTO::getContent_id).collect(Collectors.toSet());
        Set contents = this.restComponent.getContentsByIds(contentIds);
        if (AppUtils.isNullOrEmpty((Set)contents)) {
            return null;
        }
        Set validPostIds = postContentList.stream().filter(postContent -> contents.stream().anyMatch(content -> content.getContent_id() == postContent.getContent_id() && content.getStreak_type().equals((Object)streakType))).map(PostContentDTO::getPost_id).collect(Collectors.toSet());
        if (AppUtils.isNullOrEmpty(validPostIds)) {
            return null;
        }
        List streaks = this.streakRepository.findByStreakType(streakType.name());
        return streaks.stream().filter(streak -> streak.getOccurrence() == validPostIds.size()).filter(streak -> this.studentStreakRepository.findByStudentIdAndStreakId(Long.valueOf(studentId), Long.valueOf(streak.getStreak_id())) == null).findFirst().map(streak -> this.streakHelper.saveStudentStreak(studentId, streak)).orElse(null);
    }
}

