/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.postmood.controller;

import com.infinite.focus.server.postmood.dto.PostMoodDTO;
import com.infinite.focus.server.postmood.request.CreatePostMoodRequest;
import com.infinite.focus.server.postmood.request.GetPostMoodListByPostIdsRequest;
import com.infinite.focus.server.postmood.service.PostMoodService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/post-mood"})
public class PostMoodController {
    @Autowired
    private PostMoodService postMoodService;

    @PostMapping(value={"/create"})
    public ResponseEntity<List<PostMoodDTO>> create(@RequestBody CreatePostMoodRequest request) {
        return new ResponseEntity((Object)this.postMoodService.create(request.getPost_id(), request.getMood_ids()), HttpStatus.CREATED);
    }

    @PostMapping(value={"/get-post-ids-by-mood-ids"})
    public ResponseEntity<List<Long>> getPostIdsByMoodIds(@RequestBody CreatePostMoodRequest request) {
        return new ResponseEntity((Object)this.postMoodService.getPostIdsByMoodIds(request.getMood_ids()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-post-mood-list-by-post-ids"})
    public ResponseEntity<List<PostMoodDTO>> getPostMoodListByPostIds(@RequestBody GetPostMoodListByPostIdsRequest request) {
        return new ResponseEntity((Object)this.postMoodService.getPostMoodListByPostIds(request.getPost_ids()), HttpStatus.OK);
    }
}

