/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.askforhelp.service;

import com.infinite.focus.server.askforhelp.dto.AskForHelpDTO;
import com.infinite.focus.server.askforhelp.repository.AskForHelpRepository;
import com.infinite.focus.server.askforhelp.service.AskForHelpService;
import com.infinite.focus.server.askforhelp.wrapper.AskForHelpEventWrapper;
import com.infinite.focus.server.askforhelp.wrapper.AskForHelpWrapper;
import com.infinite.focus.server.configuration.entity.Configuration;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.sosrequest.dto.SOSRequestDTO;
import com.infinite.focus.server.sostime.dto.SOSTimeDTO;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.utils.AppUtils;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AskForHelpServiceImpl
implements AskForHelpService {
    private final AskForHelpRepository askForHelpRepository;
    private final RestComponent restComponent;
    private final ConfigurationService configurationService;
    private final MessageService messageService;

    public AskForHelpServiceImpl(AskForHelpRepository askForHelpRepository, RestComponent restComponent, ConfigurationService configurationService, MessageService messageService) {
        this.askForHelpRepository = askForHelpRepository;
        this.restComponent = restComponent;
        this.configurationService = configurationService;
        this.messageService = messageService;
    }

    public AskForHelpDTO create(long student_id, long mood_update_id) {
        return this.askForHelpRepository.create(student_id, mood_update_id);
    }

    public List<AskForHelpDTO> getAskForHelpByStudentId(long student_id) {
        return this.askForHelpRepository.findByStudentIdOrderByCreatedAtDESC(student_id);
    }

    public AskForHelpDTO setSOSRequestId(long ask_for_help_id, long sos_request_id) {
        return this.askForHelpRepository.setSOSRequestId(ask_for_help_id, sos_request_id);
    }

    public AskForHelpDTO getAskForHelpById(long ask_for_help_id) {
        return this.askForHelpRepository.findById(ask_for_help_id);
    }

    public AskForHelpDTO getPendingAskForHelpByStudentId(long student_id) {
        List askForHelpDTOS = this.getAskForHelpByStudentId(student_id);
        for (AskForHelpDTO askForHelpDTO : askForHelpDTOS) {
            SOSRequestDTO sosRequestDTO = this.restComponent.getSOSRequestByAskForHelpId(askForHelpDTO.getAsk_for_help_id());
            if (sosRequestDTO != null) continue;
            return askForHelpDTO;
        }
        return null;
    }

    public AskForHelpWrapper getByStudentIdAndSchoolId(long student_id, long school_id) {
        long activeSOSQuestionCount = this.restComponent.getActiveSOSQuestionCount();
        SOSTimeDTO sosTimeDTO = this.restComponent.getSOSTimeBySchoolId(school_id);
        boolean show_ask_for_help = activeSOSQuestionCount > 0L && sosTimeDTO != null && sosTimeDTO.getFrom_time().before(new Date()) && sosTimeDTO.getTo_time().after(new Date());
        return AskForHelpWrapper.builder().show_ask_for_help(show_ask_for_help).ask_for_help(show_ask_for_help ? this.getPendingAskForHelpByStudentId(student_id) : null).build();
    }

    public AskForHelpEventWrapper checkByStudentId(long student_id) {
        StudentCoreDTO student = this.restComponent.getStudentByStudentId(student_id);
        long activeSOSQuestionCount = this.restComponent.getActiveSOSQuestionCount();
        if (activeSOSQuestionCount <= 0L) {
            return null;
        }
        SOSTimeDTO sosTimeDTO = this.restComponent.getSOSTimeBySchoolId(student.getSchool_id());
        if (!(sosTimeDTO == null || sosTimeDTO.getFrom_time().before(new Date()) && sosTimeDTO.getTo_time().after(new Date()))) {
            return null;
        }
        List askForHelpMoods = this.restComponent.getAskForHelpMoods();
        List lastThreeMoodsByStudentId = this.restComponent.getLastThreeMoodsByStudentId(student_id);
        if (AppUtils.isNullOrEmpty((List)lastThreeMoodsByStudentId) || lastThreeMoodsByStudentId.size() != 3) {
            return null;
        }
        List askForHelpDTOS = this.getAskForHelpByStudentId(student_id);
        long mood_update_id_last = ((MoodUpdateDTO)lastThreeMoodsByStudentId.get(2)).getMood_update_id();
        if (!AppUtils.isNullOrEmpty((List)askForHelpDTOS) && ((AskForHelpDTO)askForHelpDTOS.get(0)).getMood_update_id() >= mood_update_id_last) {
            return null;
        }
        for (MoodUpdateDTO moodUpdateDTO : lastThreeMoodsByStudentId) {
            boolean matched = askForHelpMoods.stream().anyMatch(moodDTO -> moodUpdateDTO.getMood_id() == moodDTO.getMood_id());
            if (matched) continue;
            return null;
        }
        Configuration configuration = this.configurationService.getConfiguration();
        return AskForHelpEventWrapper.builder().mood_update_id(((MoodUpdateDTO)lastThreeMoodsByStudentId.get(0)).getMood_update_id()).clymb_help_assistant(configuration.getClymb_help_assistant()).afh_pop_up_message(this.messageService.getMessage().getAfh_pop_up_message()).afh_pop_up_message_es(this.messageService.getMessage().getAfh_pop_up_message_es()).build();
    }
}

