/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.shortenurl.controller;

import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.shortenurl.entity.ShortenUrl;
import com.infinite.focus.server.shortenurl.request.ShortenUrlRequest;
import com.infinite.focus.server.shortenurl.response.ShortenUrlErrorResponse;
import com.infinite.focus.server.shortenurl.response.ShortenUrlResponse;
import com.infinite.focus.server.shortenurl.service.ShortenUrlService;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ShortenUrlController {
    @Autowired
    private ShortenUrlService shortenUrlService;
    @Autowired
    MessageService messageService;

    @PostMapping(value={"/generate"})
    public ResponseEntity<?> generateShortLink(@RequestBody ShortenUrlRequest shortenUrlRequest) {
        ShortenUrl urlToRet = this.shortenUrlService.generateShortLink(shortenUrlRequest);
        if (urlToRet != null) {
            ShortenUrlResponse urlResponseDto = new ShortenUrlResponse();
            urlResponseDto.setOriginalUrl(urlToRet.getOriginal_url());
            urlResponseDto.setShortLink(urlToRet.getShort_link());
            return new ResponseEntity((Object)urlResponseDto, HttpStatus.OK);
        }
        ShortenUrlErrorResponse urlErrorResponseDto = new ShortenUrlErrorResponse();
        urlErrorResponseDto.setStatus("404");
        urlErrorResponseDto.setError(this.messageService.getMessage("there.was.an.error.processing.your.request.please.try.again"));
        return new ResponseEntity((Object)urlErrorResponseDto, HttpStatus.OK);
    }

    @GetMapping(value={"/{shortLink}"})
    public ResponseEntity<?> redirectToOriginalUrl(@PathVariable String shortLink, HttpServletResponse response) throws IOException {
        if (StringUtils.isEmpty((CharSequence)shortLink)) {
            ShortenUrlErrorResponse urlErrorResponseDto = new ShortenUrlErrorResponse();
            urlErrorResponseDto.setError(this.messageService.getMessage("invalid.url"));
            urlErrorResponseDto.setStatus("400");
            return new ResponseEntity((Object)urlErrorResponseDto, HttpStatus.OK);
        }
        ShortenUrl urlToRet = this.shortenUrlService.getEncodedUrl(shortLink);
        if (urlToRet == null) {
            ShortenUrlErrorResponse urlErrorResponseDto = new ShortenUrlErrorResponse();
            urlErrorResponseDto.setError(this.messageService.getMessage("url.does.not.exist.or.it.might.have.expired"));
            urlErrorResponseDto.setStatus("400");
            return new ResponseEntity((Object)urlErrorResponseDto, HttpStatus.OK);
        }
        response.sendRedirect(urlToRet.getOriginal_url());
        return null;
    }
}

