/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.streak.repository;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class StreakRepositoryImpl
implements StreakRepository {
    private final JdbcTemplate jdbcTemplate;

    public StreakRepositoryImpl(JdbcTemplate jdbcTemplate, ConfigurationRepository configurationRepository) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public static StreakDTO mapRow(ResultSet rs, int i) throws SQLException {
        return StreakDTO.builder().streak_id(rs.getLong("streak_id")).title(rs.getString("title")).title_es(rs.getString("title_es")).description(rs.getString("description")).description_es(rs.getString("description_es")).image("/images/streaks/" + rs.getString("image")).image_es("/images/streaks/" + rs.getString("image_es")).occurrence(rs.getInt("occurrence")).streak_type(StreakType.valueOf((String)rs.getString("streak_type"))).received(false).createdAt((Date)rs.getTimestamp("created_at")).build();
    }

    public StreakDTO findByStreakId(long streak_id) {
        String SQL = "SELECT * FROM streak WHERE streak_id = ? ";
        try {
            return (StreakDTO)this.jdbcTemplate.queryForObject(SQL, StreakRepositoryImpl::mapRow, new Object[]{streak_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<StreakDTO> findByStreakType(String streak_type) {
        String SQL = "SELECT * FROM streak WHERE streak_type = ? ";
        try {
            return this.jdbcTemplate.query(SQL, StreakRepositoryImpl::mapRow, new Object[]{streak_type});
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StreakDTO>();
        }
    }

    public List<StreakDTO> findByStreaksOrderByStreakIdASC() {
        String SQL = "SELECT * FROM streak ORDER BY streak_id ASC";
        try {
            return this.jdbcTemplate.query(SQL, StreakRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StreakDTO>();
        }
    }
}

