/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.configuration.service;

import com.infinite.focus.server.configuration.entity.Configuration;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.configuration.wrapper.StudentConfigurationWrapper;
import com.infinite.focus.server.message.service.MessageService;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    private final ConfigurationRepository configurationRepository;
    private final MessageService messageService;

    public ConfigurationServiceImpl(ConfigurationRepository configurationRepository, MessageService messageService) {
        this.configurationRepository = configurationRepository;
        this.messageService = messageService;
    }

    public Configuration getConfiguration() {
        return this.configurationRepository.getConfiguration();
    }

    public String getStripeApiKey() {
        if (this.getConfiguration().isStripe_Live()) {
            return this.getConfiguration().getStripe_sec_key_live();
        }
        return this.getConfiguration().getStripe_sec_key_test();
    }

    public String getStripeSignature() {
        if (this.getConfiguration().isStripe_Live()) {
            return this.getConfiguration().getStripe_wh_sec_live();
        }
        return this.getConfiguration().getStripe_wh_sec_test();
    }

    public StudentConfigurationWrapper getForStudent() {
        Configuration configuration = this.configurationRepository.getConfiguration();
        return StudentConfigurationWrapper.builder().contact(configuration.getContact()).support(configuration.getSupport()).guidelines(configuration.getClymb_community_guidelines()).help_assistant(configuration.getClymb_help_assistant()).afh_pop_up_message(this.messageService.getMessage().getAfh_pop_up_message()).afh_pop_up_message_es(this.messageService.getMessage().getAfh_pop_up_message_es()).build();
    }
}

