/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sostime.controller;

import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.sostime.dto.SOSTimeDTO;
import com.infinite.focus.server.sostime.request.CreateSOSTimeForSchoolRequest;
import com.infinite.focus.server.sostime.request.GetSOSTimeForSchoolRequest;
import com.infinite.focus.server.sostime.service.SOSTimeService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/sos-time"})
public class SOSTimeController {
    @Autowired
    private AuthService authService;
    @Autowired
    private SOSTimeService sosTimeService;
    @Autowired
    private MessageService messageService;

    @PostMapping(value={"/get/for/school"})
    ResponseEntity<SOSTimeDTO> getForSchool(@RequestBody GetSOSTimeForSchoolRequest request) {
        return new ResponseEntity((Object)this.sosTimeService.getForSchool(request.getSchool_id().longValue()), HttpStatus.OK);
    }

    @PostMapping(value={"/set/for/school"})
    ResponseEntity<SOSTimeDTO> createForSchool(@RequestHeader(value="Authorization") String token, @RequestBody CreateSOSTimeForSchoolRequest request) {
        this.authService.isSchool(token);
        if (!Date.from(request.getFrom_time().toInstant()).before(Date.from(request.getTo_time().toInstant()))) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("from.time.must.be.smaller.than.to.time"));
        }
        return new ResponseEntity((Object)this.sosTimeService.setForSchool(request.getSchool_id().longValue(), request.getFrom_time(), request.getTo_time()), HttpStatus.OK);
    }
}

