/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.controller;

import com.infinite.focus.server.account.dto.AccountDTO;
import com.infinite.focus.server.account.model.AccountType;
import com.infinite.focus.server.account.wrapper.AccountDataWrapper;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.clever.model.CleverDistrict;
import com.infinite.focus.server.clever.model.CleverDistrictGraph;
import com.infinite.focus.server.clever.model.CleverInstructor;
import com.infinite.focus.server.clever.model.CleverSchool;
import com.infinite.focus.server.clever.model.CleverStudent;
import com.infinite.focus.server.clever.model.CleverUser;
import com.infinite.focus.server.clever.request.CleverCodeRequest;
import com.infinite.focus.server.clever.request.CleverInstructorAddRequest;
import com.infinite.focus.server.clever.request.CleverInstructorsRequest;
import com.infinite.focus.server.clever.request.SearchDistrictByIdRequest;
import com.infinite.focus.server.clever.request.SearchInstructorBySchoolIdAndInstructorCleverIdRequest;
import com.infinite.focus.server.clever.request.SearchSchoolByDistrictIdAndSchoolCleverIdRequest;
import com.infinite.focus.server.clever.request.SearchStudentByInstructorIdAndStudentCleverIdRequest;
import com.infinite.focus.server.clever.request.SyncDistrictRequest;
import com.infinite.focus.server.clever.request.SyncInstructorRequest;
import com.infinite.focus.server.clever.request.SyncSchoolRequest;
import com.infinite.focus.server.clever.service.data.CleverDataService;
import com.infinite.focus.server.clever.service.district.CleverDistrictSyncService;
import com.infinite.focus.server.clever.service.school.CleverSchoolSyncService;
import com.infinite.focus.server.clever.service.student.CleverStudentService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.student.wrapper.StudentDetailWrapper;
import com.infinite.focus.server.utils.AppUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/clever"})
public class CleverController {
    private final CleverDataService cleverDataService;
    private final CleverDistrictSyncService cleverDistrictSyncService;
    private final CleverSchoolSyncService cleverSchoolSyncService;
    private final DistrictService districtService;
    private final SchoolService schoolService;
    private final AuthService authService;
    private final InstructorService instructorService;
    private final StudentService studentService;
    private final CleverStudentService cleverStudentService;
    private final MessageService messageService;
    private final JwtHelper jwtHelper;
    private final RestComponent restComponent;

    public CleverController(CleverDataService cleverDataService, CleverDistrictSyncService cleverDistrictSyncService, CleverSchoolSyncService cleverSchoolSyncService, DistrictService districtService, SchoolService schoolService, AuthService authService, InstructorService instructorService, StudentService studentService, CleverStudentService cleverStudentService, MessageService messageService, JwtHelper jwtHelper, RestComponent restComponent) {
        this.cleverDataService = cleverDataService;
        this.cleverDistrictSyncService = cleverDistrictSyncService;
        this.cleverSchoolSyncService = cleverSchoolSyncService;
        this.districtService = districtService;
        this.schoolService = schoolService;
        this.authService = authService;
        this.instructorService = instructorService;
        this.studentService = studentService;
        this.cleverStudentService = cleverStudentService;
        this.messageService = messageService;
        this.jwtHelper = jwtHelper;
        this.restComponent = restComponent;
    }

    @PostMapping(value={"/search/district"})
    public ResponseEntity<CleverDistrict> searchDistrictById(@RequestBody SearchDistrictByIdRequest request) {
        CleverDistrict cleverDistrict = this.cleverDataService.getDistrictByCleverId(request.getDistrict_clever_id());
        if (cleverDistrict == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("clever.district.is.not.found.for.clever.id") + " " + request.getDistrict_clever_id());
        }
        return new ResponseEntity((Object)cleverDistrict, HttpStatus.OK);
    }

    @PostMapping(value={"/search/school"})
    public ResponseEntity<CleverSchool> searchSchoolByDistrictIdAndSchoolCleverId(@RequestBody SearchSchoolByDistrictIdAndSchoolCleverIdRequest request) {
        CleverSchool cleverSchool = this.cleverDataService.getSchoolByDistrictIdAndSchoolCleverId(request.getDistrict_id(), request.getSchool_clever_id());
        if (cleverSchool == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("clever.school.is.not.found.for.clever.id") + " " + request.getSchool_clever_id());
        }
        return new ResponseEntity((Object)cleverSchool, HttpStatus.OK);
    }

    @PostMapping(value={"/search/instructor"})
    public ResponseEntity<CleverInstructor> searchInstructorBySchoolIdAndInstructorCleverId(@RequestBody SearchInstructorBySchoolIdAndInstructorCleverIdRequest request) {
        CleverInstructor cleverInstructor = this.cleverDataService.getInstructorBySchoolIdAndInstructorCleverId(request.getSchool_id(), request.getInstructor_clever_id());
        if (cleverInstructor == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("clever.instructor.is.not.found.for.clever.id") + " " + request.getInstructor_clever_id());
        }
        return new ResponseEntity((Object)cleverInstructor, HttpStatus.OK);
    }

    @PostMapping(value={"/search/student"})
    public ResponseEntity<CleverStudent> searchStudentByInstructorIdAndStudentCleverId(@RequestBody SearchStudentByInstructorIdAndStudentCleverIdRequest request) {
        CleverStudent cleverStudent = this.cleverDataService.getStudentByInstructorIdAndStudentCleverId(request.getInstructor_id(), request.getStudent_clever_id());
        if (cleverStudent == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("clever.student.is.not.found.for.clever.id") + " " + request.getStudent_clever_id());
        }
        return new ResponseEntity((Object)cleverStudent, HttpStatus.OK);
    }

    @PostMapping(value={"/get/district/graph"})
    public ResponseEntity<CleverDistrictGraph> getDistrictGraph(@RequestBody SearchDistrictByIdRequest request) {
        CleverDistrictGraph cleverDistrictGraph = this.cleverDataService.getDistrictGraphById(request.getDistrict_clever_id());
        if (cleverDistrictGraph == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("clever.district.is.not.found.for.clever.id") + " " + request.getDistrict_clever_id());
        }
        return new ResponseEntity((Object)cleverDistrictGraph, HttpStatus.OK);
    }

    @PostMapping(value={"/sync/district"})
    public ResponseEntity<Message> syncDistrict(@RequestBody SyncDistrictRequest request) throws InterruptedException {
        District district = this.districtService.getDistrictById(request.getDistrict_id());
        Message message = new Message();
        if (!district.isSync_progressed()) {
            this.cleverDistrictSyncService.syncDistrict(request.getDistrict_id());
            message.setMessage(this.messageService.getMessage("sync.district.is.in.progress"));
        } else {
            message.setMessage(this.messageService.getMessage("district.is.already.in.syncing.process"));
        }
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/sync/school"})
    public ResponseEntity<Message> syncSchool(@RequestBody SyncSchoolRequest request) throws InterruptedException {
        School school = this.schoolService.getSchoolById(request.getSchool_id());
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        Message message = new Message();
        if (school.isSync_progressed()) {
            System.out.println("is sync " + district.isSync_progressed());
            message.setMessage(this.messageService.getMessage("school.is.already.in.syncing.process.please.wait.for.school.to.complete.its.sync"));
        } else {
            this.cleverSchoolSyncService.syncSchool(request.getSchool_id());
            message.setMessage(this.messageService.getMessage("sync.school.is.in.progress"));
        }
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @GetMapping(value={"/sync/instructor"})
    public ResponseEntity<Message> syncInstructor(@RequestBody SyncInstructorRequest request) {
        School school = this.schoolService.getSchoolById(request.getSchool_id());
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        Message message = new Message();
        if (district.isSync_progressed()) {
            System.out.println("is sync " + district.isSync_progressed());
            message.setMessage(this.messageService.getMessage("district.is.already.in.syncing.process.please.wait.for.district.to.complete.its.sync"));
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        this.cleverDataService.SyncInstructorByCleverId(request.getSchool_id(), request.getClever_id());
        message.setMessage(this.messageService.getMessage("sync.instructor.is.in.progress"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @GetMapping(value={"/sync/student"})
    public ResponseEntity<Message> syncStudent(@RequestHeader(value="Authorization") String token) {
        Student student = this.authService.isStudent(token);
        this.cleverDataService.syncStudent(student);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("sync.student.is.in.progress"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/login-with-clever"})
    public ResponseEntity<List<AccountDataWrapper>> syncUserFromCleverCode(@RequestBody CleverCodeRequest request, @RequestHeader(value="operating_system", required=false) String operating_system, @RequestHeader(value="browser", required=false) String browser) throws IOException {
        ArrayList<AccountDataWrapper> accountDataWrappers = new ArrayList<AccountDataWrapper>();
        CleverUser cleverUser = this.cleverDataService.GetUserInfoFromCleverCode(request);
        if (cleverUser.getRoles().getStudent() != null) {
            System.out.println("Student Logged in");
            Student student = this.cleverDataService.syncStudentFromRedirectUrl(cleverUser);
            if (student == null || student.getSchool() == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
            }
            AccountDataWrapper studentAdw = this.authService.getStudentAccountLoginDataForClever(student);
            if (studentAdw != null) {
                studentAdw.setClever_token(cleverUser.getToken());
                this.studentService.setOperatingSystemAndBrowser(studentAdw.getS().getStudent_id(), operating_system, browser);
                accountDataWrappers.add(studentAdw);
                String newToken = this.jwtHelper.generateToken(student.getAccount().getUsername());
                HttpHeaders responseHeaders = new HttpHeaders();
                responseHeaders.set("AccountType", AccountType.STUDENT.toString());
                responseHeaders.set("Authorization", newToken);
                responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(student.getAccount().getUsername()));
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(accountDataWrappers);
            }
        } else if (cleverUser.getRoles().getTeacher() != null || cleverUser.getRoles().getStaff() != null) {
            System.out.println("Teacher Logged in");
            Instructor instructor = this.cleverDataService.syncInstructorFromRedirectUrl(cleverUser);
            AccountDataWrapper instructorAdw = this.authService.getInstructorAccountLoginDataForClever(instructor);
            if (instructorAdw != null) {
                instructorAdw.setClever_token(cleverUser.getToken());
                this.instructorService.setOperatingSystemAndBrowser(instructorAdw.getI().getInstructor_id(), operating_system, browser);
                accountDataWrappers.add(instructorAdw);
                String newToken = this.jwtHelper.generateToken(instructor.getAccount().getUsername());
                HttpHeaders responseHeaders = new HttpHeaders();
                responseHeaders.set("AccountType", AccountType.INSTRUCTOR.toString());
                responseHeaders.set("Authorization", newToken);
                responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(instructor.getAccount().getUsername()));
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(accountDataWrappers);
            }
        } else {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.sync.clever.school.at.the.moment.kindly.register.on.clymb.and.enter.your.clever.id.in.order.to.continue"));
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/login-with-clever-2"})
    public ResponseEntity<List<AccountDataWrapper>> loginWithClever2(@RequestBody CleverCodeRequest request, @RequestHeader(value="operating_system", required=false) String operating_system, @RequestHeader(value="browser", required=false) String browser) throws IOException {
        ArrayList<AccountDataWrapper> accountDataWrappers = new ArrayList<AccountDataWrapper>();
        CleverUser cleverUser = this.cleverDataService.GetUserInfoFromCleverCode(request);
        if (cleverUser.getRoles().getStudent() != null) {
            String clever_id = cleverUser.getId();
            StudentCoreDTO student = this.studentService.getByCleverId(clever_id);
            if (student == null || student.getSchool_id() == 0L) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
            }
            AccountDTO account = this.restComponent.getAccountById(student.getAccount_id());
            if (account != null) {
                if (AppUtils.isNullOrEmpty((String)account.getUsername()) && AppUtils.isNullOrEmpty((String)student.getClever_id())) {
                    throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("please.complete.your.profile.using.first.login.option"));
                }
                AccountDataWrapper accountDataWrapper = new AccountDataWrapper();
                accountDataWrapper.setStudent_detail(StudentDetailWrapper.builder().account(account).student(student).build());
                accountDataWrapper.setClever_token(cleverUser.getToken());
                accountDataWrappers.add(accountDataWrapper);
                String newToken = this.jwtHelper.generateToken(account.getUsername());
                HttpHeaders responseHeaders = new HttpHeaders();
                responseHeaders.set("AccountType", AccountType.STUDENT.toString());
                responseHeaders.set("Authorization", newToken);
                responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(account.getUsername()));
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(accountDataWrappers);
            }
        } else if (cleverUser.getRoles().getTeacher() != null || cleverUser.getRoles().getStaff() != null) {
            System.out.println("Teacher Logged in");
            Instructor instructor = this.cleverDataService.syncInstructorFromRedirectUrl(cleverUser);
            AccountDataWrapper instructorAdw = this.authService.getInstructorAccountLoginDataForClever(instructor);
            if (instructorAdw != null) {
                instructorAdw.setClever_token(cleverUser.getToken());
                this.instructorService.setOperatingSystemAndBrowser(instructorAdw.getI().getInstructor_id(), operating_system, browser);
                accountDataWrappers.add(instructorAdw);
                String newToken = this.jwtHelper.generateToken(instructor.getAccount().getUsername());
                HttpHeaders responseHeaders = new HttpHeaders();
                responseHeaders.set("AccountType", AccountType.INSTRUCTOR.toString());
                responseHeaders.set("Authorization", newToken);
                responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(instructor.getAccount().getUsername()));
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(accountDataWrappers);
            }
        } else {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.sync.clever.school.at.the.moment.kindly.register.on.clymb.and.enter.your.clever.id.in.order.to.continue"));
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/get-clever-instructors-by-clever-student"})
    public ResponseEntity<List<Instructor>> getAllCleverInstructorsByCleverStudent(@RequestBody CleverInstructorsRequest cleverInstructorsRequest) {
        LinkedHashSet cleverInstructorsByCleverStudent = this.cleverStudentService.getCleverInstructorsByCleverStudent(cleverInstructorsRequest.getToken(), cleverInstructorsRequest.getClever_id());
        if (AppUtils.isNullOrEmpty((LinkedHashSet)cleverInstructorsByCleverStudent)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("instructors.not.found.for.clever.student"));
        }
        ArrayList instructors = new ArrayList();
        cleverInstructorsByCleverStudent.forEach(cleverInstructor -> {
            Instructor instructor = this.instructorService.getInstructorsByCleverId(cleverInstructor.getId());
            if (instructor != null) {
                instructors.add(instructor);
            }
        });
        if (AppUtils.isNullOrEmpty(instructors)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("clever.instructors.are.not.synced.with.clymb"));
        }
        return new ResponseEntity(instructors, HttpStatus.OK);
    }

    @PostMapping(value={"/add-instructor-for-clever-student"})
    public ResponseEntity<Student> addInstructorForCleverStudent(@RequestBody CleverInstructorAddRequest cleverInstructorAddRequest) {
        Student student = this.cleverDataService.addInstructorForStudent(cleverInstructorAddRequest);
        return new ResponseEntity((Object)student, HttpStatus.OK);
    }
}

