/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.post.repository;

import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.model.PostType;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.web.server.ResponseStatusException;

@Repository
public class PostRepositoryImpl
implements PostRepository {
    private final JdbcTemplate jdbcTemplate;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public PostRepositoryImpl(JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    private static PostDTO mapRow(ResultSet rs, int i) throws SQLException {
        PostDTO postDTO = new PostDTO();
        postDTO.setPost_id(rs.getLong("post_id"));
        postDTO.setPost_type(PostType.valueOf((String)rs.getString("post_type")));
        postDTO.setPost_title(rs.getString("post_title"));
        postDTO.setPost_title_es(rs.getString("post_title_es"));
        postDTO.setPost_description(rs.getString("post_description"));
        postDTO.setPost_description_es(rs.getString("post_description_es"));
        postDTO.setPost_cover_image_url(rs.getString("post_cover_image_url"));
        postDTO.setPost_cover_image_url_es(rs.getString("post_cover_image_url_es"));
        postDTO.setPost_video_url(rs.getString("post_video_url"));
        postDTO.setPost_video_url_es(rs.getString("post_video_url_es"));
        postDTO.setPost_duration(Long.valueOf(rs.getLong("post_duration")));
        postDTO.setPost_duration_es(Long.valueOf(rs.getLong("post_duration_es")));
        postDTO.setoEmbed_html(rs.getString("o_embed_html"));
        postDTO.setoEmbed_html_es(rs.getString("o_embed_html_es"));
        postDTO.setDeleted(rs.getBoolean("deleted"));
        postDTO.setCreatedAt((Date)rs.getTimestamp("created_at"));
        postDTO.setUpdateAt((Date)rs.getTimestamp("updated_at"));
        return postDTO;
    }

    public PostDTO create(PostType post_type, String post_title, String post_title_es, String post_description, String post_description_es, String post_cover_image_url, String post_cover_image_url_es, String post_video_url, String post_video_url_es, Long post_duration, Long post_duration_es, String oEmbed_html, String oEmbed_html_es) {
        String INSERT_SQL = "INSERT INTO post (post_type, post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, post_duration, post_duration_es, o_embed_html, o_embed_html_es, deleted, created_at, updated_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO post (post_type, post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, post_duration, post_duration_es, o_embed_html, o_embed_html_es, deleted, created_at, updated_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            ps.setString(1, post_type.toString());
            ps.setString(2, post_title);
            ps.setString(3, post_title_es);
            ps.setString(4, post_description);
            ps.setString(5, post_description_es);
            ps.setString(6, post_cover_image_url);
            ps.setString(7, post_cover_image_url_es);
            ps.setString(8, post_video_url);
            ps.setString(9, post_video_url_es);
            ps.setLong(10, post_duration == null ? 0L : post_duration);
            ps.setLong(11, post_duration_es == null ? 0L : post_duration_es);
            ps.setString(12, oEmbed_html);
            ps.setString(13, oEmbed_html_es);
            ps.setBoolean(14, false);
            ps.setTimestamp(15, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(16, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int post_id = Objects.requireNonNull(holder.getKey()).intValue();
        return this.findById((long)post_id);
    }

    public PostDTO update(long post_id, PostType post_type, String post_title, String post_title_es, String post_description, String post_description_es, String post_cover_image_url, String post_cover_image_url_es, String post_video_url, String post_video_url_es, Long post_duration, Long post_duration_es, String oEmbed_html, String oEmbed_html_es) {
        String SQL = "UPDATE post SET post_type = ?, post_title = ?, post_title_es = ?, post_description = ?, post_description_es = ?, post_cover_image_url = ?, post_cover_image_url_es = ?, post_video_url = ?, post_video_url_es = ?, post_duration = ?, post_duration_es = ?, o_embed_html = ?, o_embed_html_es = ?, updated_at = ? WHERE post_id = ? ";
        int updateCount = this.jdbcTemplate.update("UPDATE post SET post_type = ?, post_title = ?, post_title_es = ?, post_description = ?, post_description_es = ?, post_cover_image_url = ?, post_cover_image_url_es = ?, post_video_url = ?, post_video_url_es = ?, post_duration = ?, post_duration_es = ?, o_embed_html = ?, o_embed_html_es = ?, updated_at = ? WHERE post_id = ? ", new Object[]{post_type.toString(), post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, post_duration == null ? 0L : post_duration, post_duration_es == null ? 0L : post_duration_es, oEmbed_html, oEmbed_html_es, Timestamp.valueOf(LocalDateTime.now()), post_id});
        if (updateCount == 1) {
            return this.findById(post_id);
        }
        throw new ResponseStatusException(HttpStatus.CONFLICT, "Not updated!!!");
    }

    public PostDTO findById(long id) {
        String SQL = "SELECT * FROM post WHERE post_id = ? ";
        try {
            PostDTO postDTO = (PostDTO)this.jdbcTemplate.queryForObject(SQL, PostRepositoryImpl::mapRow, new Object[]{id});
            return postDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<PostDTO> getAllPostByPostTypeOrderByPostId(PostType postType, String orderBy) {
        String SQL = "SELECT * FROM post WHERE deleted = 0 AND post_type = ? ORDER BY post_id " + orderBy;
        List postDTOS = this.jdbcTemplate.query(SQL, PostRepositoryImpl::mapRow, new Object[]{postType.toString()});
        return postDTOS;
    }

    public void deleteByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "UPDATE post SET deleted = 1, updated_at = ? WHERE post_id IN(%S)";
        ArrayList<Comparable<Date>> args = new ArrayList<Comparable<Date>>();
        args.add(Timestamp.valueOf(LocalDateTime.now()));
        args.addAll(ids);
        this.jdbcTemplate.update(String.format("UPDATE post SET deleted = 1, updated_at = ? WHERE post_id IN(%S)", inSql), args.toArray());
    }

    public void deleteAll() {
        String SQL = "UPDATE post SET deleted = 1, updated_at = ? ";
        this.jdbcTemplate.update("UPDATE post SET deleted = 1, updated_at = ? ", new Object[]{Timestamp.valueOf(LocalDateTime.now())});
    }

    public Page<PostDTO> findPageByPostTitle(String post_title, Set<String> post_types, Set<Long> postIdsByCategoryIds, Set<Long> postIdsByContentIds, Set<Long> postIdsByMoodIds, Set<Long> postIdsByStandardIds, Set<Long> postIdsByFavorite, Set<Long> last_post_ids, Pageable pageable) {
        String inSql;
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuilder projection = new StringBuilder();
        if (!AppUtils.isNullOrEmpty((String)post_title)) {
            args.add(post_title);
            projection.append("AND  ").append("CASE ").append("WHEN ").append("? IS NOT NULL ");
            if (Language.isSpanish()) {
                projection.append("THEN post_title_es LIKE '%");
            } else {
                projection.append("THEN post_title LIKE '%");
            }
            projection.append(post_title).append("%' ").append("ELSE true ").append("END ");
        }
        if (!AppUtils.isNullOrEmpty(post_types)) {
            args.add(post_types.size());
            args.addAll(post_types);
            inSql = String.join((CharSequence)",", Collections.nCopies(post_types.size(), "?"));
            projection.append("AND  ").append("CASE ").append("WHEN ").append("? > 0 ").append("THEN post_type IN(").append(String.format("%s) ", inSql)).append("ELSE true ").append("END ");
        }
        if (!AppUtils.isNullOrEmpty(postIdsByCategoryIds)) {
            args.add(postIdsByCategoryIds.size());
            args.addAll(postIdsByCategoryIds);
            inSql = String.join((CharSequence)",", Collections.nCopies(postIdsByCategoryIds.size(), "?"));
            projection.append("AND  ").append("CASE ").append("WHEN ").append("? > 0 ").append("THEN post_id IN(").append(String.format("%s) ", inSql)).append("ELSE true ").append("END ");
        }
        if (!AppUtils.isNullOrEmpty(postIdsByContentIds)) {
            args.add(postIdsByContentIds.size());
            args.addAll(postIdsByContentIds);
            inSql = String.join((CharSequence)",", Collections.nCopies(postIdsByContentIds.size(), "?"));
            projection.append("AND  ").append("CASE ").append("WHEN ").append("? > 0 ").append("THEN post_id IN(").append(String.format("%s) ", inSql)).append("ELSE true ").append("END ");
        }
        if (!AppUtils.isNullOrEmpty(postIdsByMoodIds)) {
            args.add(postIdsByMoodIds.size());
            args.addAll(postIdsByMoodIds);
            inSql = String.join((CharSequence)",", Collections.nCopies(postIdsByMoodIds.size(), "?"));
            projection.append("AND  ").append("CASE ").append("WHEN ").append("? > 0 ").append("THEN post_id IN(").append(String.format("%s) ", inSql)).append("ELSE true ").append("END ");
        }
        if (!AppUtils.isNullOrEmpty(postIdsByStandardIds)) {
            args.add(postIdsByStandardIds.size());
            args.addAll(postIdsByStandardIds);
            inSql = String.join((CharSequence)",", Collections.nCopies(postIdsByStandardIds.size(), "?"));
            projection.append("AND  ").append("CASE ").append("WHEN ").append("? > 0 ").append("THEN post_id IN(").append(String.format("%s) ", inSql)).append("ELSE true ").append("END ");
        }
        if (!AppUtils.isNullOrEmpty(postIdsByFavorite)) {
            args.add(postIdsByFavorite.size());
            args.addAll(postIdsByFavorite);
            inSql = String.join((CharSequence)",", Collections.nCopies(postIdsByFavorite.size(), "?"));
            projection.append("AND  ").append("CASE ").append("WHEN ").append("? > 0 ").append("THEN post_id IN(").append(String.format("%s) ", inSql)).append("ELSE true ").append("END ");
        }
        StringBuilder rowCountSql = new StringBuilder("SELECT count(1) AS row_count FROM post WHERE deleted = 0 ");
        if (!AppUtils.isNullOrEmpty((String)projection.toString())) {
            rowCountSql.append((CharSequence)projection);
        }
        Integer total = (Integer)this.jdbcTemplate.queryForObject(rowCountSql.toString(), args.toArray(), (rs, rowNum) -> rs.getInt(1));
        StringBuilder querySql = new StringBuilder("SELECT * FROM post WHERE deleted = 0 ");
        if (!AppUtils.isNullOrEmpty((String)projection.toString())) {
            querySql.append((CharSequence)projection);
        }
        if (last_post_ids != null) {
            if (!AppUtils.isNullOrEmpty(last_post_ids)) {
                args.addAll(last_post_ids);
                String inSql2 = String.join((CharSequence)",", Collections.nCopies(last_post_ids.size(), "?"));
                querySql.append(String.format("ORDER BY -FIELD(post_id,%S), rand() ", inSql2));
            } else {
                querySql.append("ORDER BY rand() ");
            }
        } else {
            for (Sort.Order order : pageable.getSort()) {
                System.out.println("Property: " + order.getProperty());
                System.out.println("Direction: " + order.getDirection());
                querySql.append("ORDER BY ").append(order.getProperty()).append(" ").append(order.getDirection()).append(" ");
            }
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(querySql.toString(), args.toArray(), PostRepositoryImpl::mapRow);
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }

    public void updateoEmbed_htmlById(long id, String oEmbed_html) {
        String SQL = "UPDATE post SET o_embed_html = ?, updated_at = ? WHERE post_id ?";
        this.jdbcTemplate.update("UPDATE post SET o_embed_html = ?, updated_at = ? WHERE post_id ?", new Object[]{oEmbed_html, Timestamp.valueOf(LocalDateTime.now()), id});
    }

    public List<PostDTO> get3RandomPostByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<PostDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM post WHERE deleted = 0 AND post_id IN(%S) ORDER BY rand() LIMIT 3 ";
        List postDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), PostRepositoryImpl::mapRow);
        return postDTOS;
    }

    public List<PostDTO> findByIdsAndPostType(Set<Long> postIds, String postType) {
        if (AppUtils.isNullOrEmpty(postIds)) {
            return Collections.emptyList();
        }
        String SQL = "SELECT * FROM post WHERE deleted = 0 AND post_id IN (:postIds) AND post_type = :postType";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("postIds", postIds);
        params.put("postType", postType);
        return this.namedParameterJdbcTemplate.query(SQL, params, PostRepositoryImpl::mapRow);
    }
}

